/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that describes how email sent during the predictive inbox placement test was handled by a certain email
 * provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IspPlacement implements SdkPojo, Serializable, ToCopyableBuilder<IspPlacement.Builder, IspPlacement> {
    private static final SdkField<String> ISP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IspName").getter(getter(IspPlacement::ispName)).setter(setter(Builder::ispName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IspName").build()).build();

    private static final SdkField<PlacementStatistics> PLACEMENT_STATISTICS_FIELD = SdkField
            .<PlacementStatistics> builder(MarshallingType.SDK_POJO).memberName("PlacementStatistics")
            .getter(getter(IspPlacement::placementStatistics)).setter(setter(Builder::placementStatistics))
            .constructor(PlacementStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementStatistics").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISP_NAME_FIELD,
            PLACEMENT_STATISTICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("IspName", ISP_NAME_FIELD);
                    put("PlacementStatistics", PLACEMENT_STATISTICS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String ispName;

    private final PlacementStatistics placementStatistics;

    private IspPlacement(BuilderImpl builder) {
        this.ispName = builder.ispName;
        this.placementStatistics = builder.placementStatistics;
    }

    /**
     * <p>
     * The name of the email provider that the inbox placement data applies to.
     * </p>
     * 
     * @return The name of the email provider that the inbox placement data applies to.
     */
    public final String ispName() {
        return ispName;
    }

    /**
     * <p>
     * An object that contains inbox placement metrics for a specific email provider.
     * </p>
     * 
     * @return An object that contains inbox placement metrics for a specific email provider.
     */
    public final PlacementStatistics placementStatistics() {
        return placementStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ispName());
        hashCode = 31 * hashCode + Objects.hashCode(placementStatistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IspPlacement)) {
            return false;
        }
        IspPlacement other = (IspPlacement) obj;
        return Objects.equals(ispName(), other.ispName()) && Objects.equals(placementStatistics(), other.placementStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IspPlacement").add("IspName", ispName()).add("PlacementStatistics", placementStatistics())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IspName":
            return Optional.ofNullable(clazz.cast(ispName()));
        case "PlacementStatistics":
            return Optional.ofNullable(clazz.cast(placementStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IspPlacement, T> g) {
        return obj -> g.apply((IspPlacement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IspPlacement> {
        /**
         * <p>
         * The name of the email provider that the inbox placement data applies to.
         * </p>
         * 
         * @param ispName
         *        The name of the email provider that the inbox placement data applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ispName(String ispName);

        /**
         * <p>
         * An object that contains inbox placement metrics for a specific email provider.
         * </p>
         * 
         * @param placementStatistics
         *        An object that contains inbox placement metrics for a specific email provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStatistics(PlacementStatistics placementStatistics);

        /**
         * <p>
         * An object that contains inbox placement metrics for a specific email provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link PlacementStatistics.Builder} avoiding the
         * need to create one manually via {@link PlacementStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PlacementStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #placementStatistics(PlacementStatistics)}.
         * 
         * @param placementStatistics
         *        a consumer that will call methods on {@link PlacementStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementStatistics(PlacementStatistics)
         */
        default Builder placementStatistics(Consumer<PlacementStatistics.Builder> placementStatistics) {
            return placementStatistics(PlacementStatistics.builder().applyMutation(placementStatistics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String ispName;

        private PlacementStatistics placementStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(IspPlacement model) {
            ispName(model.ispName);
            placementStatistics(model.placementStatistics);
        }

        public final String getIspName() {
            return ispName;
        }

        public final void setIspName(String ispName) {
            this.ispName = ispName;
        }

        @Override
        public final Builder ispName(String ispName) {
            this.ispName = ispName;
            return this;
        }

        public final PlacementStatistics.Builder getPlacementStatistics() {
            return placementStatistics != null ? placementStatistics.toBuilder() : null;
        }

        public final void setPlacementStatistics(PlacementStatistics.BuilderImpl placementStatistics) {
            this.placementStatistics = placementStatistics != null ? placementStatistics.build() : null;
        }

        @Override
        public final Builder placementStatistics(PlacementStatistics placementStatistics) {
            this.placementStatistics = placementStatistics;
            return this;
        }

        @Override
        public IspPlacement build() {
            return new IspPlacement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
