/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains details about the resource destination the import job is going to target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportDestination.Builder, ImportDestination> {
    private static final SdkField<SuppressionListDestination> SUPPRESSION_LIST_DESTINATION_FIELD = SdkField
            .<SuppressionListDestination> builder(MarshallingType.SDK_POJO)
            .memberName("SuppressionListDestination")
            .getter(getter(ImportDestination::suppressionListDestination))
            .setter(setter(Builder::suppressionListDestination))
            .constructor(SuppressionListDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressionListDestination").build())
            .build();

    private static final SdkField<ContactListDestination> CONTACT_LIST_DESTINATION_FIELD = SdkField
            .<ContactListDestination> builder(MarshallingType.SDK_POJO).memberName("ContactListDestination")
            .getter(getter(ImportDestination::contactListDestination)).setter(setter(Builder::contactListDestination))
            .constructor(ContactListDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactListDestination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUPPRESSION_LIST_DESTINATION_FIELD, CONTACT_LIST_DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SuppressionListDestination", SUPPRESSION_LIST_DESTINATION_FIELD);
                    put("ContactListDestination", CONTACT_LIST_DESTINATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final SuppressionListDestination suppressionListDestination;

    private final ContactListDestination contactListDestination;

    private ImportDestination(BuilderImpl builder) {
        this.suppressionListDestination = builder.suppressionListDestination;
        this.contactListDestination = builder.contactListDestination;
    }

    /**
     * <p>
     * An object that contains the action of the import job towards suppression list.
     * </p>
     * 
     * @return An object that contains the action of the import job towards suppression list.
     */
    public final SuppressionListDestination suppressionListDestination() {
        return suppressionListDestination;
    }

    /**
     * <p>
     * An object that contains the action of the import job towards a contact list.
     * </p>
     * 
     * @return An object that contains the action of the import job towards a contact list.
     */
    public final ContactListDestination contactListDestination() {
        return contactListDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(suppressionListDestination());
        hashCode = 31 * hashCode + Objects.hashCode(contactListDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportDestination)) {
            return false;
        }
        ImportDestination other = (ImportDestination) obj;
        return Objects.equals(suppressionListDestination(), other.suppressionListDestination())
                && Objects.equals(contactListDestination(), other.contactListDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportDestination").add("SuppressionListDestination", suppressionListDestination())
                .add("ContactListDestination", contactListDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuppressionListDestination":
            return Optional.ofNullable(clazz.cast(suppressionListDestination()));
        case "ContactListDestination":
            return Optional.ofNullable(clazz.cast(contactListDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportDestination, T> g) {
        return obj -> g.apply((ImportDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportDestination> {
        /**
         * <p>
         * An object that contains the action of the import job towards suppression list.
         * </p>
         * 
         * @param suppressionListDestination
         *        An object that contains the action of the import job towards suppression list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressionListDestination(SuppressionListDestination suppressionListDestination);

        /**
         * <p>
         * An object that contains the action of the import job towards suppression list.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuppressionListDestination.Builder}
         * avoiding the need to create one manually via {@link SuppressionListDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuppressionListDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #suppressionListDestination(SuppressionListDestination)}.
         * 
         * @param suppressionListDestination
         *        a consumer that will call methods on {@link SuppressionListDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suppressionListDestination(SuppressionListDestination)
         */
        default Builder suppressionListDestination(Consumer<SuppressionListDestination.Builder> suppressionListDestination) {
            return suppressionListDestination(SuppressionListDestination.builder().applyMutation(suppressionListDestination)
                    .build());
        }

        /**
         * <p>
         * An object that contains the action of the import job towards a contact list.
         * </p>
         * 
         * @param contactListDestination
         *        An object that contains the action of the import job towards a contact list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactListDestination(ContactListDestination contactListDestination);

        /**
         * <p>
         * An object that contains the action of the import job towards a contact list.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactListDestination.Builder} avoiding
         * the need to create one manually via {@link ContactListDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactListDestination.Builder#build()} is called immediately and
         * its result is passed to {@link #contactListDestination(ContactListDestination)}.
         * 
         * @param contactListDestination
         *        a consumer that will call methods on {@link ContactListDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactListDestination(ContactListDestination)
         */
        default Builder contactListDestination(Consumer<ContactListDestination.Builder> contactListDestination) {
            return contactListDestination(ContactListDestination.builder().applyMutation(contactListDestination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SuppressionListDestination suppressionListDestination;

        private ContactListDestination contactListDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportDestination model) {
            suppressionListDestination(model.suppressionListDestination);
            contactListDestination(model.contactListDestination);
        }

        public final SuppressionListDestination.Builder getSuppressionListDestination() {
            return suppressionListDestination != null ? suppressionListDestination.toBuilder() : null;
        }

        public final void setSuppressionListDestination(SuppressionListDestination.BuilderImpl suppressionListDestination) {
            this.suppressionListDestination = suppressionListDestination != null ? suppressionListDestination.build() : null;
        }

        @Override
        public final Builder suppressionListDestination(SuppressionListDestination suppressionListDestination) {
            this.suppressionListDestination = suppressionListDestination;
            return this;
        }

        public final ContactListDestination.Builder getContactListDestination() {
            return contactListDestination != null ? contactListDestination.toBuilder() : null;
        }

        public final void setContactListDestination(ContactListDestination.BuilderImpl contactListDestination) {
            this.contactListDestination = contactListDestination != null ? contactListDestination.build() : null;
        }

        @Override
        public final Builder contactListDestination(ContactListDestination contactListDestination) {
            this.contactListDestination = contactListDestination;
            return this;
        }

        @Override
        public ImportDestination build() {
            return new ImportDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
