/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An HTTP 200 response if the request succeeds, or an error message if the request fails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExportJobResponse extends SesV2Response implements
        ToCopyableBuilder<GetExportJobResponse.Builder, GetExportJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(GetExportJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> EXPORT_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportSourceType").getter(getter(GetExportJobResponse::exportSourceTypeAsString))
            .setter(setter(Builder::exportSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSourceType").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(GetExportJobResponse::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<ExportDestination> EXPORT_DESTINATION_FIELD = SdkField
            .<ExportDestination> builder(MarshallingType.SDK_POJO).memberName("ExportDestination")
            .getter(getter(GetExportJobResponse::exportDestination)).setter(setter(Builder::exportDestination))
            .constructor(ExportDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportDestination").build()).build();

    private static final SdkField<ExportDataSource> EXPORT_DATA_SOURCE_FIELD = SdkField
            .<ExportDataSource> builder(MarshallingType.SDK_POJO).memberName("ExportDataSource")
            .getter(getter(GetExportJobResponse::exportDataSource)).setter(setter(Builder::exportDataSource))
            .constructor(ExportDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportDataSource").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(GetExportJobResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> COMPLETED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedTimestamp").getter(getter(GetExportJobResponse::completedTimestamp))
            .setter(setter(Builder::completedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedTimestamp").build())
            .build();

    private static final SdkField<FailureInfo> FAILURE_INFO_FIELD = SdkField.<FailureInfo> builder(MarshallingType.SDK_POJO)
            .memberName("FailureInfo").getter(getter(GetExportJobResponse::failureInfo)).setter(setter(Builder::failureInfo))
            .constructor(FailureInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureInfo").build()).build();

    private static final SdkField<ExportStatistics> STATISTICS_FIELD = SdkField
            .<ExportStatistics> builder(MarshallingType.SDK_POJO).memberName("Statistics")
            .getter(getter(GetExportJobResponse::statistics)).setter(setter(Builder::statistics))
            .constructor(ExportStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            EXPORT_SOURCE_TYPE_FIELD, JOB_STATUS_FIELD, EXPORT_DESTINATION_FIELD, EXPORT_DATA_SOURCE_FIELD,
            CREATED_TIMESTAMP_FIELD, COMPLETED_TIMESTAMP_FIELD, FAILURE_INFO_FIELD, STATISTICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("JobId", JOB_ID_FIELD);
                    put("ExportSourceType", EXPORT_SOURCE_TYPE_FIELD);
                    put("JobStatus", JOB_STATUS_FIELD);
                    put("ExportDestination", EXPORT_DESTINATION_FIELD);
                    put("ExportDataSource", EXPORT_DATA_SOURCE_FIELD);
                    put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
                    put("CompletedTimestamp", COMPLETED_TIMESTAMP_FIELD);
                    put("FailureInfo", FAILURE_INFO_FIELD);
                    put("Statistics", STATISTICS_FIELD);
                }
            });

    private final String jobId;

    private final String exportSourceType;

    private final String jobStatus;

    private final ExportDestination exportDestination;

    private final ExportDataSource exportDataSource;

    private final Instant createdTimestamp;

    private final Instant completedTimestamp;

    private final FailureInfo failureInfo;

    private final ExportStatistics statistics;

    private GetExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.exportSourceType = builder.exportSourceType;
        this.jobStatus = builder.jobStatus;
        this.exportDestination = builder.exportDestination;
        this.exportDataSource = builder.exportDataSource;
        this.createdTimestamp = builder.createdTimestamp;
        this.completedTimestamp = builder.completedTimestamp;
        this.failureInfo = builder.failureInfo;
        this.statistics = builder.statistics;
    }

    /**
     * <p>
     * The export job ID.
     * </p>
     * 
     * @return The export job ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The type of source of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportSourceType}
     * will return {@link ExportSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportSourceTypeAsString}.
     * </p>
     * 
     * @return The type of source of the export job.
     * @see ExportSourceType
     */
    public final ExportSourceType exportSourceType() {
        return ExportSourceType.fromValue(exportSourceType);
    }

    /**
     * <p>
     * The type of source of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportSourceType}
     * will return {@link ExportSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportSourceTypeAsString}.
     * </p>
     * 
     * @return The type of source of the export job.
     * @see ExportSourceType
     */
    public final String exportSourceTypeAsString() {
        return exportSourceType;
    }

    /**
     * <p>
     * The status of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the export job.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The status of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the export job.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The destination of the export job.
     * </p>
     * 
     * @return The destination of the export job.
     */
    public final ExportDestination exportDestination() {
        return exportDestination;
    }

    /**
     * <p>
     * The data source of the export job.
     * </p>
     * 
     * @return The data source of the export job.
     */
    public final ExportDataSource exportDataSource() {
        return exportDataSource;
    }

    /**
     * <p>
     * The timestamp of when the export job was created.
     * </p>
     * 
     * @return The timestamp of when the export job was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The timestamp of when the export job was completed.
     * </p>
     * 
     * @return The timestamp of when the export job was completed.
     */
    public final Instant completedTimestamp() {
        return completedTimestamp;
    }

    /**
     * <p>
     * The failure details about an export job.
     * </p>
     * 
     * @return The failure details about an export job.
     */
    public final FailureInfo failureInfo() {
        return failureInfo;
    }

    /**
     * <p>
     * The statistics about the export job.
     * </p>
     * 
     * @return The statistics about the export job.
     */
    public final ExportStatistics statistics() {
        return statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(exportSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportDestination());
        hashCode = 31 * hashCode + Objects.hashCode(exportDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(completedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(failureInfo());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportJobResponse)) {
            return false;
        }
        GetExportJobResponse other = (GetExportJobResponse) obj;
        return Objects.equals(jobId(), other.jobId())
                && Objects.equals(exportSourceTypeAsString(), other.exportSourceTypeAsString())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(exportDestination(), other.exportDestination())
                && Objects.equals(exportDataSource(), other.exportDataSource())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(completedTimestamp(), other.completedTimestamp())
                && Objects.equals(failureInfo(), other.failureInfo()) && Objects.equals(statistics(), other.statistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExportJobResponse").add("JobId", jobId()).add("ExportSourceType", exportSourceTypeAsString())
                .add("JobStatus", jobStatusAsString()).add("ExportDestination", exportDestination())
                .add("ExportDataSource", exportDataSource()).add("CreatedTimestamp", createdTimestamp())
                .add("CompletedTimestamp", completedTimestamp()).add("FailureInfo", failureInfo())
                .add("Statistics", statistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "ExportSourceType":
            return Optional.ofNullable(clazz.cast(exportSourceTypeAsString()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "ExportDestination":
            return Optional.ofNullable(clazz.cast(exportDestination()));
        case "ExportDataSource":
            return Optional.ofNullable(clazz.cast(exportDataSource()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "CompletedTimestamp":
            return Optional.ofNullable(clazz.cast(completedTimestamp()));
        case "FailureInfo":
            return Optional.ofNullable(clazz.cast(failureInfo()));
        case "Statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetExportJobResponse, T> g) {
        return obj -> g.apply((GetExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetExportJobResponse> {
        /**
         * <p>
         * The export job ID.
         * </p>
         * 
         * @param jobId
         *        The export job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The type of source of the export job.
         * </p>
         * 
         * @param exportSourceType
         *        The type of source of the export job.
         * @see ExportSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportSourceType
         */
        Builder exportSourceType(String exportSourceType);

        /**
         * <p>
         * The type of source of the export job.
         * </p>
         * 
         * @param exportSourceType
         *        The type of source of the export job.
         * @see ExportSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportSourceType
         */
        Builder exportSourceType(ExportSourceType exportSourceType);

        /**
         * <p>
         * The status of the export job.
         * </p>
         * 
         * @param jobStatus
         *        The status of the export job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The status of the export job.
         * </p>
         * 
         * @param jobStatus
         *        The status of the export job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The destination of the export job.
         * </p>
         * 
         * @param exportDestination
         *        The destination of the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDestination(ExportDestination exportDestination);

        /**
         * <p>
         * The destination of the export job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportDestination.Builder} avoiding the
         * need to create one manually via {@link ExportDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #exportDestination(ExportDestination)}.
         * 
         * @param exportDestination
         *        a consumer that will call methods on {@link ExportDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportDestination(ExportDestination)
         */
        default Builder exportDestination(Consumer<ExportDestination.Builder> exportDestination) {
            return exportDestination(ExportDestination.builder().applyMutation(exportDestination).build());
        }

        /**
         * <p>
         * The data source of the export job.
         * </p>
         * 
         * @param exportDataSource
         *        The data source of the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDataSource(ExportDataSource exportDataSource);

        /**
         * <p>
         * The data source of the export job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportDataSource.Builder} avoiding the
         * need to create one manually via {@link ExportDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #exportDataSource(ExportDataSource)}.
         * 
         * @param exportDataSource
         *        a consumer that will call methods on {@link ExportDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportDataSource(ExportDataSource)
         */
        default Builder exportDataSource(Consumer<ExportDataSource.Builder> exportDataSource) {
            return exportDataSource(ExportDataSource.builder().applyMutation(exportDataSource).build());
        }

        /**
         * <p>
         * The timestamp of when the export job was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp of when the export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The timestamp of when the export job was completed.
         * </p>
         * 
         * @param completedTimestamp
         *        The timestamp of when the export job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedTimestamp(Instant completedTimestamp);

        /**
         * <p>
         * The failure details about an export job.
         * </p>
         * 
         * @param failureInfo
         *        The failure details about an export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureInfo(FailureInfo failureInfo);

        /**
         * <p>
         * The failure details about an export job.
         * </p>
         * This is a convenience method that creates an instance of the {@link FailureInfo.Builder} avoiding the need to
         * create one manually via {@link FailureInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailureInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #failureInfo(FailureInfo)}.
         * 
         * @param failureInfo
         *        a consumer that will call methods on {@link FailureInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureInfo(FailureInfo)
         */
        default Builder failureInfo(Consumer<FailureInfo.Builder> failureInfo) {
            return failureInfo(FailureInfo.builder().applyMutation(failureInfo).build());
        }

        /**
         * <p>
         * The statistics about the export job.
         * </p>
         * 
         * @param statistics
         *        The statistics about the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(ExportStatistics statistics);

        /**
         * <p>
         * The statistics about the export job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportStatistics.Builder} avoiding the
         * need to create one manually via {@link ExportStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #statistics(ExportStatistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link ExportStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(ExportStatistics)
         */
        default Builder statistics(Consumer<ExportStatistics.Builder> statistics) {
            return statistics(ExportStatistics.builder().applyMutation(statistics).build());
        }
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private String jobId;

        private String exportSourceType;

        private String jobStatus;

        private ExportDestination exportDestination;

        private ExportDataSource exportDataSource;

        private Instant createdTimestamp;

        private Instant completedTimestamp;

        private FailureInfo failureInfo;

        private ExportStatistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportJobResponse model) {
            super(model);
            jobId(model.jobId);
            exportSourceType(model.exportSourceType);
            jobStatus(model.jobStatus);
            exportDestination(model.exportDestination);
            exportDataSource(model.exportDataSource);
            createdTimestamp(model.createdTimestamp);
            completedTimestamp(model.completedTimestamp);
            failureInfo(model.failureInfo);
            statistics(model.statistics);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getExportSourceType() {
            return exportSourceType;
        }

        public final void setExportSourceType(String exportSourceType) {
            this.exportSourceType = exportSourceType;
        }

        @Override
        public final Builder exportSourceType(String exportSourceType) {
            this.exportSourceType = exportSourceType;
            return this;
        }

        @Override
        public final Builder exportSourceType(ExportSourceType exportSourceType) {
            this.exportSourceType(exportSourceType == null ? null : exportSourceType.toString());
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final ExportDestination.Builder getExportDestination() {
            return exportDestination != null ? exportDestination.toBuilder() : null;
        }

        public final void setExportDestination(ExportDestination.BuilderImpl exportDestination) {
            this.exportDestination = exportDestination != null ? exportDestination.build() : null;
        }

        @Override
        public final Builder exportDestination(ExportDestination exportDestination) {
            this.exportDestination = exportDestination;
            return this;
        }

        public final ExportDataSource.Builder getExportDataSource() {
            return exportDataSource != null ? exportDataSource.toBuilder() : null;
        }

        public final void setExportDataSource(ExportDataSource.BuilderImpl exportDataSource) {
            this.exportDataSource = exportDataSource != null ? exportDataSource.build() : null;
        }

        @Override
        public final Builder exportDataSource(ExportDataSource exportDataSource) {
            this.exportDataSource = exportDataSource;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getCompletedTimestamp() {
            return completedTimestamp;
        }

        public final void setCompletedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
        }

        @Override
        public final Builder completedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
            return this;
        }

        public final FailureInfo.Builder getFailureInfo() {
            return failureInfo != null ? failureInfo.toBuilder() : null;
        }

        public final void setFailureInfo(FailureInfo.BuilderImpl failureInfo) {
            this.failureInfo = failureInfo != null ? failureInfo.build() : null;
        }

        @Override
        public final Builder failureInfo(FailureInfo failureInfo) {
            this.failureInfo = failureInfo;
            return this;
        }

        public final ExportStatistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        public final void setStatistics(ExportStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(ExportStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        @Override
        public GetExportJobResponse build() {
            return new GetExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
