/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest;
import software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse;

public class ListImportJobsIterable
implements SdkIterable<ListImportJobsResponse> {
    private final SesV2Client client;
    private final ListImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImportJobsIterable(SesV2Client client, ListImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImportJobsResponseFetcher();
    }

    public Iterator<ListImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListImportJobsResponseFetcher
    implements SyncPageFetcher<ListImportJobsResponse> {
        private ListImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImportJobsResponse nextPage(ListImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListImportJobsIterable.this.client.listImportJobs(ListImportJobsIterable.this.firstRequest);
            }
            return ListImportJobsIterable.this.client.listImportJobs((ListImportJobsRequest)((Object)ListImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

