/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMessageInsightsResponse extends SesV2Response implements
        ToCopyableBuilder<GetMessageInsightsResponse.Builder, GetMessageInsightsResponse> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(GetMessageInsightsResponse::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final SdkField<String> FROM_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromEmailAddress").getter(getter(GetMessageInsightsResponse::fromEmailAddress))
            .setter(setter(Builder::fromEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(GetMessageInsightsResponse::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<List<MessageTag>> EMAIL_TAGS_FIELD = SdkField
            .<List<MessageTag>> builder(MarshallingType.LIST)
            .memberName("EmailTags")
            .getter(getter(GetMessageInsightsResponse::emailTags))
            .setter(setter(Builder::emailTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EmailInsights>> INSIGHTS_FIELD = SdkField
            .<List<EmailInsights>> builder(MarshallingType.LIST)
            .memberName("Insights")
            .getter(getter(GetMessageInsightsResponse::insights))
            .setter(setter(Builder::insights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insights").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EmailInsights> builder(MarshallingType.SDK_POJO)
                                            .constructor(EmailInsights::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD,
            FROM_EMAIL_ADDRESS_FIELD, SUBJECT_FIELD, EMAIL_TAGS_FIELD, INSIGHTS_FIELD));

    private final String messageId;

    private final String fromEmailAddress;

    private final String subject;

    private final List<MessageTag> emailTags;

    private final List<EmailInsights> insights;

    private GetMessageInsightsResponse(BuilderImpl builder) {
        super(builder);
        this.messageId = builder.messageId;
        this.fromEmailAddress = builder.fromEmailAddress;
        this.subject = builder.subject;
        this.emailTags = builder.emailTags;
        this.insights = builder.insights;
    }

    /**
     * <p>
     * A unique identifier for the message.
     * </p>
     * 
     * @return A unique identifier for the message.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The from address used to send the message.
     * </p>
     * 
     * @return The from address used to send the message.
     */
    public final String fromEmailAddress() {
        return fromEmailAddress;
    }

    /**
     * <p>
     * The subject line of the message.
     * </p>
     * 
     * @return The subject line of the message.
     */
    public final String subject() {
        return subject;
    }

    /**
     * For responses, this returns true if the service returned a value for the EmailTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEmailTags() {
        return emailTags != null && !(emailTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags, in the form of name/value pairs, that were applied to the email you sent, along with Amazon SES
     * <a href="https://docs.aws.amazon.com/ses/latest/dg/monitor-using-event-publishing.html">Auto-Tags</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmailTags} method.
     * </p>
     * 
     * @return A list of tags, in the form of name/value pairs, that were applied to the email you sent, along with
     *         Amazon SES <a
     *         href="https://docs.aws.amazon.com/ses/latest/dg/monitor-using-event-publishing.html">Auto-Tags</a>.
     */
    public final List<MessageTag> emailTags() {
        return emailTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Insights property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInsights() {
        return insights != null && !(insights instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of insights associated with the message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsights} method.
     * </p>
     * 
     * @return A set of insights associated with the message.
     */
    public final List<EmailInsights> insights() {
        return insights;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(hasEmailTags() ? emailTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInsights() ? insights() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMessageInsightsResponse)) {
            return false;
        }
        GetMessageInsightsResponse other = (GetMessageInsightsResponse) obj;
        return Objects.equals(messageId(), other.messageId()) && Objects.equals(fromEmailAddress(), other.fromEmailAddress())
                && Objects.equals(subject(), other.subject()) && hasEmailTags() == other.hasEmailTags()
                && Objects.equals(emailTags(), other.emailTags()) && hasInsights() == other.hasInsights()
                && Objects.equals(insights(), other.insights());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMessageInsightsResponse").add("MessageId", messageId())
                .add("FromEmailAddress", fromEmailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Subject", subject() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EmailTags", hasEmailTags() ? emailTags() : null).add("Insights", hasInsights() ? insights() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "FromEmailAddress":
            return Optional.ofNullable(clazz.cast(fromEmailAddress()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "EmailTags":
            return Optional.ofNullable(clazz.cast(emailTags()));
        case "Insights":
            return Optional.ofNullable(clazz.cast(insights()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMessageInsightsResponse, T> g) {
        return obj -> g.apply((GetMessageInsightsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetMessageInsightsResponse> {
        /**
         * <p>
         * A unique identifier for the message.
         * </p>
         * 
         * @param messageId
         *        A unique identifier for the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The from address used to send the message.
         * </p>
         * 
         * @param fromEmailAddress
         *        The from address used to send the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromEmailAddress(String fromEmailAddress);

        /**
         * <p>
         * The subject line of the message.
         * </p>
         * 
         * @param subject
         *        The subject line of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, that were applied to the email you sent, along with Amazon
         * SES <a href="https://docs.aws.amazon.com/ses/latest/dg/monitor-using-event-publishing.html">Auto-Tags</a>.
         * </p>
         * 
         * @param emailTags
         *        A list of tags, in the form of name/value pairs, that were applied to the email you sent, along with
         *        Amazon SES <a
         *        href="https://docs.aws.amazon.com/ses/latest/dg/monitor-using-event-publishing.html">Auto-Tags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailTags(Collection<MessageTag> emailTags);

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, that were applied to the email you sent, along with Amazon
         * SES <a href="https://docs.aws.amazon.com/ses/latest/dg/monitor-using-event-publishing.html">Auto-Tags</a>.
         * </p>
         * 
         * @param emailTags
         *        A list of tags, in the form of name/value pairs, that were applied to the email you sent, along with
         *        Amazon SES <a
         *        href="https://docs.aws.amazon.com/ses/latest/dg/monitor-using-event-publishing.html">Auto-Tags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailTags(MessageTag... emailTags);

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, that were applied to the email you sent, along with Amazon
         * SES <a href="https://docs.aws.amazon.com/ses/latest/dg/monitor-using-event-publishing.html">Auto-Tags</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.MessageTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.MessageTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.MessageTag.Builder#build()} is called immediately and its
         * result is passed to {@link #emailTags(List<MessageTag>)}.
         * 
         * @param emailTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.MessageTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailTags(java.util.Collection<MessageTag>)
         */
        Builder emailTags(Consumer<MessageTag.Builder>... emailTags);

        /**
         * <p>
         * A set of insights associated with the message.
         * </p>
         * 
         * @param insights
         *        A set of insights associated with the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insights(Collection<EmailInsights> insights);

        /**
         * <p>
         * A set of insights associated with the message.
         * </p>
         * 
         * @param insights
         *        A set of insights associated with the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insights(EmailInsights... insights);

        /**
         * <p>
         * A set of insights associated with the message.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.EmailInsights.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.EmailInsights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.EmailInsights.Builder#build()} is called immediately and
         * its result is passed to {@link #insights(List<EmailInsights>)}.
         * 
         * @param insights
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.EmailInsights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insights(java.util.Collection<EmailInsights>)
         */
        Builder insights(Consumer<EmailInsights.Builder>... insights);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private String messageId;

        private String fromEmailAddress;

        private String subject;

        private List<MessageTag> emailTags = DefaultSdkAutoConstructList.getInstance();

        private List<EmailInsights> insights = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMessageInsightsResponse model) {
            super(model);
            messageId(model.messageId);
            fromEmailAddress(model.fromEmailAddress);
            subject(model.subject);
            emailTags(model.emailTags);
            insights(model.insights);
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getFromEmailAddress() {
            return fromEmailAddress;
        }

        public final void setFromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
        }

        @Override
        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final List<MessageTag.Builder> getEmailTags() {
            List<MessageTag.Builder> result = MessageTagListCopier.copyToBuilder(this.emailTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmailTags(Collection<MessageTag.BuilderImpl> emailTags) {
            this.emailTags = MessageTagListCopier.copyFromBuilder(emailTags);
        }

        @Override
        public final Builder emailTags(Collection<MessageTag> emailTags) {
            this.emailTags = MessageTagListCopier.copy(emailTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailTags(MessageTag... emailTags) {
            emailTags(Arrays.asList(emailTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailTags(Consumer<MessageTag.Builder>... emailTags) {
            emailTags(Stream.of(emailTags).map(c -> MessageTag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EmailInsights.Builder> getInsights() {
            List<EmailInsights.Builder> result = EmailInsightsListCopier.copyToBuilder(this.insights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsights(Collection<EmailInsights.BuilderImpl> insights) {
            this.insights = EmailInsightsListCopier.copyFromBuilder(insights);
        }

        @Override
        public final Builder insights(Collection<EmailInsights> insights) {
            this.insights = EmailInsightsListCopier.copy(insights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insights(EmailInsights... insights) {
            insights(Arrays.asList(insights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insights(Consumer<EmailInsights.Builder>... insights) {
            insights(Stream.of(insights).map(c -> EmailInsights.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMessageInsightsResponse build() {
            return new GetMessageInsightsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
