/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of receipt rule sets that exist under your Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReceiptRuleSetsResponse extends SesResponse implements
        ToCopyableBuilder<ListReceiptRuleSetsResponse.Builder, ListReceiptRuleSetsResponse> {
    private static final SdkField<List<ReceiptRuleSetMetadata>> RULE_SETS_FIELD = SdkField
            .<List<ReceiptRuleSetMetadata>> builder(MarshallingType.LIST)
            .memberName("RuleSets")
            .getter(getter(ListReceiptRuleSetsResponse::ruleSets))
            .setter(setter(Builder::ruleSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReceiptRuleSetMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReceiptRuleSetMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListReceiptRuleSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SETS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ReceiptRuleSetMetadata> ruleSets;

    private final String nextToken;

    private ListReceiptRuleSetsResponse(BuilderImpl builder) {
        super(builder);
        this.ruleSets = builder.ruleSets;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRuleSets() {
        return ruleSets != null && !(ruleSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata for the currently active receipt rule set. The metadata consists of the rule set name and the
     * timestamp of when the rule set was created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleSets} method.
     * </p>
     * 
     * @return The metadata for the currently active receipt rule set. The metadata consists of the rule set name and
     *         the timestamp of when the rule set was created.
     */
    public final List<ReceiptRuleSetMetadata> ruleSets() {
        return ruleSets;
    }

    /**
     * <p>
     * A token indicating that there are additional receipt rule sets available to be listed. Pass this token to
     * successive calls of <code>ListReceiptRuleSets</code> to retrieve up to 100 receipt rule sets at a time.
     * </p>
     * 
     * @return A token indicating that there are additional receipt rule sets available to be listed. Pass this token to
     *         successive calls of <code>ListReceiptRuleSets</code> to retrieve up to 100 receipt rule sets at a time.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleSets() ? ruleSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReceiptRuleSetsResponse)) {
            return false;
        }
        ListReceiptRuleSetsResponse other = (ListReceiptRuleSetsResponse) obj;
        return hasRuleSets() == other.hasRuleSets() && Objects.equals(ruleSets(), other.ruleSets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReceiptRuleSetsResponse").add("RuleSets", hasRuleSets() ? ruleSets() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSets":
            return Optional.ofNullable(clazz.cast(ruleSets()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleSets", RULE_SETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReceiptRuleSetsResponse, T> g) {
        return obj -> g.apply((ListReceiptRuleSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListReceiptRuleSetsResponse> {
        /**
         * <p>
         * The metadata for the currently active receipt rule set. The metadata consists of the rule set name and the
         * timestamp of when the rule set was created.
         * </p>
         * 
         * @param ruleSets
         *        The metadata for the currently active receipt rule set. The metadata consists of the rule set name and
         *        the timestamp of when the rule set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSets(Collection<ReceiptRuleSetMetadata> ruleSets);

        /**
         * <p>
         * The metadata for the currently active receipt rule set. The metadata consists of the rule set name and the
         * timestamp of when the rule set was created.
         * </p>
         * 
         * @param ruleSets
         *        The metadata for the currently active receipt rule set. The metadata consists of the rule set name and
         *        the timestamp of when the rule set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSets(ReceiptRuleSetMetadata... ruleSets);

        /**
         * <p>
         * The metadata for the currently active receipt rule set. The metadata consists of the rule set name and the
         * timestamp of when the rule set was created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ses.model.ReceiptRuleSetMetadata.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ses.model.ReceiptRuleSetMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ses.model.ReceiptRuleSetMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #ruleSets(List<ReceiptRuleSetMetadata>)}.
         * 
         * @param ruleSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ses.model.ReceiptRuleSetMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleSets(java.util.Collection<ReceiptRuleSetMetadata>)
         */
        Builder ruleSets(Consumer<ReceiptRuleSetMetadata.Builder>... ruleSets);

        /**
         * <p>
         * A token indicating that there are additional receipt rule sets available to be listed. Pass this token to
         * successive calls of <code>ListReceiptRuleSets</code> to retrieve up to 100 receipt rule sets at a time.
         * </p>
         * 
         * @param nextToken
         *        A token indicating that there are additional receipt rule sets available to be listed. Pass this token
         *        to successive calls of <code>ListReceiptRuleSets</code> to retrieve up to 100 receipt rule sets at a
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private List<ReceiptRuleSetMetadata> ruleSets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReceiptRuleSetsResponse model) {
            super(model);
            ruleSets(model.ruleSets);
            nextToken(model.nextToken);
        }

        public final List<ReceiptRuleSetMetadata.Builder> getRuleSets() {
            List<ReceiptRuleSetMetadata.Builder> result = ReceiptRuleSetsListsCopier.copyToBuilder(this.ruleSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleSets(Collection<ReceiptRuleSetMetadata.BuilderImpl> ruleSets) {
            this.ruleSets = ReceiptRuleSetsListsCopier.copyFromBuilder(ruleSets);
        }

        @Override
        public final Builder ruleSets(Collection<ReceiptRuleSetMetadata> ruleSets) {
            this.ruleSets = ReceiptRuleSetsListsCopier.copy(ruleSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSets(ReceiptRuleSetMetadata... ruleSets) {
            ruleSets(Arrays.asList(ruleSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSets(Consumer<ReceiptRuleSetMetadata.Builder>... ruleSets) {
            ruleSets(Stream.of(ruleSets).map(c -> ReceiptRuleSetMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReceiptRuleSetsResponse build() {
            return new ListReceiptRuleSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
