/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the notification attributes for a list of identities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdentityNotificationAttributesResponse extends SesResponse implements
        ToCopyableBuilder<GetIdentityNotificationAttributesResponse.Builder, GetIdentityNotificationAttributesResponse> {
    private static final SdkField<Map<String, IdentityNotificationAttributes>> NOTIFICATION_ATTRIBUTES_FIELD = SdkField
            .<Map<String, IdentityNotificationAttributes>> builder(MarshallingType.MAP)
            .memberName("NotificationAttributes")
            .getter(getter(GetIdentityNotificationAttributesResponse::notificationAttributes))
            .setter(setter(Builder::notificationAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<IdentityNotificationAttributes> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityNotificationAttributes::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NOTIFICATION_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, IdentityNotificationAttributes> notificationAttributes;

    private GetIdentityNotificationAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.notificationAttributes = builder.notificationAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationAttributes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNotificationAttributes() {
        return notificationAttributes != null && !(notificationAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of Identity to IdentityNotificationAttributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationAttributes} method.
     * </p>
     * 
     * @return A map of Identity to IdentityNotificationAttributes.
     */
    public final Map<String, IdentityNotificationAttributes> notificationAttributes() {
        return notificationAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationAttributes() ? notificationAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityNotificationAttributesResponse)) {
            return false;
        }
        GetIdentityNotificationAttributesResponse other = (GetIdentityNotificationAttributesResponse) obj;
        return hasNotificationAttributes() == other.hasNotificationAttributes()
                && Objects.equals(notificationAttributes(), other.notificationAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIdentityNotificationAttributesResponse")
                .add("NotificationAttributes", hasNotificationAttributes() ? notificationAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotificationAttributes":
            return Optional.ofNullable(clazz.cast(notificationAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NotificationAttributes", NOTIFICATION_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityNotificationAttributesResponse, T> g) {
        return obj -> g.apply((GetIdentityNotificationAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIdentityNotificationAttributesResponse> {
        /**
         * <p>
         * A map of Identity to IdentityNotificationAttributes.
         * </p>
         * 
         * @param notificationAttributes
         *        A map of Identity to IdentityNotificationAttributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationAttributes(Map<String, IdentityNotificationAttributes> notificationAttributes);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private Map<String, IdentityNotificationAttributes> notificationAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityNotificationAttributesResponse model) {
            super(model);
            notificationAttributes(model.notificationAttributes);
        }

        public final Map<String, IdentityNotificationAttributes.Builder> getNotificationAttributes() {
            Map<String, IdentityNotificationAttributes.Builder> result = NotificationAttributesCopier
                    .copyToBuilder(this.notificationAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setNotificationAttributes(Map<String, IdentityNotificationAttributes.BuilderImpl> notificationAttributes) {
            this.notificationAttributes = NotificationAttributesCopier.copyFromBuilder(notificationAttributes);
        }

        @Override
        public final Builder notificationAttributes(Map<String, IdentityNotificationAttributes> notificationAttributes) {
            this.notificationAttributes = NotificationAttributesCopier.copy(notificationAttributes);
            return this;
        }

        @Override
        public GetIdentityNotificationAttributesResponse build() {
            return new GetIdentityNotificationAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
