/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create a receipt rule set by cloning an existing one. You use receipt rule sets to receive
 * email with Amazon SES. For more information, see the <a
 * href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html">Amazon SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloneReceiptRuleSetRequest extends SesRequest implements
        ToCopyableBuilder<CloneReceiptRuleSetRequest.Builder, CloneReceiptRuleSetRequest> {
    private static final SdkField<String> RULE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleSetName").getter(getter(CloneReceiptRuleSetRequest::ruleSetName))
            .setter(setter(Builder::ruleSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetName").build()).build();

    private static final SdkField<String> ORIGINAL_RULE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginalRuleSetName").getter(getter(CloneReceiptRuleSetRequest::originalRuleSetName))
            .setter(setter(Builder::originalRuleSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalRuleSetName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SET_NAME_FIELD,
            ORIGINAL_RULE_SET_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ruleSetName;

    private final String originalRuleSetName;

    private CloneReceiptRuleSetRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
        this.originalRuleSetName = builder.originalRuleSetName;
    }

    /**
     * <p>
     * The name of the rule set to create. The name must meet the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
     * </p>
     * </li>
     * <li>
     * <p>
     * Start and end with a letter or number.
     * </p>
     * </li>
     * <li>
     * <p>
     * Contain 64 characters or fewer.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the rule set to create. The name must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start and end with a letter or number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Contain 64 characters or fewer.
     *         </p>
     *         </li>
     */
    public final String ruleSetName() {
        return ruleSetName;
    }

    /**
     * <p>
     * The name of the rule set to clone.
     * </p>
     * 
     * @return The name of the rule set to clone.
     */
    public final String originalRuleSetName() {
        return originalRuleSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(originalRuleSetName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloneReceiptRuleSetRequest)) {
            return false;
        }
        CloneReceiptRuleSetRequest other = (CloneReceiptRuleSetRequest) obj;
        return Objects.equals(ruleSetName(), other.ruleSetName())
                && Objects.equals(originalRuleSetName(), other.originalRuleSetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloneReceiptRuleSetRequest").add("RuleSetName", ruleSetName())
                .add("OriginalRuleSetName", originalRuleSetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSetName":
            return Optional.ofNullable(clazz.cast(ruleSetName()));
        case "OriginalRuleSetName":
            return Optional.ofNullable(clazz.cast(originalRuleSetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleSetName", RULE_SET_NAME_FIELD);
        map.put("OriginalRuleSetName", ORIGINAL_RULE_SET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloneReceiptRuleSetRequest, T> g) {
        return obj -> g.apply((CloneReceiptRuleSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CloneReceiptRuleSetRequest> {
        /**
         * <p>
         * The name of the rule set to create. The name must meet the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
         * </p>
         * </li>
         * <li>
         * <p>
         * Start and end with a letter or number.
         * </p>
         * </li>
         * <li>
         * <p>
         * Contain 64 characters or fewer.
         * </p>
         * </li>
         * </ul>
         * 
         * @param ruleSetName
         *        The name of the rule set to create. The name must meet the following requirements:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start and end with a letter or number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Contain 64 characters or fewer.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetName(String ruleSetName);

        /**
         * <p>
         * The name of the rule set to clone.
         * </p>
         * 
         * @param originalRuleSetName
         *        The name of the rule set to clone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalRuleSetName(String originalRuleSetName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private String ruleSetName;

        private String originalRuleSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(CloneReceiptRuleSetRequest model) {
            super(model);
            ruleSetName(model.ruleSetName);
            originalRuleSetName(model.originalRuleSetName);
        }

        public final String getRuleSetName() {
            return ruleSetName;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final String getOriginalRuleSetName() {
            return originalRuleSetName;
        }

        public final void setOriginalRuleSetName(String originalRuleSetName) {
            this.originalRuleSetName = originalRuleSetName;
        }

        @Override
        public final Builder originalRuleSetName(String originalRuleSetName) {
            this.originalRuleSetName = originalRuleSetName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CloneReceiptRuleSetRequest build() {
            return new CloneReceiptRuleSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
