/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum BulkEmailStatus {
    SUCCESS("Success"),

    MESSAGE_REJECTED("MessageRejected"),

    MAIL_FROM_DOMAIN_NOT_VERIFIED("MailFromDomainNotVerified"),

    CONFIGURATION_SET_DOES_NOT_EXIST("ConfigurationSetDoesNotExist"),

    TEMPLATE_DOES_NOT_EXIST("TemplateDoesNotExist"),

    ACCOUNT_SUSPENDED("AccountSuspended"),

    ACCOUNT_THROTTLED("AccountThrottled"),

    ACCOUNT_DAILY_QUOTA_EXCEEDED("AccountDailyQuotaExceeded"),

    INVALID_SENDING_POOL_NAME("InvalidSendingPoolName"),

    ACCOUNT_SENDING_PAUSED("AccountSendingPaused"),

    CONFIGURATION_SET_SENDING_PAUSED("ConfigurationSetSendingPaused"),

    INVALID_PARAMETER_VALUE("InvalidParameterValue"),

    TRANSIENT_FAILURE("TransientFailure"),

    FAILED("Failed"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BulkEmailStatus> VALUE_MAP = EnumUtils.uniqueIndex(BulkEmailStatus.class,
            BulkEmailStatus::toString);

    private final String value;

    private BulkEmailStatus(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return BulkEmailStatus corresponding to the value
     */
    public static BulkEmailStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link BulkEmailStatus}s
     */
    public static Set<BulkEmailStatus> knownValues() {
        Set<BulkEmailStatus> knownValues = EnumSet.allOf(BulkEmailStatus.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
