/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When included in a receipt rule, this action parses the received message and starts an email contact in Amazon
 * Connect on your behalf.
 * </p>
 * <note>
 * <p>
 * When you receive emails, the maximum email size (including headers) is 40 MB. Additionally, emails may only have up
 * to 10 attachments. Emails larger than 40 MB or with more than 10 attachments will be bounced.
 * </p>
 * </note>
 * <p>
 * We recommend that you configure this action via Amazon Connect.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectAction implements SdkPojo, Serializable, ToCopyableBuilder<ConnectAction.Builder, ConnectAction> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceARN").getter(getter(ConnectAction::instanceARN)).setter(setter(Builder::instanceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceARN").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IAMRoleARN").getter(getter(ConnectAction::iamRoleARN)).setter(setter(Builder::iamRoleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMRoleARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD,
            IAM_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceARN;

    private final String iamRoleARN;

    private ConnectAction(BuilderImpl builder) {
        this.instanceARN = builder.instanceARN;
        this.iamRoleARN = builder.iamRoleARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the Amazon Connect instance that Amazon SES integrates with for starting email
     * contacts.
     * </p>
     * <p>
     * For more information about Amazon Connect instances, see the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-instances.html">Amazon Connect
     * Administrator Guide</a>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the Amazon Connect instance that Amazon SES integrates with for
     *         starting email contacts.</p>
     *         <p>
     *         For more information about Amazon Connect instances, see the <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-instances.html">Amazon Connect
     *         Administrator Guide</a>
     */
    public final String instanceARN() {
        return instanceARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to be used by Amazon Simple Email Service while starting email
     * contacts to the Amazon Connect instance. This role should have permission to invoke
     * <code>connect:StartEmailContact</code> for the given Amazon Connect instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to be used by Amazon Simple Email Service while starting
     *         email contacts to the Amazon Connect instance. This role should have permission to invoke
     *         <code>connect:StartEmailContact</code> for the given Amazon Connect instance.
     */
    public final String iamRoleARN() {
        return iamRoleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceARN());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectAction)) {
            return false;
        }
        ConnectAction other = (ConnectAction) obj;
        return Objects.equals(instanceARN(), other.instanceARN()) && Objects.equals(iamRoleARN(), other.iamRoleARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectAction").add("InstanceARN", instanceARN()).add("IAMRoleARN", iamRoleARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceARN":
            return Optional.ofNullable(clazz.cast(instanceARN()));
        case "IAMRoleARN":
            return Optional.ofNullable(clazz.cast(iamRoleARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceARN", INSTANCE_ARN_FIELD);
        map.put("IAMRoleARN", IAM_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectAction, T> g) {
        return obj -> g.apply((ConnectAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectAction> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the Amazon Connect instance that Amazon SES integrates with for starting
         * email contacts.
         * </p>
         * <p>
         * For more information about Amazon Connect instances, see the <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-instances.html">Amazon Connect
         * Administrator Guide</a>
         * </p>
         * 
         * @param instanceARN
         *        The Amazon Resource Name (ARN) for the Amazon Connect instance that Amazon SES integrates with for
         *        starting email contacts.</p>
         *        <p>
         *        For more information about Amazon Connect instances, see the <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-instances.html">Amazon
         *        Connect Administrator Guide</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceARN(String instanceARN);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to be used by Amazon Simple Email Service while starting email
         * contacts to the Amazon Connect instance. This role should have permission to invoke
         * <code>connect:StartEmailContact</code> for the given Amazon Connect instance.
         * </p>
         * 
         * @param iamRoleARN
         *        The Amazon Resource Name (ARN) of the IAM role to be used by Amazon Simple Email Service while
         *        starting email contacts to the Amazon Connect instance. This role should have permission to invoke
         *        <code>connect:StartEmailContact</code> for the given Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleARN(String iamRoleARN);
    }

    static final class BuilderImpl implements Builder {
        private String instanceARN;

        private String iamRoleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectAction model) {
            instanceARN(model.instanceARN);
            iamRoleARN(model.iamRoleARN);
        }

        public final String getInstanceARN() {
            return instanceARN;
        }

        public final void setInstanceARN(String instanceARN) {
            this.instanceARN = instanceARN;
        }

        @Override
        public final Builder instanceARN(String instanceARN) {
            this.instanceARN = instanceARN;
            return this;
        }

        public final String getIamRoleARN() {
            return iamRoleARN;
        }

        public final void setIamRoleARN(String iamRoleARN) {
            this.iamRoleARN = iamRoleARN;
        }

        @Override
        public final Builder iamRoleARN(String iamRoleARN) {
            this.iamRoleARN = iamRoleARN;
            return this;
        }

        @Override
        public ConnectAction build() {
            return new ConnectAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
