/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class VerificationAttributesCopier {
    static Map<String, IdentityVerificationAttributes> copy(
            Map<String, ? extends IdentityVerificationAttributes> verificationAttributesParam) {
        Map<String, IdentityVerificationAttributes> map;
        if (verificationAttributesParam == null || verificationAttributesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, IdentityVerificationAttributes> modifiableMap = new LinkedHashMap<>(verificationAttributesParam.size());
            verificationAttributesParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, IdentityVerificationAttributes> copyFromBuilder(
            Map<String, ? extends IdentityVerificationAttributes.Builder> verificationAttributesParam) {
        Map<String, IdentityVerificationAttributes> map;
        if (verificationAttributesParam == null || verificationAttributesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, IdentityVerificationAttributes> modifiableMap = new LinkedHashMap<>(verificationAttributesParam.size());
            verificationAttributesParam.forEach((key, value) -> {
                IdentityVerificationAttributes member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, IdentityVerificationAttributes.Builder> copyToBuilder(
            Map<String, ? extends IdentityVerificationAttributes> verificationAttributesParam) {
        Map<String, IdentityVerificationAttributes.Builder> map;
        if (verificationAttributesParam == null || verificationAttributesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, IdentityVerificationAttributes.Builder> modifiableMap = new LinkedHashMap<>(
                    verificationAttributesParam.size());
            verificationAttributesParam.forEach((key, value) -> {
                IdentityVerificationAttributes.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
