/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to enable or disable whether Amazon SES forwards you bounce and complaint notifications through
 * email. For information about email feedback forwarding, see the <a
 * href="https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications-email.html">Amazon SES
 * Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetIdentityFeedbackForwardingEnabledRequest extends SesRequest implements
        ToCopyableBuilder<SetIdentityFeedbackForwardingEnabledRequest.Builder, SetIdentityFeedbackForwardingEnabledRequest> {
    private static final SdkField<String> IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identity").getter(getter(SetIdentityFeedbackForwardingEnabledRequest::identity))
            .setter(setter(Builder::identity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identity").build()).build();

    private static final SdkField<Boolean> FORWARDING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForwardingEnabled").getter(getter(SetIdentityFeedbackForwardingEnabledRequest::forwardingEnabled))
            .setter(setter(Builder::forwardingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardingEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_FIELD,
            FORWARDING_ENABLED_FIELD));

    private final String identity;

    private final Boolean forwardingEnabled;

    private SetIdentityFeedbackForwardingEnabledRequest(BuilderImpl builder) {
        super(builder);
        this.identity = builder.identity;
        this.forwardingEnabled = builder.forwardingEnabled;
    }

    /**
     * <p>
     * The identity for which to set bounce and complaint notification forwarding. Examples:
     * <code>user@example.com</code>, <code>example.com</code>.
     * </p>
     * 
     * @return The identity for which to set bounce and complaint notification forwarding. Examples:
     *         <code>user@example.com</code>, <code>example.com</code>.
     */
    public final String identity() {
        return identity;
    }

    /**
     * <p>
     * Sets whether Amazon SES forwards bounce and complaint notifications as email. <code>true</code> specifies that
     * Amazon SES forwards bounce and complaint notifications as email, in addition to any Amazon SNS topic publishing
     * otherwise specified. <code>false</code> specifies that Amazon SES publishes bounce and complaint notifications
     * only through Amazon SNS. This value can only be set to <code>false</code> when Amazon SNS topics are set for both
     * <code>Bounce</code> and <code>Complaint</code> notification types.
     * </p>
     * 
     * @return Sets whether Amazon SES forwards bounce and complaint notifications as email. <code>true</code> specifies
     *         that Amazon SES forwards bounce and complaint notifications as email, in addition to any Amazon SNS topic
     *         publishing otherwise specified. <code>false</code> specifies that Amazon SES publishes bounce and
     *         complaint notifications only through Amazon SNS. This value can only be set to <code>false</code> when
     *         Amazon SNS topics are set for both <code>Bounce</code> and <code>Complaint</code> notification types.
     */
    public final Boolean forwardingEnabled() {
        return forwardingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identity());
        hashCode = 31 * hashCode + Objects.hashCode(forwardingEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityFeedbackForwardingEnabledRequest)) {
            return false;
        }
        SetIdentityFeedbackForwardingEnabledRequest other = (SetIdentityFeedbackForwardingEnabledRequest) obj;
        return Objects.equals(identity(), other.identity()) && Objects.equals(forwardingEnabled(), other.forwardingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetIdentityFeedbackForwardingEnabledRequest").add("Identity", identity())
                .add("ForwardingEnabled", forwardingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identity":
            return Optional.ofNullable(clazz.cast(identity()));
        case "ForwardingEnabled":
            return Optional.ofNullable(clazz.cast(forwardingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetIdentityFeedbackForwardingEnabledRequest, T> g) {
        return obj -> g.apply((SetIdentityFeedbackForwardingEnabledRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetIdentityFeedbackForwardingEnabledRequest> {
        /**
         * <p>
         * The identity for which to set bounce and complaint notification forwarding. Examples:
         * <code>user@example.com</code>, <code>example.com</code>.
         * </p>
         * 
         * @param identity
         *        The identity for which to set bounce and complaint notification forwarding. Examples:
         *        <code>user@example.com</code>, <code>example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * <p>
         * Sets whether Amazon SES forwards bounce and complaint notifications as email. <code>true</code> specifies
         * that Amazon SES forwards bounce and complaint notifications as email, in addition to any Amazon SNS topic
         * publishing otherwise specified. <code>false</code> specifies that Amazon SES publishes bounce and complaint
         * notifications only through Amazon SNS. This value can only be set to <code>false</code> when Amazon SNS
         * topics are set for both <code>Bounce</code> and <code>Complaint</code> notification types.
         * </p>
         * 
         * @param forwardingEnabled
         *        Sets whether Amazon SES forwards bounce and complaint notifications as email. <code>true</code>
         *        specifies that Amazon SES forwards bounce and complaint notifications as email, in addition to any
         *        Amazon SNS topic publishing otherwise specified. <code>false</code> specifies that Amazon SES
         *        publishes bounce and complaint notifications only through Amazon SNS. This value can only be set to
         *        <code>false</code> when Amazon SNS topics are set for both <code>Bounce</code> and
         *        <code>Complaint</code> notification types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingEnabled(Boolean forwardingEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private String identity;

        private Boolean forwardingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityFeedbackForwardingEnabledRequest model) {
            super(model);
            identity(model.identity);
            forwardingEnabled(model.forwardingEnabled);
        }

        public final String getIdentity() {
            return identity;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final Boolean getForwardingEnabled() {
            return forwardingEnabled;
        }

        public final void setForwardingEnabled(Boolean forwardingEnabled) {
            this.forwardingEnabled = forwardingEnabled;
        }

        @Override
        public final Builder forwardingEnabled(Boolean forwardingEnabled) {
            this.forwardingEnabled = forwardingEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetIdentityFeedbackForwardingEnabledRequest build() {
            return new SetIdentityFeedbackForwardingEnabledRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
