/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetSecretValueResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<BatchGetSecretValueResponse.Builder, BatchGetSecretValueResponse> {
    private static final SdkField<List<SecretValueEntry>> SECRET_VALUES_FIELD = SdkField
            .<List<SecretValueEntry>> builder(MarshallingType.LIST)
            .memberName("SecretValues")
            .getter(getter(BatchGetSecretValueResponse::secretValues))
            .setter(setter(Builder::secretValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecretValueEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecretValueEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(BatchGetSecretValueResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<APIErrorType>> ERRORS_FIELD = SdkField
            .<List<APIErrorType>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchGetSecretValueResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<APIErrorType> builder(MarshallingType.SDK_POJO)
                                            .constructor(APIErrorType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_VALUES_FIELD,
            NEXT_TOKEN_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SecretValueEntry> secretValues;

    private final String nextToken;

    private final List<APIErrorType> errors;

    private BatchGetSecretValueResponse(BuilderImpl builder) {
        super(builder);
        this.secretValues = builder.secretValues;
        this.nextToken = builder.nextToken;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecretValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecretValues() {
        return secretValues != null && !(secretValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of secret values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecretValues} method.
     * </p>
     * 
     * @return A list of secret values.
     */
    public final List<SecretValueEntry> secretValues() {
        return secretValues;
    }

    /**
     * <p>
     * Secrets Manager includes this value if there's more output available than what is included in the current
     * response. This can occur even when the response includes no values at all, such as when you ask for a filtered
     * view of a long list. To get the next results, call <code>BatchGetSecretValue</code> again with this value.
     * </p>
     * 
     * @return Secrets Manager includes this value if there's more output available than what is included in the current
     *         response. This can occur even when the response includes no values at all, such as when you ask for a
     *         filtered view of a long list. To get the next results, call <code>BatchGetSecretValue</code> again with
     *         this value.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors Secrets Manager encountered while attempting to retrieve individual secrets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of errors Secrets Manager encountered while attempting to retrieve individual secrets.
     */
    public final List<APIErrorType> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSecretValues() ? secretValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSecretValueResponse)) {
            return false;
        }
        BatchGetSecretValueResponse other = (BatchGetSecretValueResponse) obj;
        return hasSecretValues() == other.hasSecretValues() && Objects.equals(secretValues(), other.secretValues())
                && Objects.equals(nextToken(), other.nextToken()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetSecretValueResponse").add("SecretValues", hasSecretValues() ? secretValues() : null)
                .add("NextToken", nextToken()).add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretValues":
            return Optional.ofNullable(clazz.cast(secretValues()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecretValues", SECRET_VALUES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetSecretValueResponse, T> g) {
        return obj -> g.apply((BatchGetSecretValueResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetSecretValueResponse> {
        /**
         * <p>
         * A list of secret values.
         * </p>
         * 
         * @param secretValues
         *        A list of secret values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretValues(Collection<SecretValueEntry> secretValues);

        /**
         * <p>
         * A list of secret values.
         * </p>
         * 
         * @param secretValues
         *        A list of secret values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretValues(SecretValueEntry... secretValues);

        /**
         * <p>
         * A list of secret values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.secretsmanager.model.SecretValueEntry.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.secretsmanager.model.SecretValueEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.secretsmanager.model.SecretValueEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #secretValues(List<SecretValueEntry>)}.
         * 
         * @param secretValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.secretsmanager.model.SecretValueEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretValues(java.util.Collection<SecretValueEntry>)
         */
        Builder secretValues(Consumer<SecretValueEntry.Builder>... secretValues);

        /**
         * <p>
         * Secrets Manager includes this value if there's more output available than what is included in the current
         * response. This can occur even when the response includes no values at all, such as when you ask for a
         * filtered view of a long list. To get the next results, call <code>BatchGetSecretValue</code> again with this
         * value.
         * </p>
         * 
         * @param nextToken
         *        Secrets Manager includes this value if there's more output available than what is included in the
         *        current response. This can occur even when the response includes no values at all, such as when you
         *        ask for a filtered view of a long list. To get the next results, call <code>BatchGetSecretValue</code>
         *        again with this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of errors Secrets Manager encountered while attempting to retrieve individual secrets.
         * </p>
         * 
         * @param errors
         *        A list of errors Secrets Manager encountered while attempting to retrieve individual secrets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<APIErrorType> errors);

        /**
         * <p>
         * A list of errors Secrets Manager encountered while attempting to retrieve individual secrets.
         * </p>
         * 
         * @param errors
         *        A list of errors Secrets Manager encountered while attempting to retrieve individual secrets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(APIErrorType... errors);

        /**
         * <p>
         * A list of errors Secrets Manager encountered while attempting to retrieve individual secrets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.secretsmanager.model.APIErrorType.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.secretsmanager.model.APIErrorType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.secretsmanager.model.APIErrorType.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<APIErrorType>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.secretsmanager.model.APIErrorType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<APIErrorType>)
         */
        Builder errors(Consumer<APIErrorType.Builder>... errors);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private List<SecretValueEntry> secretValues = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private List<APIErrorType> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetSecretValueResponse model) {
            super(model);
            secretValues(model.secretValues);
            nextToken(model.nextToken);
            errors(model.errors);
        }

        public final List<SecretValueEntry.Builder> getSecretValues() {
            List<SecretValueEntry.Builder> result = SecretValuesTypeCopier.copyToBuilder(this.secretValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecretValues(Collection<SecretValueEntry.BuilderImpl> secretValues) {
            this.secretValues = SecretValuesTypeCopier.copyFromBuilder(secretValues);
        }

        @Override
        public final Builder secretValues(Collection<SecretValueEntry> secretValues) {
            this.secretValues = SecretValuesTypeCopier.copy(secretValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretValues(SecretValueEntry... secretValues) {
            secretValues(Arrays.asList(secretValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretValues(Consumer<SecretValueEntry.Builder>... secretValues) {
            secretValues(Stream.of(secretValues).map(c -> SecretValueEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<APIErrorType.Builder> getErrors() {
            List<APIErrorType.Builder> result = APIErrorListTypeCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<APIErrorType.BuilderImpl> errors) {
            this.errors = APIErrorListTypeCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<APIErrorType> errors) {
            this.errors = APIErrorListTypeCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(APIErrorType... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<APIErrorType.Builder>... errors) {
            errors(Stream.of(errors).map(c -> APIErrorType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetSecretValueResponse build() {
            return new BatchGetSecretValueResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
