/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.s3express;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.s3.s3express.S3ExpressSessionCredentials;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DefaultS3ExpressSessionCredentials
implements S3ExpressSessionCredentials {
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;

    public DefaultS3ExpressSessionCredentials(String accessKeyId, String secretAccessKey, String sessionToken) {
        this.accessKeyId = (String)Validate.notBlank((CharSequence)accessKeyId, (String)"Parameter accessKeyId cannot be blank", (Object[])new Object[0]);
        this.secretAccessKey = (String)Validate.notBlank((CharSequence)secretAccessKey, (String)"Parameter secretAccessKey cannot be blank", (Object[])new Object[0]);
        this.sessionToken = sessionToken;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    @Override
    public String sessionToken() {
        return this.sessionToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ExpressSessionCredentials that = (S3ExpressSessionCredentials)o;
        if (!this.accessKeyId.equals(that.accessKeyId())) {
            return false;
        }
        if (!this.secretAccessKey.equals(that.secretAccessKey())) {
            return false;
        }
        return this.sessionToken != null ? this.sessionToken.equals(that.sessionToken()) : that.sessionToken() == null;
    }

    public int hashCode() {
        int result = this.accessKeyId.hashCode();
        result = 31 * result + this.secretAccessKey.hashCode();
        result = 31 * result + (this.sessionToken != null ? this.sessionToken.hashCode() : 0);
        return result;
    }
}

