/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQPersonalizationConfigurationResponse extends QuickSightResponse implements
        ToCopyableBuilder<UpdateQPersonalizationConfigurationResponse.Builder, UpdateQPersonalizationConfigurationResponse> {
    private static final SdkField<String> PERSONALIZATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PersonalizationMode")
            .getter(getter(UpdateQPersonalizationConfigurationResponse::personalizationModeAsString))
            .setter(setter(Builder::personalizationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalizationMode").build())
            .build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(UpdateQPersonalizationConfigurationResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(UpdateQPersonalizationConfigurationResponse::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSONALIZATION_MODE_FIELD,
            REQUEST_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String personalizationMode;

    private final String requestId;

    private final Integer status;

    private UpdateQPersonalizationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.personalizationMode = builder.personalizationMode;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The personalization mode that is used for the personalization configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #personalizationMode} will return {@link PersonalizationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #personalizationModeAsString}.
     * </p>
     * 
     * @return The personalization mode that is used for the personalization configuration.
     * @see PersonalizationMode
     */
    public final PersonalizationMode personalizationMode() {
        return PersonalizationMode.fromValue(personalizationMode);
    }

    /**
     * <p>
     * The personalization mode that is used for the personalization configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #personalizationMode} will return {@link PersonalizationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #personalizationModeAsString}.
     * </p>
     * 
     * @return The personalization mode that is used for the personalization configuration.
     * @see PersonalizationMode
     */
    public final String personalizationModeAsString() {
        return personalizationMode;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(personalizationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQPersonalizationConfigurationResponse)) {
            return false;
        }
        UpdateQPersonalizationConfigurationResponse other = (UpdateQPersonalizationConfigurationResponse) obj;
        return Objects.equals(personalizationModeAsString(), other.personalizationModeAsString())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateQPersonalizationConfigurationResponse")
                .add("PersonalizationMode", personalizationModeAsString()).add("RequestId", requestId()).add("Status", status())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PersonalizationMode":
            return Optional.ofNullable(clazz.cast(personalizationModeAsString()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PersonalizationMode", PERSONALIZATION_MODE_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQPersonalizationConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateQPersonalizationConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateQPersonalizationConfigurationResponse> {
        /**
         * <p>
         * The personalization mode that is used for the personalization configuration.
         * </p>
         * 
         * @param personalizationMode
         *        The personalization mode that is used for the personalization configuration.
         * @see PersonalizationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PersonalizationMode
         */
        Builder personalizationMode(String personalizationMode);

        /**
         * <p>
         * The personalization mode that is used for the personalization configuration.
         * </p>
         * 
         * @param personalizationMode
         *        The personalization mode that is used for the personalization configuration.
         * @see PersonalizationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PersonalizationMode
         */
        Builder personalizationMode(PersonalizationMode personalizationMode);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String personalizationMode;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQPersonalizationConfigurationResponse model) {
            super(model);
            personalizationMode(model.personalizationMode);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getPersonalizationMode() {
            return personalizationMode;
        }

        public final void setPersonalizationMode(String personalizationMode) {
            this.personalizationMode = personalizationMode;
        }

        @Override
        public final Builder personalizationMode(String personalizationMode) {
            this.personalizationMode = personalizationMode;
            return this;
        }

        @Override
        public final Builder personalizationMode(PersonalizationMode personalizationMode) {
            this.personalizationMode(personalizationMode == null ? null : personalizationMode.toString());
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public UpdateQPersonalizationConfigurationResponse build() {
            return new UpdateQPersonalizationConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
