/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKeyRegistrationRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateKeyRegistrationRequest.Builder, UpdateKeyRegistrationRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateKeyRegistrationRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<List<RegisteredCustomerManagedKey>> KEY_REGISTRATION_FIELD = SdkField
            .<List<RegisteredCustomerManagedKey>> builder(MarshallingType.LIST)
            .memberName("KeyRegistration")
            .getter(getter(UpdateKeyRegistrationRequest::keyRegistration))
            .setter(setter(Builder::keyRegistration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyRegistration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegisteredCustomerManagedKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegisteredCustomerManagedKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            KEY_REGISTRATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final List<RegisteredCustomerManagedKey> keyRegistration;

    private UpdateKeyRegistrationRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.keyRegistration = builder.keyRegistration;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the customer managed key registration that you want to
     * update.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the customer managed key registration that you
     *         want to update.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyRegistration property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKeyRegistration() {
        return keyRegistration != null && !(keyRegistration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>RegisteredCustomerManagedKey</code> objects to be updated to the QuickSight account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyRegistration} method.
     * </p>
     * 
     * @return A list of <code>RegisteredCustomerManagedKey</code> objects to be updated to the QuickSight account.
     */
    public final List<RegisteredCustomerManagedKey> keyRegistration() {
        return keyRegistration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyRegistration() ? keyRegistration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKeyRegistrationRequest)) {
            return false;
        }
        UpdateKeyRegistrationRequest other = (UpdateKeyRegistrationRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && hasKeyRegistration() == other.hasKeyRegistration()
                && Objects.equals(keyRegistration(), other.keyRegistration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKeyRegistrationRequest").add("AwsAccountId", awsAccountId())
                .add("KeyRegistration", hasKeyRegistration() ? keyRegistration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "KeyRegistration":
            return Optional.ofNullable(clazz.cast(keyRegistration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("KeyRegistration", KEY_REGISTRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKeyRegistrationRequest, T> g) {
        return obj -> g.apply((UpdateKeyRegistrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateKeyRegistrationRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the customer managed key registration that you want
         * to update.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the customer managed key registration that you
         *        want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * A list of <code>RegisteredCustomerManagedKey</code> objects to be updated to the QuickSight account.
         * </p>
         * 
         * @param keyRegistration
         *        A list of <code>RegisteredCustomerManagedKey</code> objects to be updated to the QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyRegistration(Collection<RegisteredCustomerManagedKey> keyRegistration);

        /**
         * <p>
         * A list of <code>RegisteredCustomerManagedKey</code> objects to be updated to the QuickSight account.
         * </p>
         * 
         * @param keyRegistration
         *        A list of <code>RegisteredCustomerManagedKey</code> objects to be updated to the QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyRegistration(RegisteredCustomerManagedKey... keyRegistration);

        /**
         * <p>
         * A list of <code>RegisteredCustomerManagedKey</code> objects to be updated to the QuickSight account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.RegisteredCustomerManagedKey.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.RegisteredCustomerManagedKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.RegisteredCustomerManagedKey.Builder#build()} is
         * called immediately and its result is passed to {@link #keyRegistration(List<RegisteredCustomerManagedKey>)}.
         * 
         * @param keyRegistration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.RegisteredCustomerManagedKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyRegistration(java.util.Collection<RegisteredCustomerManagedKey>)
         */
        Builder keyRegistration(Consumer<RegisteredCustomerManagedKey.Builder>... keyRegistration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private List<RegisteredCustomerManagedKey> keyRegistration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKeyRegistrationRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            keyRegistration(model.keyRegistration);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final List<RegisteredCustomerManagedKey.Builder> getKeyRegistration() {
            List<RegisteredCustomerManagedKey.Builder> result = KeyRegistrationCopier.copyToBuilder(this.keyRegistration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeyRegistration(Collection<RegisteredCustomerManagedKey.BuilderImpl> keyRegistration) {
            this.keyRegistration = KeyRegistrationCopier.copyFromBuilder(keyRegistration);
        }

        @Override
        public final Builder keyRegistration(Collection<RegisteredCustomerManagedKey> keyRegistration) {
            this.keyRegistration = KeyRegistrationCopier.copy(keyRegistration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyRegistration(RegisteredCustomerManagedKey... keyRegistration) {
            keyRegistration(Arrays.asList(keyRegistration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyRegistration(Consumer<RegisteredCustomerManagedKey.Builder>... keyRegistration) {
            keyRegistration(Stream.of(keyRegistration).map(c -> RegisteredCustomerManagedKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKeyRegistrationRequest build() {
            return new UpdateKeyRegistrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
