/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes the details of a topic, such as its name, description, and associated data sets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicDetails implements SdkPojo, Serializable, ToCopyableBuilder<TopicDetails.Builder, TopicDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TopicDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(TopicDetails::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> USER_EXPERIENCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserExperienceVersion").getter(getter(TopicDetails::userExperienceVersionAsString))
            .setter(setter(Builder::userExperienceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserExperienceVersion").build())
            .build();

    private static final SdkField<List<DatasetMetadata>> DATA_SETS_FIELD = SdkField
            .<List<DatasetMetadata>> builder(MarshallingType.LIST)
            .memberName("DataSets")
            .getter(getter(TopicDetails::dataSets))
            .setter(setter(Builder::dataSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TopicConfigOptions> CONFIG_OPTIONS_FIELD = SdkField
            .<TopicConfigOptions> builder(MarshallingType.SDK_POJO).memberName("ConfigOptions")
            .getter(getter(TopicDetails::configOptions)).setter(setter(Builder::configOptions))
            .constructor(TopicConfigOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            USER_EXPERIENCE_VERSION_FIELD, DATA_SETS_FIELD, CONFIG_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String userExperienceVersion;

    private final List<DatasetMetadata> dataSets;

    private final TopicConfigOptions configOptions;

    private TopicDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.userExperienceVersion = builder.userExperienceVersion;
        this.dataSets = builder.dataSets;
        this.configOptions = builder.configOptions;
    }

    /**
     * <p>
     * The name of the topic.
     * </p>
     * 
     * @return The name of the topic.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the topic.
     * </p>
     * 
     * @return The description of the topic.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The user experience version of a topic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userExperienceVersion} will return {@link TopicUserExperienceVersion#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #userExperienceVersionAsString}.
     * </p>
     * 
     * @return The user experience version of a topic.
     * @see TopicUserExperienceVersion
     */
    public final TopicUserExperienceVersion userExperienceVersion() {
        return TopicUserExperienceVersion.fromValue(userExperienceVersion);
    }

    /**
     * <p>
     * The user experience version of a topic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userExperienceVersion} will return {@link TopicUserExperienceVersion#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #userExperienceVersionAsString}.
     * </p>
     * 
     * @return The user experience version of a topic.
     * @see TopicUserExperienceVersion
     */
    public final String userExperienceVersionAsString() {
        return userExperienceVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDataSets() {
        return dataSets != null && !(dataSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data sets that the topic is associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSets} method.
     * </p>
     * 
     * @return The data sets that the topic is associated with.
     */
    public final List<DatasetMetadata> dataSets() {
        return dataSets;
    }

    /**
     * <p>
     * Configuration options for a <code>Topic</code>.
     * </p>
     * 
     * @return Configuration options for a <code>Topic</code>.
     */
    public final TopicConfigOptions configOptions() {
        return configOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(userExperienceVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSets() ? dataSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicDetails)) {
            return false;
        }
        TopicDetails other = (TopicDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(userExperienceVersionAsString(), other.userExperienceVersionAsString())
                && hasDataSets() == other.hasDataSets() && Objects.equals(dataSets(), other.dataSets())
                && Objects.equals(configOptions(), other.configOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicDetails").add("Name", name()).add("Description", description())
                .add("UserExperienceVersion", userExperienceVersionAsString()).add("DataSets", hasDataSets() ? dataSets() : null)
                .add("ConfigOptions", configOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "UserExperienceVersion":
            return Optional.ofNullable(clazz.cast(userExperienceVersionAsString()));
        case "DataSets":
            return Optional.ofNullable(clazz.cast(dataSets()));
        case "ConfigOptions":
            return Optional.ofNullable(clazz.cast(configOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("UserExperienceVersion", USER_EXPERIENCE_VERSION_FIELD);
        map.put("DataSets", DATA_SETS_FIELD);
        map.put("ConfigOptions", CONFIG_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicDetails, T> g) {
        return obj -> g.apply((TopicDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicDetails> {
        /**
         * <p>
         * The name of the topic.
         * </p>
         * 
         * @param name
         *        The name of the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the topic.
         * </p>
         * 
         * @param description
         *        The description of the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The user experience version of a topic.
         * </p>
         * 
         * @param userExperienceVersion
         *        The user experience version of a topic.
         * @see TopicUserExperienceVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicUserExperienceVersion
         */
        Builder userExperienceVersion(String userExperienceVersion);

        /**
         * <p>
         * The user experience version of a topic.
         * </p>
         * 
         * @param userExperienceVersion
         *        The user experience version of a topic.
         * @see TopicUserExperienceVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicUserExperienceVersion
         */
        Builder userExperienceVersion(TopicUserExperienceVersion userExperienceVersion);

        /**
         * <p>
         * The data sets that the topic is associated with.
         * </p>
         * 
         * @param dataSets
         *        The data sets that the topic is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(Collection<DatasetMetadata> dataSets);

        /**
         * <p>
         * The data sets that the topic is associated with.
         * </p>
         * 
         * @param dataSets
         *        The data sets that the topic is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(DatasetMetadata... dataSets);

        /**
         * <p>
         * The data sets that the topic is associated with.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DatasetMetadata.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DatasetMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DatasetMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #dataSets(List<DatasetMetadata>)}.
         * 
         * @param dataSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DatasetMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSets(java.util.Collection<DatasetMetadata>)
         */
        Builder dataSets(Consumer<DatasetMetadata.Builder>... dataSets);

        /**
         * <p>
         * Configuration options for a <code>Topic</code>.
         * </p>
         * 
         * @param configOptions
         *        Configuration options for a <code>Topic</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configOptions(TopicConfigOptions configOptions);

        /**
         * <p>
         * Configuration options for a <code>Topic</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicConfigOptions.Builder} avoiding the
         * need to create one manually via {@link TopicConfigOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicConfigOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #configOptions(TopicConfigOptions)}.
         * 
         * @param configOptions
         *        a consumer that will call methods on {@link TopicConfigOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configOptions(TopicConfigOptions)
         */
        default Builder configOptions(Consumer<TopicConfigOptions.Builder> configOptions) {
            return configOptions(TopicConfigOptions.builder().applyMutation(configOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String userExperienceVersion;

        private List<DatasetMetadata> dataSets = DefaultSdkAutoConstructList.getInstance();

        private TopicConfigOptions configOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicDetails model) {
            name(model.name);
            description(model.description);
            userExperienceVersion(model.userExperienceVersion);
            dataSets(model.dataSets);
            configOptions(model.configOptions);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUserExperienceVersion() {
            return userExperienceVersion;
        }

        public final void setUserExperienceVersion(String userExperienceVersion) {
            this.userExperienceVersion = userExperienceVersion;
        }

        @Override
        public final Builder userExperienceVersion(String userExperienceVersion) {
            this.userExperienceVersion = userExperienceVersion;
            return this;
        }

        @Override
        public final Builder userExperienceVersion(TopicUserExperienceVersion userExperienceVersion) {
            this.userExperienceVersion(userExperienceVersion == null ? null : userExperienceVersion.toString());
            return this;
        }

        public final List<DatasetMetadata.Builder> getDataSets() {
            List<DatasetMetadata.Builder> result = DatasetsCopier.copyToBuilder(this.dataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSets(Collection<DatasetMetadata.BuilderImpl> dataSets) {
            this.dataSets = DatasetsCopier.copyFromBuilder(dataSets);
        }

        @Override
        public final Builder dataSets(Collection<DatasetMetadata> dataSets) {
            this.dataSets = DatasetsCopier.copy(dataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(DatasetMetadata... dataSets) {
            dataSets(Arrays.asList(dataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(Consumer<DatasetMetadata.Builder>... dataSets) {
            dataSets(Stream.of(dataSets).map(c -> DatasetMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TopicConfigOptions.Builder getConfigOptions() {
            return configOptions != null ? configOptions.toBuilder() : null;
        }

        public final void setConfigOptions(TopicConfigOptions.BuilderImpl configOptions) {
            this.configOptions = configOptions != null ? configOptions.build() : null;
        }

        @Override
        public final Builder configOptions(TopicConfigOptions configOptions) {
            this.configOptions = configOptions;
            return this;
        }

        @Override
        public TopicDetails build() {
            return new TopicDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
