/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>TopBottomFilter</code> filters values that are at the top or the bottom.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopBottomFilter implements SdkPojo, Serializable, ToCopyableBuilder<TopBottomFilter.Builder, TopBottomFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterId").getter(getter(TopBottomFilter::filterId)).setter(setter(Builder::filterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()).build();

    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(TopBottomFilter::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(TopBottomFilter::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<List<AggregationSortConfiguration>> AGGREGATION_SORT_CONFIGURATIONS_FIELD = SdkField
            .<List<AggregationSortConfiguration>> builder(MarshallingType.LIST)
            .memberName("AggregationSortConfigurations")
            .getter(getter(TopBottomFilter::aggregationSortConfigurations))
            .setter(setter(Builder::aggregationSortConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationSortConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregationSortConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregationSortConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeGranularity").getter(getter(TopBottomFilter::timeGranularityAsString))
            .setter(setter(Builder::timeGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()).build();

    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterName").getter(getter(TopBottomFilter::parameterName)).setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()).build();

    private static final SdkField<DefaultFilterControlConfiguration> DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD = SdkField
            .<DefaultFilterControlConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultFilterControlConfiguration")
            .getter(getter(TopBottomFilter::defaultFilterControlConfiguration))
            .setter(setter(Builder::defaultFilterControlConfiguration))
            .constructor(DefaultFilterControlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultFilterControlConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD,
            LIMIT_FIELD, AGGREGATION_SORT_CONFIGURATIONS_FIELD, TIME_GRANULARITY_FIELD, PARAMETER_NAME_FIELD,
            DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterId;

    private final ColumnIdentifier column;

    private final Integer limit;

    private final List<AggregationSortConfiguration> aggregationSortConfigurations;

    private final String timeGranularity;

    private final String parameterName;

    private final DefaultFilterControlConfiguration defaultFilterControlConfiguration;

    private TopBottomFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.limit = builder.limit;
        this.aggregationSortConfigurations = builder.aggregationSortConfigurations;
        this.timeGranularity = builder.timeGranularity;
        this.parameterName = builder.parameterName;
        this.defaultFilterControlConfiguration = builder.defaultFilterControlConfiguration;
    }

    /**
     * <p>
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     * </p>
     * 
     * @return An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public final String filterId() {
        return filterId;
    }

    /**
     * <p>
     * The column that the filter is applied to.
     * </p>
     * 
     * @return The column that the filter is applied to.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * The number of items to include in the top bottom filter results.
     * </p>
     * 
     * @return The number of items to include in the top bottom filter results.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregationSortConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAggregationSortConfigurations() {
        return aggregationSortConfigurations != null && !(aggregationSortConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The aggregation and sort configuration of the top bottom filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregationSortConfigurations} method.
     * </p>
     * 
     * @return The aggregation and sort configuration of the top bottom filter.
     */
    public final List<AggregationSortConfiguration> aggregationSortConfigurations() {
        return aggregationSortConfigurations;
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TimeGranularity
     */
    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(timeGranularity);
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TimeGranularity
     */
    public final String timeGranularityAsString() {
        return timeGranularity;
    }

    /**
     * <p>
     * The parameter whose value should be used for the filter value.
     * </p>
     * 
     * @return The parameter whose value should be used for the filter value.
     */
    public final String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple
     * sheets.
     * </p>
     * 
     * @return The default configurations for the associated controls. This applies only for filters that are scoped to
     *         multiple sheets.
     */
    public final DefaultFilterControlConfiguration defaultFilterControlConfiguration() {
        return defaultFilterControlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterId());
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregationSortConfigurations() ? aggregationSortConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultFilterControlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopBottomFilter)) {
            return false;
        }
        TopBottomFilter other = (TopBottomFilter) obj;
        return Objects.equals(filterId(), other.filterId()) && Objects.equals(column(), other.column())
                && Objects.equals(limit(), other.limit())
                && hasAggregationSortConfigurations() == other.hasAggregationSortConfigurations()
                && Objects.equals(aggregationSortConfigurations(), other.aggregationSortConfigurations())
                && Objects.equals(timeGranularityAsString(), other.timeGranularityAsString())
                && Objects.equals(parameterName(), other.parameterName())
                && Objects.equals(defaultFilterControlConfiguration(), other.defaultFilterControlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("TopBottomFilter")
                .add("FilterId", filterId())
                .add("Column", column())
                .add("Limit", limit())
                .add("AggregationSortConfigurations", hasAggregationSortConfigurations() ? aggregationSortConfigurations() : null)
                .add("TimeGranularity", timeGranularityAsString()).add("ParameterName", parameterName())
                .add("DefaultFilterControlConfiguration", defaultFilterControlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterId":
            return Optional.ofNullable(clazz.cast(filterId()));
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "AggregationSortConfigurations":
            return Optional.ofNullable(clazz.cast(aggregationSortConfigurations()));
        case "TimeGranularity":
            return Optional.ofNullable(clazz.cast(timeGranularityAsString()));
        case "ParameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "DefaultFilterControlConfiguration":
            return Optional.ofNullable(clazz.cast(defaultFilterControlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilterId", FILTER_ID_FIELD);
        map.put("Column", COLUMN_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("AggregationSortConfigurations", AGGREGATION_SORT_CONFIGURATIONS_FIELD);
        map.put("TimeGranularity", TIME_GRANULARITY_FIELD);
        map.put("ParameterName", PARAMETER_NAME_FIELD);
        map.put("DefaultFilterControlConfiguration", DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopBottomFilter, T> g) {
        return obj -> g.apply((TopBottomFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopBottomFilter> {
        /**
         * <p>
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * </p>
         * 
         * @param filterId
         *        An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterId(String filterId);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * 
         * @param column
         *        The column that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * The number of items to include in the top bottom filter results.
         * </p>
         * 
         * @param limit
         *        The number of items to include in the top bottom filter results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The aggregation and sort configuration of the top bottom filter.
         * </p>
         * 
         * @param aggregationSortConfigurations
         *        The aggregation and sort configuration of the top bottom filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationSortConfigurations(Collection<AggregationSortConfiguration> aggregationSortConfigurations);

        /**
         * <p>
         * The aggregation and sort configuration of the top bottom filter.
         * </p>
         * 
         * @param aggregationSortConfigurations
         *        The aggregation and sort configuration of the top bottom filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationSortConfigurations(AggregationSortConfiguration... aggregationSortConfigurations);

        /**
         * <p>
         * The aggregation and sort configuration of the top bottom filter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AggregationSortConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AggregationSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AggregationSortConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #aggregationSortConfigurations(List<AggregationSortConfiguration>)}.
         * 
         * @param aggregationSortConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AggregationSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationSortConfigurations(java.util.Collection<AggregationSortConfiguration>)
         */
        Builder aggregationSortConfigurations(Consumer<AggregationSortConfiguration.Builder>... aggregationSortConfigurations);

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(String timeGranularity);

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(TimeGranularity timeGranularity);

        /**
         * <p>
         * The parameter whose value should be used for the filter value.
         * </p>
         * 
         * @param parameterName
         *        The parameter whose value should be used for the filter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * The default configurations for the associated controls. This applies only for filters that are scoped to
         * multiple sheets.
         * </p>
         * 
         * @param defaultFilterControlConfiguration
         *        The default configurations for the associated controls. This applies only for filters that are scoped
         *        to multiple sheets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration);

        /**
         * <p>
         * The default configurations for the associated controls. This applies only for filters that are scoped to
         * multiple sheets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultFilterControlConfiguration.Builder} avoiding the need to create one manually via
         * {@link DefaultFilterControlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultFilterControlConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #defaultFilterControlConfiguration(DefaultFilterControlConfiguration)}.
         * 
         * @param defaultFilterControlConfiguration
         *        a consumer that will call methods on {@link DefaultFilterControlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultFilterControlConfiguration(DefaultFilterControlConfiguration)
         */
        default Builder defaultFilterControlConfiguration(
                Consumer<DefaultFilterControlConfiguration.Builder> defaultFilterControlConfiguration) {
            return defaultFilterControlConfiguration(DefaultFilterControlConfiguration.builder()
                    .applyMutation(defaultFilterControlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filterId;

        private ColumnIdentifier column;

        private Integer limit;

        private List<AggregationSortConfiguration> aggregationSortConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String timeGranularity;

        private String parameterName;

        private DefaultFilterControlConfiguration defaultFilterControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TopBottomFilter model) {
            filterId(model.filterId);
            column(model.column);
            limit(model.limit);
            aggregationSortConfigurations(model.aggregationSortConfigurations);
            timeGranularity(model.timeGranularity);
            parameterName(model.parameterName);
            defaultFilterControlConfiguration(model.defaultFilterControlConfiguration);
        }

        public final String getFilterId() {
            return filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final List<AggregationSortConfiguration.Builder> getAggregationSortConfigurations() {
            List<AggregationSortConfiguration.Builder> result = AggregationSortConfigurationListCopier
                    .copyToBuilder(this.aggregationSortConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregationSortConfigurations(
                Collection<AggregationSortConfiguration.BuilderImpl> aggregationSortConfigurations) {
            this.aggregationSortConfigurations = AggregationSortConfigurationListCopier
                    .copyFromBuilder(aggregationSortConfigurations);
        }

        @Override
        public final Builder aggregationSortConfigurations(Collection<AggregationSortConfiguration> aggregationSortConfigurations) {
            this.aggregationSortConfigurations = AggregationSortConfigurationListCopier.copy(aggregationSortConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationSortConfigurations(AggregationSortConfiguration... aggregationSortConfigurations) {
            aggregationSortConfigurations(Arrays.asList(aggregationSortConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationSortConfigurations(
                Consumer<AggregationSortConfiguration.Builder>... aggregationSortConfigurations) {
            aggregationSortConfigurations(Stream.of(aggregationSortConfigurations)
                    .map(c -> AggregationSortConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTimeGranularity() {
            return timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final String getParameterName() {
            return parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final DefaultFilterControlConfiguration.Builder getDefaultFilterControlConfiguration() {
            return defaultFilterControlConfiguration != null ? defaultFilterControlConfiguration.toBuilder() : null;
        }

        public final void setDefaultFilterControlConfiguration(
                DefaultFilterControlConfiguration.BuilderImpl defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration != null ? defaultFilterControlConfiguration
                    .build() : null;
        }

        @Override
        public final Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration;
            return this;
        }

        @Override
        public TopBottomFilter build() {
            return new TopBottomFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
