/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters that are required to connect to a Starburst data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StarburstParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<StarburstParameters.Builder, StarburstParameters> {
    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Host")
            .getter(getter(StarburstParameters::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(StarburstParameters::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(StarburstParameters::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductType").getter(getter(StarburstParameters::productTypeAsString))
            .setter(setter(Builder::productType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductType").build()).build();

    private static final SdkField<String> DATABASE_ACCESS_CONTROL_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseAccessControlRole").getter(getter(StarburstParameters::databaseAccessControlRole))
            .setter(setter(Builder::databaseAccessControlRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseAccessControlRole").build())
            .build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationType").getter(getter(StarburstParameters::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<OAuthParameters> O_AUTH_PARAMETERS_FIELD = SdkField
            .<OAuthParameters> builder(MarshallingType.SDK_POJO).memberName("OAuthParameters")
            .getter(getter(StarburstParameters::oAuthParameters)).setter(setter(Builder::oAuthParameters))
            .constructor(OAuthParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthParameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, PORT_FIELD,
            CATALOG_FIELD, PRODUCT_TYPE_FIELD, DATABASE_ACCESS_CONTROL_ROLE_FIELD, AUTHENTICATION_TYPE_FIELD,
            O_AUTH_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String host;

    private final Integer port;

    private final String catalog;

    private final String productType;

    private final String databaseAccessControlRole;

    private final String authenticationType;

    private final OAuthParameters oAuthParameters;

    private StarburstParameters(BuilderImpl builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.catalog = builder.catalog;
        this.productType = builder.productType;
        this.databaseAccessControlRole = builder.databaseAccessControlRole;
        this.authenticationType = builder.authenticationType;
        this.oAuthParameters = builder.oAuthParameters;
    }

    /**
     * <p>
     * The host name of the Starburst data source.
     * </p>
     * 
     * @return The host name of the Starburst data source.
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * The port for the Starburst data source.
     * </p>
     * 
     * @return The port for the Starburst data source.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The catalog name for the Starburst data source.
     * </p>
     * 
     * @return The catalog name for the Starburst data source.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The product type for the Starburst data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link StarburstProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The product type for the Starburst data source.
     * @see StarburstProductType
     */
    public final StarburstProductType productType() {
        return StarburstProductType.fromValue(productType);
    }

    /**
     * <p>
     * The product type for the Starburst data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link StarburstProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The product type for the Starburst data source.
     * @see StarburstProductType
     */
    public final String productTypeAsString() {
        return productType;
    }

    /**
     * <p>
     * The database access control role.
     * </p>
     * 
     * @return The database access control role.
     */
    public final String databaseAccessControlRole() {
        return databaseAccessControlRole;
    }

    /**
     * <p>
     * The authentication type that you want to use for your connection. This parameter accepts OAuth and non-OAuth
     * authentication types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type that you want to use for your connection. This parameter accepts OAuth and
     *         non-OAuth authentication types.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication type that you want to use for your connection. This parameter accepts OAuth and non-OAuth
     * authentication types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type that you want to use for your connection. This parameter accepts OAuth and
     *         non-OAuth authentication types.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * An object that contains information needed to create a data source connection between an QuickSight account and
     * Starburst.
     * </p>
     * 
     * @return An object that contains information needed to create a data source connection between an QuickSight
     *         account and Starburst.
     */
    public final OAuthParameters oAuthParameters() {
        return oAuthParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(databaseAccessControlRole());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StarburstParameters)) {
            return false;
        }
        StarburstParameters other = (StarburstParameters) obj;
        return Objects.equals(host(), other.host()) && Objects.equals(port(), other.port())
                && Objects.equals(catalog(), other.catalog())
                && Objects.equals(productTypeAsString(), other.productTypeAsString())
                && Objects.equals(databaseAccessControlRole(), other.databaseAccessControlRole())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(oAuthParameters(), other.oAuthParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StarburstParameters").add("Host", host()).add("Port", port()).add("Catalog", catalog())
                .add("ProductType", productTypeAsString()).add("DatabaseAccessControlRole", databaseAccessControlRole())
                .add("AuthenticationType", authenticationTypeAsString()).add("OAuthParameters", oAuthParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "ProductType":
            return Optional.ofNullable(clazz.cast(productTypeAsString()));
        case "DatabaseAccessControlRole":
            return Optional.ofNullable(clazz.cast(databaseAccessControlRole()));
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "OAuthParameters":
            return Optional.ofNullable(clazz.cast(oAuthParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Host", HOST_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("ProductType", PRODUCT_TYPE_FIELD);
        map.put("DatabaseAccessControlRole", DATABASE_ACCESS_CONTROL_ROLE_FIELD);
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("OAuthParameters", O_AUTH_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StarburstParameters, T> g) {
        return obj -> g.apply((StarburstParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StarburstParameters> {
        /**
         * <p>
         * The host name of the Starburst data source.
         * </p>
         * 
         * @param host
         *        The host name of the Starburst data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * The port for the Starburst data source.
         * </p>
         * 
         * @param port
         *        The port for the Starburst data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The catalog name for the Starburst data source.
         * </p>
         * 
         * @param catalog
         *        The catalog name for the Starburst data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The product type for the Starburst data source.
         * </p>
         * 
         * @param productType
         *        The product type for the Starburst data source.
         * @see StarburstProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StarburstProductType
         */
        Builder productType(String productType);

        /**
         * <p>
         * The product type for the Starburst data source.
         * </p>
         * 
         * @param productType
         *        The product type for the Starburst data source.
         * @see StarburstProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StarburstProductType
         */
        Builder productType(StarburstProductType productType);

        /**
         * <p>
         * The database access control role.
         * </p>
         * 
         * @param databaseAccessControlRole
         *        The database access control role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseAccessControlRole(String databaseAccessControlRole);

        /**
         * <p>
         * The authentication type that you want to use for your connection. This parameter accepts OAuth and non-OAuth
         * authentication types.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type that you want to use for your connection. This parameter accepts OAuth and
         *        non-OAuth authentication types.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication type that you want to use for your connection. This parameter accepts OAuth and non-OAuth
         * authentication types.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type that you want to use for your connection. This parameter accepts OAuth and
         *        non-OAuth authentication types.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * An object that contains information needed to create a data source connection between an QuickSight account
         * and Starburst.
         * </p>
         * 
         * @param oAuthParameters
         *        An object that contains information needed to create a data source connection between an QuickSight
         *        account and Starburst.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthParameters(OAuthParameters oAuthParameters);

        /**
         * <p>
         * An object that contains information needed to create a data source connection between an QuickSight account
         * and Starburst.
         * </p>
         * This is a convenience method that creates an instance of the {@link OAuthParameters.Builder} avoiding the
         * need to create one manually via {@link OAuthParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuthParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #oAuthParameters(OAuthParameters)}.
         * 
         * @param oAuthParameters
         *        a consumer that will call methods on {@link OAuthParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuthParameters(OAuthParameters)
         */
        default Builder oAuthParameters(Consumer<OAuthParameters.Builder> oAuthParameters) {
            return oAuthParameters(OAuthParameters.builder().applyMutation(oAuthParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String host;

        private Integer port;

        private String catalog;

        private String productType;

        private String databaseAccessControlRole;

        private String authenticationType;

        private OAuthParameters oAuthParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(StarburstParameters model) {
            host(model.host);
            port(model.port);
            catalog(model.catalog);
            productType(model.productType);
            databaseAccessControlRole(model.databaseAccessControlRole);
            authenticationType(model.authenticationType);
            oAuthParameters(model.oAuthParameters);
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getProductType() {
            return productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(StarburstProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final String getDatabaseAccessControlRole() {
            return databaseAccessControlRole;
        }

        public final void setDatabaseAccessControlRole(String databaseAccessControlRole) {
            this.databaseAccessControlRole = databaseAccessControlRole;
        }

        @Override
        public final Builder databaseAccessControlRole(String databaseAccessControlRole) {
            this.databaseAccessControlRole = databaseAccessControlRole;
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final OAuthParameters.Builder getOAuthParameters() {
            return oAuthParameters != null ? oAuthParameters.toBuilder() : null;
        }

        public final void setOAuthParameters(OAuthParameters.BuilderImpl oAuthParameters) {
            this.oAuthParameters = oAuthParameters != null ? oAuthParameters.build() : null;
        }

        @Override
        public final Builder oAuthParameters(OAuthParameters oAuthParameters) {
            this.oAuthParameters = oAuthParameters;
            return this;
        }

        @Override
        public StarburstParameters build() {
            return new StarburstParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
