/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about the users that the dashboard snapshot is generated for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotUserConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotUserConfiguration.Builder, SnapshotUserConfiguration> {
    private static final SdkField<List<SnapshotAnonymousUser>> ANONYMOUS_USERS_FIELD = SdkField
            .<List<SnapshotAnonymousUser>> builder(MarshallingType.LIST)
            .memberName("AnonymousUsers")
            .getter(getter(SnapshotUserConfiguration::anonymousUsers))
            .setter(setter(Builder::anonymousUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnonymousUsers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SnapshotAnonymousUser> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotAnonymousUser::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANONYMOUS_USERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SnapshotAnonymousUser> anonymousUsers;

    private SnapshotUserConfiguration(BuilderImpl builder) {
        this.anonymousUsers = builder.anonymousUsers;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnonymousUsers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnonymousUsers() {
        return anonymousUsers != null && !(anonymousUsers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of records that describe the anonymous users that the dashboard snapshot is generated for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnonymousUsers} method.
     * </p>
     * 
     * @return An array of records that describe the anonymous users that the dashboard snapshot is generated for.
     */
    public final List<SnapshotAnonymousUser> anonymousUsers() {
        return anonymousUsers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAnonymousUsers() ? anonymousUsers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotUserConfiguration)) {
            return false;
        }
        SnapshotUserConfiguration other = (SnapshotUserConfiguration) obj;
        return hasAnonymousUsers() == other.hasAnonymousUsers() && Objects.equals(anonymousUsers(), other.anonymousUsers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotUserConfiguration").add("AnonymousUsers", hasAnonymousUsers() ? anonymousUsers() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnonymousUsers":
            return Optional.ofNullable(clazz.cast(anonymousUsers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnonymousUsers", ANONYMOUS_USERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotUserConfiguration, T> g) {
        return obj -> g.apply((SnapshotUserConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotUserConfiguration> {
        /**
         * <p>
         * An array of records that describe the anonymous users that the dashboard snapshot is generated for.
         * </p>
         * 
         * @param anonymousUsers
         *        An array of records that describe the anonymous users that the dashboard snapshot is generated for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anonymousUsers(Collection<SnapshotAnonymousUser> anonymousUsers);

        /**
         * <p>
         * An array of records that describe the anonymous users that the dashboard snapshot is generated for.
         * </p>
         * 
         * @param anonymousUsers
         *        An array of records that describe the anonymous users that the dashboard snapshot is generated for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anonymousUsers(SnapshotAnonymousUser... anonymousUsers);

        /**
         * <p>
         * An array of records that describe the anonymous users that the dashboard snapshot is generated for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotAnonymousUser.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotAnonymousUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotAnonymousUser.Builder#build()} is called
         * immediately and its result is passed to {@link #anonymousUsers(List<SnapshotAnonymousUser>)}.
         * 
         * @param anonymousUsers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SnapshotAnonymousUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anonymousUsers(java.util.Collection<SnapshotAnonymousUser>)
         */
        Builder anonymousUsers(Consumer<SnapshotAnonymousUser.Builder>... anonymousUsers);
    }

    static final class BuilderImpl implements Builder {
        private List<SnapshotAnonymousUser> anonymousUsers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotUserConfiguration model) {
            anonymousUsers(model.anonymousUsers);
        }

        public final List<SnapshotAnonymousUser.Builder> getAnonymousUsers() {
            List<SnapshotAnonymousUser.Builder> result = SnapshotAnonymousUserListCopier.copyToBuilder(this.anonymousUsers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnonymousUsers(Collection<SnapshotAnonymousUser.BuilderImpl> anonymousUsers) {
            this.anonymousUsers = SnapshotAnonymousUserListCopier.copyFromBuilder(anonymousUsers);
        }

        @Override
        public final Builder anonymousUsers(Collection<SnapshotAnonymousUser> anonymousUsers) {
            this.anonymousUsers = SnapshotAnonymousUserListCopier.copy(anonymousUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anonymousUsers(SnapshotAnonymousUser... anonymousUsers) {
            anonymousUsers(Arrays.asList(anonymousUsers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anonymousUsers(Consumer<SnapshotAnonymousUser.Builder>... anonymousUsers) {
            anonymousUsers(Stream.of(anonymousUsers).map(c -> SnapshotAnonymousUser.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SnapshotUserConfiguration build() {
            return new SnapshotUserConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
