/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information on the anonymous user configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotAnonymousUser implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotAnonymousUser.Builder, SnapshotAnonymousUser> {
    private static final SdkField<List<SessionTag>> ROW_LEVEL_PERMISSION_TAGS_FIELD = SdkField
            .<List<SessionTag>> builder(MarshallingType.LIST)
            .memberName("RowLevelPermissionTags")
            .getter(getter(SnapshotAnonymousUser::rowLevelPermissionTags))
            .setter(setter(Builder::rowLevelPermissionTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SessionTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(SessionTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ROW_LEVEL_PERMISSION_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SessionTag> rowLevelPermissionTags;

    private SnapshotAnonymousUser(BuilderImpl builder) {
        this.rowLevelPermissionTags = builder.rowLevelPermissionTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the RowLevelPermissionTags property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRowLevelPermissionTags() {
        return rowLevelPermissionTags != null && !(rowLevelPermissionTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be used for row-level security (RLS). Make sure that the relevant datasets have RLS tags configured
     * before you start a snapshot export job. You can configure the RLS tags of a dataset with a
     * <code>DataSet$RowLevelPermissionTagConfiguration</code> API call.
     * </p>
     * <p>
     * These are not the tags that are used for Amazon Web Services resource tagging. For more information on row level
     * security in QuickSight, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level Security
     * (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRowLevelPermissionTags} method.
     * </p>
     * 
     * @return The tags to be used for row-level security (RLS). Make sure that the relevant datasets have RLS tags
     *         configured before you start a snapshot export job. You can configure the RLS tags of a dataset with a
     *         <code>DataSet$RowLevelPermissionTagConfiguration</code> API call.</p>
     *         <p>
     *         These are not the tags that are used for Amazon Web Services resource tagging. For more information on
     *         row level security in QuickSight, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level
     *         Security (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.
     */
    public final List<SessionTag> rowLevelPermissionTags() {
        return rowLevelPermissionTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRowLevelPermissionTags() ? rowLevelPermissionTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotAnonymousUser)) {
            return false;
        }
        SnapshotAnonymousUser other = (SnapshotAnonymousUser) obj;
        return hasRowLevelPermissionTags() == other.hasRowLevelPermissionTags()
                && Objects.equals(rowLevelPermissionTags(), other.rowLevelPermissionTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotAnonymousUser")
                .add("RowLevelPermissionTags", hasRowLevelPermissionTags() ? rowLevelPermissionTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RowLevelPermissionTags":
            return Optional.ofNullable(clazz.cast(rowLevelPermissionTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RowLevelPermissionTags", ROW_LEVEL_PERMISSION_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotAnonymousUser, T> g) {
        return obj -> g.apply((SnapshotAnonymousUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotAnonymousUser> {
        /**
         * <p>
         * The tags to be used for row-level security (RLS). Make sure that the relevant datasets have RLS tags
         * configured before you start a snapshot export job. You can configure the RLS tags of a dataset with a
         * <code>DataSet$RowLevelPermissionTagConfiguration</code> API call.
         * </p>
         * <p>
         * These are not the tags that are used for Amazon Web Services resource tagging. For more information on row
         * level security in QuickSight, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level
         * Security (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param rowLevelPermissionTags
         *        The tags to be used for row-level security (RLS). Make sure that the relevant datasets have RLS tags
         *        configured before you start a snapshot export job. You can configure the RLS tags of a dataset with a
         *        <code>DataSet$RowLevelPermissionTagConfiguration</code> API call.</p>
         *        <p>
         *        These are not the tags that are used for Amazon Web Services resource tagging. For more information on
         *        row level security in QuickSight, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level
         *        Security (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowLevelPermissionTags(Collection<SessionTag> rowLevelPermissionTags);

        /**
         * <p>
         * The tags to be used for row-level security (RLS). Make sure that the relevant datasets have RLS tags
         * configured before you start a snapshot export job. You can configure the RLS tags of a dataset with a
         * <code>DataSet$RowLevelPermissionTagConfiguration</code> API call.
         * </p>
         * <p>
         * These are not the tags that are used for Amazon Web Services resource tagging. For more information on row
         * level security in QuickSight, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level
         * Security (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param rowLevelPermissionTags
         *        The tags to be used for row-level security (RLS). Make sure that the relevant datasets have RLS tags
         *        configured before you start a snapshot export job. You can configure the RLS tags of a dataset with a
         *        <code>DataSet$RowLevelPermissionTagConfiguration</code> API call.</p>
         *        <p>
         *        These are not the tags that are used for Amazon Web Services resource tagging. For more information on
         *        row level security in QuickSight, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level
         *        Security (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowLevelPermissionTags(SessionTag... rowLevelPermissionTags);

        /**
         * <p>
         * The tags to be used for row-level security (RLS). Make sure that the relevant datasets have RLS tags
         * configured before you start a snapshot export job. You can configure the RLS tags of a dataset with a
         * <code>DataSet$RowLevelPermissionTagConfiguration</code> API call.
         * </p>
         * <p>
         * These are not the tags that are used for Amazon Web Services resource tagging. For more information on row
         * level security in QuickSight, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level
         * Security (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SessionTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.SessionTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SessionTag.Builder#build()} is called immediately and
         * its result is passed to {@link #rowLevelPermissionTags(List<SessionTag>)}.
         * 
         * @param rowLevelPermissionTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SessionTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowLevelPermissionTags(java.util.Collection<SessionTag>)
         */
        Builder rowLevelPermissionTags(Consumer<SessionTag.Builder>... rowLevelPermissionTags);
    }

    static final class BuilderImpl implements Builder {
        private List<SessionTag> rowLevelPermissionTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotAnonymousUser model) {
            rowLevelPermissionTags(model.rowLevelPermissionTags);
        }

        public final List<SessionTag.Builder> getRowLevelPermissionTags() {
            List<SessionTag.Builder> result = SessionTagListCopier.copyToBuilder(this.rowLevelPermissionTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRowLevelPermissionTags(Collection<SessionTag.BuilderImpl> rowLevelPermissionTags) {
            this.rowLevelPermissionTags = SessionTagListCopier.copyFromBuilder(rowLevelPermissionTags);
        }

        @Override
        public final Builder rowLevelPermissionTags(Collection<SessionTag> rowLevelPermissionTags) {
            this.rowLevelPermissionTags = SessionTagListCopier.copy(rowLevelPermissionTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowLevelPermissionTags(SessionTag... rowLevelPermissionTags) {
            rowLevelPermissionTags(Arrays.asList(rowLevelPermissionTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowLevelPermissionTags(Consumer<SessionTag.Builder>... rowLevelPermissionTags) {
            rowLevelPermissionTags(Stream.of(rowLevelPermissionTags).map(c -> SessionTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SnapshotAnonymousUser build() {
            return new SnapshotAnonymousUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
