/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The theme display options for sheets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SheetStyle implements SdkPojo, Serializable, ToCopyableBuilder<SheetStyle.Builder, SheetStyle> {
    private static final SdkField<TileStyle> TILE_FIELD = SdkField.<TileStyle> builder(MarshallingType.SDK_POJO)
            .memberName("Tile").getter(getter(SheetStyle::tile)).setter(setter(Builder::tile)).constructor(TileStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tile").build()).build();

    private static final SdkField<TileLayoutStyle> TILE_LAYOUT_FIELD = SdkField
            .<TileLayoutStyle> builder(MarshallingType.SDK_POJO).memberName("TileLayout").getter(getter(SheetStyle::tileLayout))
            .setter(setter(Builder::tileLayout)).constructor(TileLayoutStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TileLayout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TILE_FIELD, TILE_LAYOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TileStyle tile;

    private final TileLayoutStyle tileLayout;

    private SheetStyle(BuilderImpl builder) {
        this.tile = builder.tile;
        this.tileLayout = builder.tileLayout;
    }

    /**
     * <p>
     * The display options for tiles.
     * </p>
     * 
     * @return The display options for tiles.
     */
    public final TileStyle tile() {
        return tile;
    }

    /**
     * <p>
     * The layout options for tiles.
     * </p>
     * 
     * @return The layout options for tiles.
     */
    public final TileLayoutStyle tileLayout() {
        return tileLayout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tile());
        hashCode = 31 * hashCode + Objects.hashCode(tileLayout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetStyle)) {
            return false;
        }
        SheetStyle other = (SheetStyle) obj;
        return Objects.equals(tile(), other.tile()) && Objects.equals(tileLayout(), other.tileLayout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SheetStyle").add("Tile", tile()).add("TileLayout", tileLayout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tile":
            return Optional.ofNullable(clazz.cast(tile()));
        case "TileLayout":
            return Optional.ofNullable(clazz.cast(tileLayout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Tile", TILE_FIELD);
        map.put("TileLayout", TILE_LAYOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SheetStyle, T> g) {
        return obj -> g.apply((SheetStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SheetStyle> {
        /**
         * <p>
         * The display options for tiles.
         * </p>
         * 
         * @param tile
         *        The display options for tiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tile(TileStyle tile);

        /**
         * <p>
         * The display options for tiles.
         * </p>
         * This is a convenience method that creates an instance of the {@link TileStyle.Builder} avoiding the need to
         * create one manually via {@link TileStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TileStyle.Builder#build()} is called immediately and its result
         * is passed to {@link #tile(TileStyle)}.
         * 
         * @param tile
         *        a consumer that will call methods on {@link TileStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tile(TileStyle)
         */
        default Builder tile(Consumer<TileStyle.Builder> tile) {
            return tile(TileStyle.builder().applyMutation(tile).build());
        }

        /**
         * <p>
         * The layout options for tiles.
         * </p>
         * 
         * @param tileLayout
         *        The layout options for tiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tileLayout(TileLayoutStyle tileLayout);

        /**
         * <p>
         * The layout options for tiles.
         * </p>
         * This is a convenience method that creates an instance of the {@link TileLayoutStyle.Builder} avoiding the
         * need to create one manually via {@link TileLayoutStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TileLayoutStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #tileLayout(TileLayoutStyle)}.
         * 
         * @param tileLayout
         *        a consumer that will call methods on {@link TileLayoutStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tileLayout(TileLayoutStyle)
         */
        default Builder tileLayout(Consumer<TileLayoutStyle.Builder> tileLayout) {
            return tileLayout(TileLayoutStyle.builder().applyMutation(tileLayout).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TileStyle tile;

        private TileLayoutStyle tileLayout;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetStyle model) {
            tile(model.tile);
            tileLayout(model.tileLayout);
        }

        public final TileStyle.Builder getTile() {
            return tile != null ? tile.toBuilder() : null;
        }

        public final void setTile(TileStyle.BuilderImpl tile) {
            this.tile = tile != null ? tile.build() : null;
        }

        @Override
        public final Builder tile(TileStyle tile) {
            this.tile = tile;
            return this;
        }

        public final TileLayoutStyle.Builder getTileLayout() {
            return tileLayout != null ? tileLayout.toBuilder() : null;
        }

        public final void setTileLayout(TileLayoutStyle.BuilderImpl tileLayout) {
            this.tileLayout = tileLayout != null ? tileLayout.build() : null;
        }

        @Override
        public final Builder tileLayout(TileLayoutStyle tileLayout) {
            this.tileLayout = tileLayout;
            return this;
        }

        @Override
        public SheetStyle build() {
            return new SheetStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
