/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A grid layout to define the placement of sheet control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SheetControlLayout implements SdkPojo, Serializable,
        ToCopyableBuilder<SheetControlLayout.Builder, SheetControlLayout> {
    private static final SdkField<SheetControlLayoutConfiguration> CONFIGURATION_FIELD = SdkField
            .<SheetControlLayoutConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(SheetControlLayout::configuration)).setter(setter(Builder::configuration))
            .constructor(SheetControlLayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SheetControlLayoutConfiguration configuration;

    private SheetControlLayout(BuilderImpl builder) {
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The configuration that determines the elements and canvas size options of sheet control.
     * </p>
     * 
     * @return The configuration that determines the elements and canvas size options of sheet control.
     */
    public final SheetControlLayoutConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetControlLayout)) {
            return false;
        }
        SheetControlLayout other = (SheetControlLayout) obj;
        return Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SheetControlLayout").add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SheetControlLayout, T> g) {
        return obj -> g.apply((SheetControlLayout) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SheetControlLayout> {
        /**
         * <p>
         * The configuration that determines the elements and canvas size options of sheet control.
         * </p>
         * 
         * @param configuration
         *        The configuration that determines the elements and canvas size options of sheet control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(SheetControlLayoutConfiguration configuration);

        /**
         * <p>
         * The configuration that determines the elements and canvas size options of sheet control.
         * </p>
         * This is a convenience method that creates an instance of the {@link SheetControlLayoutConfiguration.Builder}
         * avoiding the need to create one manually via {@link SheetControlLayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SheetControlLayoutConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(SheetControlLayoutConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link SheetControlLayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(SheetControlLayoutConfiguration)
         */
        default Builder configuration(Consumer<SheetControlLayoutConfiguration.Builder> configuration) {
            return configuration(SheetControlLayoutConfiguration.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SheetControlLayoutConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetControlLayout model) {
            configuration(model.configuration);
        }

        public final SheetControlLayoutConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(SheetControlLayoutConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(SheetControlLayoutConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public SheetControlLayout build() {
            return new SheetControlLayout(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
