/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about rows for a data set SPICE ingestion.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RowInfo implements SdkPojo, Serializable, ToCopyableBuilder<RowInfo.Builder, RowInfo> {
    private static final SdkField<Long> ROWS_INGESTED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RowsIngested").getter(getter(RowInfo::rowsIngested)).setter(setter(Builder::rowsIngested))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowsIngested").build()).build();

    private static final SdkField<Long> ROWS_DROPPED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RowsDropped").getter(getter(RowInfo::rowsDropped)).setter(setter(Builder::rowsDropped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowsDropped").build()).build();

    private static final SdkField<Long> TOTAL_ROWS_IN_DATASET_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalRowsInDataset").getter(getter(RowInfo::totalRowsInDataset))
            .setter(setter(Builder::totalRowsInDataset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRowsInDataset").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROWS_INGESTED_FIELD,
            ROWS_DROPPED_FIELD, TOTAL_ROWS_IN_DATASET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long rowsIngested;

    private final Long rowsDropped;

    private final Long totalRowsInDataset;

    private RowInfo(BuilderImpl builder) {
        this.rowsIngested = builder.rowsIngested;
        this.rowsDropped = builder.rowsDropped;
        this.totalRowsInDataset = builder.totalRowsInDataset;
    }

    /**
     * <p>
     * The number of rows that were ingested.
     * </p>
     * 
     * @return The number of rows that were ingested.
     */
    public final Long rowsIngested() {
        return rowsIngested;
    }

    /**
     * <p>
     * The number of rows that were not ingested.
     * </p>
     * 
     * @return The number of rows that were not ingested.
     */
    public final Long rowsDropped() {
        return rowsDropped;
    }

    /**
     * <p>
     * The total number of rows in the dataset.
     * </p>
     * 
     * @return The total number of rows in the dataset.
     */
    public final Long totalRowsInDataset() {
        return totalRowsInDataset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rowsIngested());
        hashCode = 31 * hashCode + Objects.hashCode(rowsDropped());
        hashCode = 31 * hashCode + Objects.hashCode(totalRowsInDataset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowInfo)) {
            return false;
        }
        RowInfo other = (RowInfo) obj;
        return Objects.equals(rowsIngested(), other.rowsIngested()) && Objects.equals(rowsDropped(), other.rowsDropped())
                && Objects.equals(totalRowsInDataset(), other.totalRowsInDataset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RowInfo").add("RowsIngested", rowsIngested()).add("RowsDropped", rowsDropped())
                .add("TotalRowsInDataset", totalRowsInDataset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RowsIngested":
            return Optional.ofNullable(clazz.cast(rowsIngested()));
        case "RowsDropped":
            return Optional.ofNullable(clazz.cast(rowsDropped()));
        case "TotalRowsInDataset":
            return Optional.ofNullable(clazz.cast(totalRowsInDataset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RowsIngested", ROWS_INGESTED_FIELD);
        map.put("RowsDropped", ROWS_DROPPED_FIELD);
        map.put("TotalRowsInDataset", TOTAL_ROWS_IN_DATASET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RowInfo, T> g) {
        return obj -> g.apply((RowInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RowInfo> {
        /**
         * <p>
         * The number of rows that were ingested.
         * </p>
         * 
         * @param rowsIngested
         *        The number of rows that were ingested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowsIngested(Long rowsIngested);

        /**
         * <p>
         * The number of rows that were not ingested.
         * </p>
         * 
         * @param rowsDropped
         *        The number of rows that were not ingested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowsDropped(Long rowsDropped);

        /**
         * <p>
         * The total number of rows in the dataset.
         * </p>
         * 
         * @param totalRowsInDataset
         *        The total number of rows in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRowsInDataset(Long totalRowsInDataset);
    }

    static final class BuilderImpl implements Builder {
        private Long rowsIngested;

        private Long rowsDropped;

        private Long totalRowsInDataset;

        private BuilderImpl() {
        }

        private BuilderImpl(RowInfo model) {
            rowsIngested(model.rowsIngested);
            rowsDropped(model.rowsDropped);
            totalRowsInDataset(model.totalRowsInDataset);
        }

        public final Long getRowsIngested() {
            return rowsIngested;
        }

        public final void setRowsIngested(Long rowsIngested) {
            this.rowsIngested = rowsIngested;
        }

        @Override
        public final Builder rowsIngested(Long rowsIngested) {
            this.rowsIngested = rowsIngested;
            return this;
        }

        public final Long getRowsDropped() {
            return rowsDropped;
        }

        public final void setRowsDropped(Long rowsDropped) {
            this.rowsDropped = rowsDropped;
        }

        @Override
        public final Builder rowsDropped(Long rowsDropped) {
            this.rowsDropped = rowsDropped;
            return this;
        }

        public final Long getTotalRowsInDataset() {
            return totalRowsInDataset;
        }

        public final void setTotalRowsInDataset(Long totalRowsInDataset) {
            this.totalRowsInDataset = totalRowsInDataset;
        }

        @Override
        public final Builder totalRowsInDataset(Long totalRowsInDataset) {
            this.totalRowsInDataset = totalRowsInDataset;
            return this;
        }

        @Override
        public RowInfo build() {
            return new RowInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
