/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The feature configuration for an embedded dashboard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisteredUserDashboardFeatureConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<RegisteredUserDashboardFeatureConfigurations.Builder, RegisteredUserDashboardFeatureConfigurations> {
    private static final SdkField<StatePersistenceConfigurations> STATE_PERSISTENCE_FIELD = SdkField
            .<StatePersistenceConfigurations> builder(MarshallingType.SDK_POJO).memberName("StatePersistence")
            .getter(getter(RegisteredUserDashboardFeatureConfigurations::statePersistence))
            .setter(setter(Builder::statePersistence)).constructor(StatePersistenceConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatePersistence").build()).build();

    private static final SdkField<SharedViewConfigurations> SHARED_VIEW_FIELD = SdkField
            .<SharedViewConfigurations> builder(MarshallingType.SDK_POJO).memberName("SharedView")
            .getter(getter(RegisteredUserDashboardFeatureConfigurations::sharedView)).setter(setter(Builder::sharedView))
            .constructor(SharedViewConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedView").build()).build();

    private static final SdkField<BookmarksConfigurations> BOOKMARKS_FIELD = SdkField
            .<BookmarksConfigurations> builder(MarshallingType.SDK_POJO).memberName("Bookmarks")
            .getter(getter(RegisteredUserDashboardFeatureConfigurations::bookmarks)).setter(setter(Builder::bookmarks))
            .constructor(BookmarksConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bookmarks").build()).build();

    private static final SdkField<AmazonQInQuickSightDashboardConfigurations> AMAZON_Q_IN_QUICK_SIGHT_FIELD = SdkField
            .<AmazonQInQuickSightDashboardConfigurations> builder(MarshallingType.SDK_POJO).memberName("AmazonQInQuickSight")
            .getter(getter(RegisteredUserDashboardFeatureConfigurations::amazonQInQuickSight))
            .setter(setter(Builder::amazonQInQuickSight)).constructor(AmazonQInQuickSightDashboardConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonQInQuickSight").build())
            .build();

    private static final SdkField<SchedulesConfigurations> SCHEDULES_FIELD = SdkField
            .<SchedulesConfigurations> builder(MarshallingType.SDK_POJO).memberName("Schedules")
            .getter(getter(RegisteredUserDashboardFeatureConfigurations::schedules)).setter(setter(Builder::schedules))
            .constructor(SchedulesConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedules").build()).build();

    private static final SdkField<RecentSnapshotsConfigurations> RECENT_SNAPSHOTS_FIELD = SdkField
            .<RecentSnapshotsConfigurations> builder(MarshallingType.SDK_POJO).memberName("RecentSnapshots")
            .getter(getter(RegisteredUserDashboardFeatureConfigurations::recentSnapshots))
            .setter(setter(Builder::recentSnapshots)).constructor(RecentSnapshotsConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecentSnapshots").build()).build();

    private static final SdkField<ThresholdAlertsConfigurations> THRESHOLD_ALERTS_FIELD = SdkField
            .<ThresholdAlertsConfigurations> builder(MarshallingType.SDK_POJO).memberName("ThresholdAlerts")
            .getter(getter(RegisteredUserDashboardFeatureConfigurations::thresholdAlerts))
            .setter(setter(Builder::thresholdAlerts)).constructor(ThresholdAlertsConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdAlerts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_PERSISTENCE_FIELD,
            SHARED_VIEW_FIELD, BOOKMARKS_FIELD, AMAZON_Q_IN_QUICK_SIGHT_FIELD, SCHEDULES_FIELD, RECENT_SNAPSHOTS_FIELD,
            THRESHOLD_ALERTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StatePersistenceConfigurations statePersistence;

    private final SharedViewConfigurations sharedView;

    private final BookmarksConfigurations bookmarks;

    private final AmazonQInQuickSightDashboardConfigurations amazonQInQuickSight;

    private final SchedulesConfigurations schedules;

    private final RecentSnapshotsConfigurations recentSnapshots;

    private final ThresholdAlertsConfigurations thresholdAlerts;

    private RegisteredUserDashboardFeatureConfigurations(BuilderImpl builder) {
        this.statePersistence = builder.statePersistence;
        this.sharedView = builder.sharedView;
        this.bookmarks = builder.bookmarks;
        this.amazonQInQuickSight = builder.amazonQInQuickSight;
        this.schedules = builder.schedules;
        this.recentSnapshots = builder.recentSnapshots;
        this.thresholdAlerts = builder.thresholdAlerts;
    }

    /**
     * <p>
     * The state persistence settings of an embedded dashboard.
     * </p>
     * 
     * @return The state persistence settings of an embedded dashboard.
     */
    public final StatePersistenceConfigurations statePersistence() {
        return statePersistence;
    }

    /**
     * <p>
     * The shared view settings of an embedded dashboard.
     * </p>
     * 
     * @return The shared view settings of an embedded dashboard.
     */
    public final SharedViewConfigurations sharedView() {
        return sharedView;
    }

    /**
     * <p>
     * The bookmarks configuration for an embedded dashboard in QuickSight.
     * </p>
     * 
     * @return The bookmarks configuration for an embedded dashboard in QuickSight.
     */
    public final BookmarksConfigurations bookmarks() {
        return bookmarks;
    }

    /**
     * <p>
     * The Amazon Q configurations of an embedded QuickSight dashboard.
     * </p>
     * 
     * @return The Amazon Q configurations of an embedded QuickSight dashboard.
     */
    public final AmazonQInQuickSightDashboardConfigurations amazonQInQuickSight() {
        return amazonQInQuickSight;
    }

    /**
     * <p>
     * The schedules configuration for an embedded QuickSight dashboard.
     * </p>
     * 
     * @return The schedules configuration for an embedded QuickSight dashboard.
     */
    public final SchedulesConfigurations schedules() {
        return schedules;
    }

    /**
     * <p>
     * The recent snapshots configuration for an QuickSight embedded dashboard
     * </p>
     * 
     * @return The recent snapshots configuration for an QuickSight embedded dashboard
     */
    public final RecentSnapshotsConfigurations recentSnapshots() {
        return recentSnapshots;
    }

    /**
     * <p>
     * The threshold alerts configuration for an QuickSight embedded dashboard.
     * </p>
     * 
     * @return The threshold alerts configuration for an QuickSight embedded dashboard.
     */
    public final ThresholdAlertsConfigurations thresholdAlerts() {
        return thresholdAlerts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statePersistence());
        hashCode = 31 * hashCode + Objects.hashCode(sharedView());
        hashCode = 31 * hashCode + Objects.hashCode(bookmarks());
        hashCode = 31 * hashCode + Objects.hashCode(amazonQInQuickSight());
        hashCode = 31 * hashCode + Objects.hashCode(schedules());
        hashCode = 31 * hashCode + Objects.hashCode(recentSnapshots());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdAlerts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisteredUserDashboardFeatureConfigurations)) {
            return false;
        }
        RegisteredUserDashboardFeatureConfigurations other = (RegisteredUserDashboardFeatureConfigurations) obj;
        return Objects.equals(statePersistence(), other.statePersistence()) && Objects.equals(sharedView(), other.sharedView())
                && Objects.equals(bookmarks(), other.bookmarks())
                && Objects.equals(amazonQInQuickSight(), other.amazonQInQuickSight())
                && Objects.equals(schedules(), other.schedules()) && Objects.equals(recentSnapshots(), other.recentSnapshots())
                && Objects.equals(thresholdAlerts(), other.thresholdAlerts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisteredUserDashboardFeatureConfigurations").add("StatePersistence", statePersistence())
                .add("SharedView", sharedView()).add("Bookmarks", bookmarks()).add("AmazonQInQuickSight", amazonQInQuickSight())
                .add("Schedules", schedules()).add("RecentSnapshots", recentSnapshots())
                .add("ThresholdAlerts", thresholdAlerts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatePersistence":
            return Optional.ofNullable(clazz.cast(statePersistence()));
        case "SharedView":
            return Optional.ofNullable(clazz.cast(sharedView()));
        case "Bookmarks":
            return Optional.ofNullable(clazz.cast(bookmarks()));
        case "AmazonQInQuickSight":
            return Optional.ofNullable(clazz.cast(amazonQInQuickSight()));
        case "Schedules":
            return Optional.ofNullable(clazz.cast(schedules()));
        case "RecentSnapshots":
            return Optional.ofNullable(clazz.cast(recentSnapshots()));
        case "ThresholdAlerts":
            return Optional.ofNullable(clazz.cast(thresholdAlerts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StatePersistence", STATE_PERSISTENCE_FIELD);
        map.put("SharedView", SHARED_VIEW_FIELD);
        map.put("Bookmarks", BOOKMARKS_FIELD);
        map.put("AmazonQInQuickSight", AMAZON_Q_IN_QUICK_SIGHT_FIELD);
        map.put("Schedules", SCHEDULES_FIELD);
        map.put("RecentSnapshots", RECENT_SNAPSHOTS_FIELD);
        map.put("ThresholdAlerts", THRESHOLD_ALERTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisteredUserDashboardFeatureConfigurations, T> g) {
        return obj -> g.apply((RegisteredUserDashboardFeatureConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegisteredUserDashboardFeatureConfigurations> {
        /**
         * <p>
         * The state persistence settings of an embedded dashboard.
         * </p>
         * 
         * @param statePersistence
         *        The state persistence settings of an embedded dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statePersistence(StatePersistenceConfigurations statePersistence);

        /**
         * <p>
         * The state persistence settings of an embedded dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatePersistenceConfigurations.Builder}
         * avoiding the need to create one manually via {@link StatePersistenceConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatePersistenceConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #statePersistence(StatePersistenceConfigurations)}.
         * 
         * @param statePersistence
         *        a consumer that will call methods on {@link StatePersistenceConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statePersistence(StatePersistenceConfigurations)
         */
        default Builder statePersistence(Consumer<StatePersistenceConfigurations.Builder> statePersistence) {
            return statePersistence(StatePersistenceConfigurations.builder().applyMutation(statePersistence).build());
        }

        /**
         * <p>
         * The shared view settings of an embedded dashboard.
         * </p>
         * 
         * @param sharedView
         *        The shared view settings of an embedded dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedView(SharedViewConfigurations sharedView);

        /**
         * <p>
         * The shared view settings of an embedded dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link SharedViewConfigurations.Builder}
         * avoiding the need to create one manually via {@link SharedViewConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SharedViewConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #sharedView(SharedViewConfigurations)}.
         * 
         * @param sharedView
         *        a consumer that will call methods on {@link SharedViewConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharedView(SharedViewConfigurations)
         */
        default Builder sharedView(Consumer<SharedViewConfigurations.Builder> sharedView) {
            return sharedView(SharedViewConfigurations.builder().applyMutation(sharedView).build());
        }

        /**
         * <p>
         * The bookmarks configuration for an embedded dashboard in QuickSight.
         * </p>
         * 
         * @param bookmarks
         *        The bookmarks configuration for an embedded dashboard in QuickSight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bookmarks(BookmarksConfigurations bookmarks);

        /**
         * <p>
         * The bookmarks configuration for an embedded dashboard in QuickSight.
         * </p>
         * This is a convenience method that creates an instance of the {@link BookmarksConfigurations.Builder} avoiding
         * the need to create one manually via {@link BookmarksConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BookmarksConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #bookmarks(BookmarksConfigurations)}.
         * 
         * @param bookmarks
         *        a consumer that will call methods on {@link BookmarksConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bookmarks(BookmarksConfigurations)
         */
        default Builder bookmarks(Consumer<BookmarksConfigurations.Builder> bookmarks) {
            return bookmarks(BookmarksConfigurations.builder().applyMutation(bookmarks).build());
        }

        /**
         * <p>
         * The Amazon Q configurations of an embedded QuickSight dashboard.
         * </p>
         * 
         * @param amazonQInQuickSight
         *        The Amazon Q configurations of an embedded QuickSight dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonQInQuickSight(AmazonQInQuickSightDashboardConfigurations amazonQInQuickSight);

        /**
         * <p>
         * The Amazon Q configurations of an embedded QuickSight dashboard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AmazonQInQuickSightDashboardConfigurations.Builder} avoiding the need to create one manually via
         * {@link AmazonQInQuickSightDashboardConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonQInQuickSightDashboardConfigurations.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #amazonQInQuickSight(AmazonQInQuickSightDashboardConfigurations)}.
         * 
         * @param amazonQInQuickSight
         *        a consumer that will call methods on {@link AmazonQInQuickSightDashboardConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonQInQuickSight(AmazonQInQuickSightDashboardConfigurations)
         */
        default Builder amazonQInQuickSight(Consumer<AmazonQInQuickSightDashboardConfigurations.Builder> amazonQInQuickSight) {
            return amazonQInQuickSight(AmazonQInQuickSightDashboardConfigurations.builder().applyMutation(amazonQInQuickSight)
                    .build());
        }

        /**
         * <p>
         * The schedules configuration for an embedded QuickSight dashboard.
         * </p>
         * 
         * @param schedules
         *        The schedules configuration for an embedded QuickSight dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedules(SchedulesConfigurations schedules);

        /**
         * <p>
         * The schedules configuration for an embedded QuickSight dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchedulesConfigurations.Builder} avoiding
         * the need to create one manually via {@link SchedulesConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchedulesConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #schedules(SchedulesConfigurations)}.
         * 
         * @param schedules
         *        a consumer that will call methods on {@link SchedulesConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedules(SchedulesConfigurations)
         */
        default Builder schedules(Consumer<SchedulesConfigurations.Builder> schedules) {
            return schedules(SchedulesConfigurations.builder().applyMutation(schedules).build());
        }

        /**
         * <p>
         * The recent snapshots configuration for an QuickSight embedded dashboard
         * </p>
         * 
         * @param recentSnapshots
         *        The recent snapshots configuration for an QuickSight embedded dashboard
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recentSnapshots(RecentSnapshotsConfigurations recentSnapshots);

        /**
         * <p>
         * The recent snapshots configuration for an QuickSight embedded dashboard
         * </p>
         * This is a convenience method that creates an instance of the {@link RecentSnapshotsConfigurations.Builder}
         * avoiding the need to create one manually via {@link RecentSnapshotsConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecentSnapshotsConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #recentSnapshots(RecentSnapshotsConfigurations)}.
         * 
         * @param recentSnapshots
         *        a consumer that will call methods on {@link RecentSnapshotsConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recentSnapshots(RecentSnapshotsConfigurations)
         */
        default Builder recentSnapshots(Consumer<RecentSnapshotsConfigurations.Builder> recentSnapshots) {
            return recentSnapshots(RecentSnapshotsConfigurations.builder().applyMutation(recentSnapshots).build());
        }

        /**
         * <p>
         * The threshold alerts configuration for an QuickSight embedded dashboard.
         * </p>
         * 
         * @param thresholdAlerts
         *        The threshold alerts configuration for an QuickSight embedded dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdAlerts(ThresholdAlertsConfigurations thresholdAlerts);

        /**
         * <p>
         * The threshold alerts configuration for an QuickSight embedded dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThresholdAlertsConfigurations.Builder}
         * avoiding the need to create one manually via {@link ThresholdAlertsConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThresholdAlertsConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #thresholdAlerts(ThresholdAlertsConfigurations)}.
         * 
         * @param thresholdAlerts
         *        a consumer that will call methods on {@link ThresholdAlertsConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thresholdAlerts(ThresholdAlertsConfigurations)
         */
        default Builder thresholdAlerts(Consumer<ThresholdAlertsConfigurations.Builder> thresholdAlerts) {
            return thresholdAlerts(ThresholdAlertsConfigurations.builder().applyMutation(thresholdAlerts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StatePersistenceConfigurations statePersistence;

        private SharedViewConfigurations sharedView;

        private BookmarksConfigurations bookmarks;

        private AmazonQInQuickSightDashboardConfigurations amazonQInQuickSight;

        private SchedulesConfigurations schedules;

        private RecentSnapshotsConfigurations recentSnapshots;

        private ThresholdAlertsConfigurations thresholdAlerts;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisteredUserDashboardFeatureConfigurations model) {
            statePersistence(model.statePersistence);
            sharedView(model.sharedView);
            bookmarks(model.bookmarks);
            amazonQInQuickSight(model.amazonQInQuickSight);
            schedules(model.schedules);
            recentSnapshots(model.recentSnapshots);
            thresholdAlerts(model.thresholdAlerts);
        }

        public final StatePersistenceConfigurations.Builder getStatePersistence() {
            return statePersistence != null ? statePersistence.toBuilder() : null;
        }

        public final void setStatePersistence(StatePersistenceConfigurations.BuilderImpl statePersistence) {
            this.statePersistence = statePersistence != null ? statePersistence.build() : null;
        }

        @Override
        public final Builder statePersistence(StatePersistenceConfigurations statePersistence) {
            this.statePersistence = statePersistence;
            return this;
        }

        public final SharedViewConfigurations.Builder getSharedView() {
            return sharedView != null ? sharedView.toBuilder() : null;
        }

        public final void setSharedView(SharedViewConfigurations.BuilderImpl sharedView) {
            this.sharedView = sharedView != null ? sharedView.build() : null;
        }

        @Override
        public final Builder sharedView(SharedViewConfigurations sharedView) {
            this.sharedView = sharedView;
            return this;
        }

        public final BookmarksConfigurations.Builder getBookmarks() {
            return bookmarks != null ? bookmarks.toBuilder() : null;
        }

        public final void setBookmarks(BookmarksConfigurations.BuilderImpl bookmarks) {
            this.bookmarks = bookmarks != null ? bookmarks.build() : null;
        }

        @Override
        public final Builder bookmarks(BookmarksConfigurations bookmarks) {
            this.bookmarks = bookmarks;
            return this;
        }

        public final AmazonQInQuickSightDashboardConfigurations.Builder getAmazonQInQuickSight() {
            return amazonQInQuickSight != null ? amazonQInQuickSight.toBuilder() : null;
        }

        public final void setAmazonQInQuickSight(AmazonQInQuickSightDashboardConfigurations.BuilderImpl amazonQInQuickSight) {
            this.amazonQInQuickSight = amazonQInQuickSight != null ? amazonQInQuickSight.build() : null;
        }

        @Override
        public final Builder amazonQInQuickSight(AmazonQInQuickSightDashboardConfigurations amazonQInQuickSight) {
            this.amazonQInQuickSight = amazonQInQuickSight;
            return this;
        }

        public final SchedulesConfigurations.Builder getSchedules() {
            return schedules != null ? schedules.toBuilder() : null;
        }

        public final void setSchedules(SchedulesConfigurations.BuilderImpl schedules) {
            this.schedules = schedules != null ? schedules.build() : null;
        }

        @Override
        public final Builder schedules(SchedulesConfigurations schedules) {
            this.schedules = schedules;
            return this;
        }

        public final RecentSnapshotsConfigurations.Builder getRecentSnapshots() {
            return recentSnapshots != null ? recentSnapshots.toBuilder() : null;
        }

        public final void setRecentSnapshots(RecentSnapshotsConfigurations.BuilderImpl recentSnapshots) {
            this.recentSnapshots = recentSnapshots != null ? recentSnapshots.build() : null;
        }

        @Override
        public final Builder recentSnapshots(RecentSnapshotsConfigurations recentSnapshots) {
            this.recentSnapshots = recentSnapshots;
            return this;
        }

        public final ThresholdAlertsConfigurations.Builder getThresholdAlerts() {
            return thresholdAlerts != null ? thresholdAlerts.toBuilder() : null;
        }

        public final void setThresholdAlerts(ThresholdAlertsConfigurations.BuilderImpl thresholdAlerts) {
            this.thresholdAlerts = thresholdAlerts != null ? thresholdAlerts.build() : null;
        }

        @Override
        public final Builder thresholdAlerts(ThresholdAlertsConfigurations thresholdAlerts) {
            this.thresholdAlerts = thresholdAlerts;
            return this;
        }

        @Override
        public RegisteredUserDashboardFeatureConfigurations build() {
            return new RegisteredUserDashboardFeatureConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
