/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about the <code>QDataKey</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QDataKey implements SdkPojo, Serializable, ToCopyableBuilder<QDataKey.Builder, QDataKey> {
    private static final SdkField<String> Q_DATA_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QDataKeyArn").getter(getter(QDataKey::qDataKeyArn)).setter(setter(Builder::qDataKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QDataKeyArn").build()).build();

    private static final SdkField<String> Q_DATA_KEY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QDataKeyType").getter(getter(QDataKey::qDataKeyTypeAsString)).setter(setter(Builder::qDataKeyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QDataKeyType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(Q_DATA_KEY_ARN_FIELD,
            Q_DATA_KEY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String qDataKeyArn;

    private final String qDataKeyType;

    private QDataKey(BuilderImpl builder) {
        this.qDataKeyArn = builder.qDataKeyArn;
        this.qDataKeyType = builder.qDataKeyType;
    }

    /**
     * <p>
     * The ARN of the KMS key that is registered to a QuickSight account for encryption and decryption use as a
     * <code>QDataKey</code>.
     * </p>
     * 
     * @return The ARN of the KMS key that is registered to a QuickSight account for encryption and decryption use as a
     *         <code>QDataKey</code>.
     */
    public final String qDataKeyArn() {
        return qDataKeyArn;
    }

    /**
     * <p>
     * The type of <code>QDataKey</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qDataKeyType} will
     * return {@link QDataKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qDataKeyTypeAsString}.
     * </p>
     * 
     * @return The type of <code>QDataKey</code>.
     * @see QDataKeyType
     */
    public final QDataKeyType qDataKeyType() {
        return QDataKeyType.fromValue(qDataKeyType);
    }

    /**
     * <p>
     * The type of <code>QDataKey</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qDataKeyType} will
     * return {@link QDataKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qDataKeyTypeAsString}.
     * </p>
     * 
     * @return The type of <code>QDataKey</code>.
     * @see QDataKeyType
     */
    public final String qDataKeyTypeAsString() {
        return qDataKeyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(qDataKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(qDataKeyTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QDataKey)) {
            return false;
        }
        QDataKey other = (QDataKey) obj;
        return Objects.equals(qDataKeyArn(), other.qDataKeyArn())
                && Objects.equals(qDataKeyTypeAsString(), other.qDataKeyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QDataKey").add("QDataKeyArn", qDataKeyArn()).add("QDataKeyType", qDataKeyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QDataKeyArn":
            return Optional.ofNullable(clazz.cast(qDataKeyArn()));
        case "QDataKeyType":
            return Optional.ofNullable(clazz.cast(qDataKeyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QDataKeyArn", Q_DATA_KEY_ARN_FIELD);
        map.put("QDataKeyType", Q_DATA_KEY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QDataKey, T> g) {
        return obj -> g.apply((QDataKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QDataKey> {
        /**
         * <p>
         * The ARN of the KMS key that is registered to a QuickSight account for encryption and decryption use as a
         * <code>QDataKey</code>.
         * </p>
         * 
         * @param qDataKeyArn
         *        The ARN of the KMS key that is registered to a QuickSight account for encryption and decryption use as
         *        a <code>QDataKey</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qDataKeyArn(String qDataKeyArn);

        /**
         * <p>
         * The type of <code>QDataKey</code>.
         * </p>
         * 
         * @param qDataKeyType
         *        The type of <code>QDataKey</code>.
         * @see QDataKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QDataKeyType
         */
        Builder qDataKeyType(String qDataKeyType);

        /**
         * <p>
         * The type of <code>QDataKey</code>.
         * </p>
         * 
         * @param qDataKeyType
         *        The type of <code>QDataKey</code>.
         * @see QDataKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QDataKeyType
         */
        Builder qDataKeyType(QDataKeyType qDataKeyType);
    }

    static final class BuilderImpl implements Builder {
        private String qDataKeyArn;

        private String qDataKeyType;

        private BuilderImpl() {
        }

        private BuilderImpl(QDataKey model) {
            qDataKeyArn(model.qDataKeyArn);
            qDataKeyType(model.qDataKeyType);
        }

        public final String getQDataKeyArn() {
            return qDataKeyArn;
        }

        public final void setQDataKeyArn(String qDataKeyArn) {
            this.qDataKeyArn = qDataKeyArn;
        }

        @Override
        public final Builder qDataKeyArn(String qDataKeyArn) {
            this.qDataKeyArn = qDataKeyArn;
            return this;
        }

        public final String getQDataKeyType() {
            return qDataKeyType;
        }

        public final void setQDataKeyType(String qDataKeyType) {
            this.qDataKeyType = qDataKeyType;
        }

        @Override
        public final Builder qDataKeyType(String qDataKeyType) {
            this.qDataKeyType = qDataKeyType;
            return this;
        }

        @Override
        public final Builder qDataKeyType(QDataKeyType qDataKeyType) {
            this.qDataKeyType(qDataKeyType == null ? null : qDataKeyType.toString());
            return this;
        }

        @Override
        public QDataKey build() {
            return new QDataKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
