/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictQaResultsResponse extends QuickSightResponse implements
        ToCopyableBuilder<PredictQaResultsResponse.Builder, PredictQaResultsResponse> {
    private static final SdkField<QAResult> PRIMARY_RESULT_FIELD = SdkField.<QAResult> builder(MarshallingType.SDK_POJO)
            .memberName("PrimaryResult").getter(getter(PredictQaResultsResponse::primaryResult))
            .setter(setter(Builder::primaryResult)).constructor(QAResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryResult").build()).build();

    private static final SdkField<List<QAResult>> ADDITIONAL_RESULTS_FIELD = SdkField
            .<List<QAResult>> builder(MarshallingType.LIST)
            .memberName("AdditionalResults")
            .getter(getter(PredictQaResultsResponse::additionalResults))
            .setter(setter(Builder::additionalResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QAResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(QAResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(PredictQaResultsResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(PredictQaResultsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_RESULT_FIELD,
            ADDITIONAL_RESULTS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final QAResult primaryResult;

    private final List<QAResult> additionalResults;

    private final String requestId;

    private final Integer status;

    private PredictQaResultsResponse(BuilderImpl builder) {
        super(builder);
        this.primaryResult = builder.primaryResult;
        this.additionalResults = builder.additionalResults;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The primary visual response.
     * </p>
     * 
     * @return The primary visual response.
     */
    public final QAResult primaryResult() {
        return primaryResult;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalResults property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalResults() {
        return additionalResults != null && !(additionalResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional visual responses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalResults} method.
     * </p>
     * 
     * @return Additional visual responses.
     */
    public final List<QAResult> additionalResults() {
        return additionalResults;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(primaryResult());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalResults() ? additionalResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictQaResultsResponse)) {
            return false;
        }
        PredictQaResultsResponse other = (PredictQaResultsResponse) obj;
        return Objects.equals(primaryResult(), other.primaryResult()) && hasAdditionalResults() == other.hasAdditionalResults()
                && Objects.equals(additionalResults(), other.additionalResults())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictQaResultsResponse").add("PrimaryResult", primaryResult())
                .add("AdditionalResults", hasAdditionalResults() ? additionalResults() : null).add("RequestId", requestId())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryResult":
            return Optional.ofNullable(clazz.cast(primaryResult()));
        case "AdditionalResults":
            return Optional.ofNullable(clazz.cast(additionalResults()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrimaryResult", PRIMARY_RESULT_FIELD);
        map.put("AdditionalResults", ADDITIONAL_RESULTS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictQaResultsResponse, T> g) {
        return obj -> g.apply((PredictQaResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, PredictQaResultsResponse> {
        /**
         * <p>
         * The primary visual response.
         * </p>
         * 
         * @param primaryResult
         *        The primary visual response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryResult(QAResult primaryResult);

        /**
         * <p>
         * The primary visual response.
         * </p>
         * This is a convenience method that creates an instance of the {@link QAResult.Builder} avoiding the need to
         * create one manually via {@link QAResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QAResult.Builder#build()} is called immediately and its result is
         * passed to {@link #primaryResult(QAResult)}.
         * 
         * @param primaryResult
         *        a consumer that will call methods on {@link QAResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryResult(QAResult)
         */
        default Builder primaryResult(Consumer<QAResult.Builder> primaryResult) {
            return primaryResult(QAResult.builder().applyMutation(primaryResult).build());
        }

        /**
         * <p>
         * Additional visual responses.
         * </p>
         * 
         * @param additionalResults
         *        Additional visual responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalResults(Collection<QAResult> additionalResults);

        /**
         * <p>
         * Additional visual responses.
         * </p>
         * 
         * @param additionalResults
         *        Additional visual responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalResults(QAResult... additionalResults);

        /**
         * <p>
         * Additional visual responses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.QAResult.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.QAResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.QAResult.Builder#build()} is called immediately and
         * its result is passed to {@link #additionalResults(List<QAResult>)}.
         * 
         * @param additionalResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.QAResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalResults(java.util.Collection<QAResult>)
         */
        Builder additionalResults(Consumer<QAResult.Builder>... additionalResults);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private QAResult primaryResult;

        private List<QAResult> additionalResults = DefaultSdkAutoConstructList.getInstance();

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictQaResultsResponse model) {
            super(model);
            primaryResult(model.primaryResult);
            additionalResults(model.additionalResults);
            requestId(model.requestId);
            status(model.status);
        }

        public final QAResult.Builder getPrimaryResult() {
            return primaryResult != null ? primaryResult.toBuilder() : null;
        }

        public final void setPrimaryResult(QAResult.BuilderImpl primaryResult) {
            this.primaryResult = primaryResult != null ? primaryResult.build() : null;
        }

        @Override
        public final Builder primaryResult(QAResult primaryResult) {
            this.primaryResult = primaryResult;
            return this;
        }

        public final List<QAResult.Builder> getAdditionalResults() {
            List<QAResult.Builder> result = QAResultsCopier.copyToBuilder(this.additionalResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalResults(Collection<QAResult.BuilderImpl> additionalResults) {
            this.additionalResults = QAResultsCopier.copyFromBuilder(additionalResults);
        }

        @Override
        public final Builder additionalResults(Collection<QAResult> additionalResults) {
            this.additionalResults = QAResultsCopier.copy(additionalResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalResults(QAResult... additionalResults) {
            additionalResults(Arrays.asList(additionalResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalResults(Consumer<QAResult.Builder>... additionalResults) {
            additionalResults(Stream.of(additionalResults).map(c -> QAResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public PredictQaResultsResponse build() {
            return new PredictQaResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
