/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The selected field options for the pivot table field options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotTableFieldOption implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotTableFieldOption.Builder, PivotTableFieldOption> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldId").getter(getter(PivotTableFieldOption::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final SdkField<String> CUSTOM_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomLabel").getter(getter(PivotTableFieldOption::customLabel)).setter(setter(Builder::customLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabel").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(PivotTableFieldOption::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD,
            CUSTOM_LABEL_FIELD, VISIBILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldId;

    private final String customLabel;

    private final String visibility;

    private PivotTableFieldOption(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.customLabel = builder.customLabel;
        this.visibility = builder.visibility;
    }

    /**
     * <p>
     * The field ID of the pivot table field.
     * </p>
     * 
     * @return The field ID of the pivot table field.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * <p>
     * The custom label of the pivot table field.
     * </p>
     * 
     * @return The custom label of the pivot table field.
     */
    public final String customLabel() {
        return customLabel;
    }

    /**
     * <p>
     * The visibility of the pivot table field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the pivot table field.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of the pivot table field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the pivot table field.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(customLabel());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableFieldOption)) {
            return false;
        }
        PivotTableFieldOption other = (PivotTableFieldOption) obj;
        return Objects.equals(fieldId(), other.fieldId()) && Objects.equals(customLabel(), other.customLabel())
                && Objects.equals(visibilityAsString(), other.visibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotTableFieldOption").add("FieldId", fieldId()).add("CustomLabel", customLabel())
                .add("Visibility", visibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "CustomLabel":
            return Optional.ofNullable(clazz.cast(customLabel()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldId", FIELD_ID_FIELD);
        map.put("CustomLabel", CUSTOM_LABEL_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotTableFieldOption, T> g) {
        return obj -> g.apply((PivotTableFieldOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotTableFieldOption> {
        /**
         * <p>
         * The field ID of the pivot table field.
         * </p>
         * 
         * @param fieldId
         *        The field ID of the pivot table field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * The custom label of the pivot table field.
         * </p>
         * 
         * @param customLabel
         *        The custom label of the pivot table field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLabel(String customLabel);

        /**
         * <p>
         * The visibility of the pivot table field.
         * </p>
         * 
         * @param visibility
         *        The visibility of the pivot table field.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of the pivot table field.
         * </p>
         * 
         * @param visibility
         *        The visibility of the pivot table field.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);
    }

    static final class BuilderImpl implements Builder {
        private String fieldId;

        private String customLabel;

        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableFieldOption model) {
            fieldId(model.fieldId);
            customLabel(model.customLabel);
            visibility(model.visibility);
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getCustomLabel() {
            return customLabel;
        }

        public final void setCustomLabel(String customLabel) {
            this.customLabel = customLabel;
        }

        @Override
        public final Builder customLabel(String customLabel) {
            this.customLabel = customLabel;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        @Override
        public PivotTableFieldOption build() {
            return new PivotTableFieldOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
