/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The pagination configuration for a table visual or boxplot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PaginationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PaginationConfiguration.Builder, PaginationConfiguration> {
    private static final SdkField<Long> PAGE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("PageSize")
            .getter(getter(PaginationConfiguration::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<Long> PAGE_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PageNumber").getter(getter(PaginationConfiguration::pageNumber)).setter(setter(Builder::pageNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_SIZE_FIELD,
            PAGE_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long pageSize;

    private final Long pageNumber;

    private PaginationConfiguration(BuilderImpl builder) {
        this.pageSize = builder.pageSize;
        this.pageNumber = builder.pageNumber;
    }

    /**
     * <p>
     * Indicates how many items render in one page.
     * </p>
     * 
     * @return Indicates how many items render in one page.
     */
    public final Long pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * Indicates the page number.
     * </p>
     * 
     * @return Indicates the page number.
     */
    public final Long pageNumber() {
        return pageNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(pageNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaginationConfiguration)) {
            return false;
        }
        PaginationConfiguration other = (PaginationConfiguration) obj;
        return Objects.equals(pageSize(), other.pageSize()) && Objects.equals(pageNumber(), other.pageNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PaginationConfiguration").add("PageSize", pageSize()).add("PageNumber", pageNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "PageNumber":
            return Optional.ofNullable(clazz.cast(pageNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PageSize", PAGE_SIZE_FIELD);
        map.put("PageNumber", PAGE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PaginationConfiguration, T> g) {
        return obj -> g.apply((PaginationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PaginationConfiguration> {
        /**
         * <p>
         * Indicates how many items render in one page.
         * </p>
         * 
         * @param pageSize
         *        Indicates how many items render in one page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Long pageSize);

        /**
         * <p>
         * Indicates the page number.
         * </p>
         * 
         * @param pageNumber
         *        Indicates the page number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageNumber(Long pageNumber);
    }

    static final class BuilderImpl implements Builder {
        private Long pageSize;

        private Long pageNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(PaginationConfiguration model) {
            pageSize(model.pageSize);
            pageNumber(model.pageNumber);
        }

        public final Long getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Long pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final Long getPageNumber() {
            return pageNumber;
        }

        public final void setPageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
        }

        @Override
        public final Builder pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        @Override
        public PaginationConfiguration build() {
            return new PaginationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
