/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for the legend setup of a visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LegendOptions implements SdkPojo, Serializable, ToCopyableBuilder<LegendOptions.Builder, LegendOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(LegendOptions::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<LabelOptions> TITLE_FIELD = SdkField.<LabelOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Title").getter(getter(LegendOptions::title)).setter(setter(Builder::title))
            .constructor(LabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Position").getter(getter(LegendOptions::positionAsString)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build()).build();

    private static final SdkField<String> WIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Width")
            .getter(getter(LegendOptions::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()).build();

    private static final SdkField<String> HEIGHT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Height")
            .getter(getter(LegendOptions::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()).build();

    private static final SdkField<FontConfiguration> VALUE_FONT_CONFIGURATION_FIELD = SdkField
            .<FontConfiguration> builder(MarshallingType.SDK_POJO).memberName("ValueFontConfiguration")
            .getter(getter(LegendOptions::valueFontConfiguration)).setter(setter(Builder::valueFontConfiguration))
            .constructor(FontConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueFontConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD, TITLE_FIELD,
            POSITION_FIELD, WIDTH_FIELD, HEIGHT_FIELD, VALUE_FONT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String visibility;

    private final LabelOptions title;

    private final String position;

    private final String width;

    private final String height;

    private final FontConfiguration valueFontConfiguration;

    private LegendOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.title = builder.title;
        this.position = builder.position;
        this.width = builder.width;
        this.height = builder.height;
        this.valueFontConfiguration = builder.valueFontConfiguration;
    }

    /**
     * <p>
     * Determines whether or not the legend is visible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not the legend is visible.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * Determines whether or not the legend is visible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not the legend is visible.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The custom title for the legend.
     * </p>
     * 
     * @return The custom title for the legend.
     */
    public final LabelOptions title() {
        return title;
    }

    /**
     * <p>
     * The positions for the legend. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AUTO</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RIGHT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BOTTOM</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LEFT</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #position} will
     * return {@link LegendPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #positionAsString}.
     * </p>
     * 
     * @return The positions for the legend. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AUTO</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RIGHT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BOTTOM</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LEFT</code>
     *         </p>
     *         </li>
     * @see LegendPosition
     */
    public final LegendPosition position() {
        return LegendPosition.fromValue(position);
    }

    /**
     * <p>
     * The positions for the legend. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AUTO</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RIGHT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BOTTOM</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LEFT</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #position} will
     * return {@link LegendPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #positionAsString}.
     * </p>
     * 
     * @return The positions for the legend. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AUTO</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RIGHT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BOTTOM</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LEFT</code>
     *         </p>
     *         </li>
     * @see LegendPosition
     */
    public final String positionAsString() {
        return position;
    }

    /**
     * <p>
     * The width of the legend. If this value is omitted, a default width is used when rendering.
     * </p>
     * 
     * @return The width of the legend. If this value is omitted, a default width is used when rendering.
     */
    public final String width() {
        return width;
    }

    /**
     * <p>
     * The height of the legend. If this value is omitted, a default height is used when rendering.
     * </p>
     * 
     * @return The height of the legend. If this value is omitted, a default height is used when rendering.
     */
    public final String height() {
        return height;
    }

    /**
     * Returns the value of the ValueFontConfiguration property for this object.
     * 
     * @return The value of the ValueFontConfiguration property for this object.
     */
    public final FontConfiguration valueFontConfiguration() {
        return valueFontConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(positionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(valueFontConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LegendOptions)) {
            return false;
        }
        LegendOptions other = (LegendOptions) obj;
        return Objects.equals(visibilityAsString(), other.visibilityAsString()) && Objects.equals(title(), other.title())
                && Objects.equals(positionAsString(), other.positionAsString()) && Objects.equals(width(), other.width())
                && Objects.equals(height(), other.height())
                && Objects.equals(valueFontConfiguration(), other.valueFontConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LegendOptions").add("Visibility", visibilityAsString()).add("Title", title())
                .add("Position", positionAsString()).add("Width", width()).add("Height", height())
                .add("ValueFontConfiguration", valueFontConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Position":
            return Optional.ofNullable(clazz.cast(positionAsString()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "ValueFontConfiguration":
            return Optional.ofNullable(clazz.cast(valueFontConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("Width", WIDTH_FIELD);
        map.put("Height", HEIGHT_FIELD);
        map.put("ValueFontConfiguration", VALUE_FONT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LegendOptions, T> g) {
        return obj -> g.apply((LegendOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LegendOptions> {
        /**
         * <p>
         * Determines whether or not the legend is visible.
         * </p>
         * 
         * @param visibility
         *        Determines whether or not the legend is visible.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * Determines whether or not the legend is visible.
         * </p>
         * 
         * @param visibility
         *        Determines whether or not the legend is visible.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The custom title for the legend.
         * </p>
         * 
         * @param title
         *        The custom title for the legend.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(LabelOptions title);

        /**
         * <p>
         * The custom title for the legend.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelOptions.Builder} avoiding the need
         * to create one manually via {@link LabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #title(LabelOptions)}.
         * 
         * @param title
         *        a consumer that will call methods on {@link LabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #title(LabelOptions)
         */
        default Builder title(Consumer<LabelOptions.Builder> title) {
            return title(LabelOptions.builder().applyMutation(title).build());
        }

        /**
         * <p>
         * The positions for the legend. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AUTO</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RIGHT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOTTOM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LEFT</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param position
         *        The positions for the legend. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AUTO</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RIGHT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOTTOM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LEFT</code>
         *        </p>
         *        </li>
         * @see LegendPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LegendPosition
         */
        Builder position(String position);

        /**
         * <p>
         * The positions for the legend. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AUTO</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RIGHT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOTTOM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LEFT</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param position
         *        The positions for the legend. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AUTO</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RIGHT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOTTOM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LEFT</code>
         *        </p>
         *        </li>
         * @see LegendPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LegendPosition
         */
        Builder position(LegendPosition position);

        /**
         * <p>
         * The width of the legend. If this value is omitted, a default width is used when rendering.
         * </p>
         * 
         * @param width
         *        The width of the legend. If this value is omitted, a default width is used when rendering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(String width);

        /**
         * <p>
         * The height of the legend. If this value is omitted, a default height is used when rendering.
         * </p>
         * 
         * @param height
         *        The height of the legend. If this value is omitted, a default height is used when rendering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(String height);

        /**
         * Sets the value of the ValueFontConfiguration property for this object.
         *
         * @param valueFontConfiguration
         *        The new value for the ValueFontConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueFontConfiguration(FontConfiguration valueFontConfiguration);

        /**
         * Sets the value of the ValueFontConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FontConfiguration.Builder} avoiding the
         * need to create one manually via {@link FontConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FontConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #valueFontConfiguration(FontConfiguration)}.
         * 
         * @param valueFontConfiguration
         *        a consumer that will call methods on {@link FontConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueFontConfiguration(FontConfiguration)
         */
        default Builder valueFontConfiguration(Consumer<FontConfiguration.Builder> valueFontConfiguration) {
            return valueFontConfiguration(FontConfiguration.builder().applyMutation(valueFontConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String visibility;

        private LabelOptions title;

        private String position;

        private String width;

        private String height;

        private FontConfiguration valueFontConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LegendOptions model) {
            visibility(model.visibility);
            title(model.title);
            position(model.position);
            width(model.width);
            height(model.height);
            valueFontConfiguration(model.valueFontConfiguration);
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final LabelOptions.Builder getTitle() {
            return title != null ? title.toBuilder() : null;
        }

        public final void setTitle(LabelOptions.BuilderImpl title) {
            this.title = title != null ? title.build() : null;
        }

        @Override
        public final Builder title(LabelOptions title) {
            this.title = title;
            return this;
        }

        public final String getPosition() {
            return position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        @Override
        public final Builder position(LegendPosition position) {
            this.position(position == null ? null : position.toString());
            return this;
        }

        public final String getWidth() {
            return width;
        }

        public final void setWidth(String width) {
            this.width = width;
        }

        @Override
        public final Builder width(String width) {
            this.width = width;
            return this;
        }

        public final String getHeight() {
            return height;
        }

        public final void setHeight(String height) {
            this.height = height;
        }

        @Override
        public final Builder height(String height) {
            this.height = height;
            return this;
        }

        public final FontConfiguration.Builder getValueFontConfiguration() {
            return valueFontConfiguration != null ? valueFontConfiguration.toBuilder() : null;
        }

        public final void setValueFontConfiguration(FontConfiguration.BuilderImpl valueFontConfiguration) {
            this.valueFontConfiguration = valueFontConfiguration != null ? valueFontConfiguration.build() : null;
        }

        @Override
        public final Builder valueFontConfiguration(FontConfiguration valueFontConfiguration) {
            this.valueFontConfiguration = valueFontConfiguration;
            return this;
        }

        @Override
        public LegendOptions build() {
            return new LegendOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
