/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The limit configuration of the visual display for an axis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ItemsLimitConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ItemsLimitConfiguration.Builder, ItemsLimitConfiguration> {
    private static final SdkField<Long> ITEMS_LIMIT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ItemsLimit").getter(getter(ItemsLimitConfiguration::itemsLimit)).setter(setter(Builder::itemsLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemsLimit").build()).build();

    private static final SdkField<String> OTHER_CATEGORIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OtherCategories").getter(getter(ItemsLimitConfiguration::otherCategoriesAsString))
            .setter(setter(Builder::otherCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherCategories").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_LIMIT_FIELD,
            OTHER_CATEGORIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long itemsLimit;

    private final String otherCategories;

    private ItemsLimitConfiguration(BuilderImpl builder) {
        this.itemsLimit = builder.itemsLimit;
        this.otherCategories = builder.otherCategories;
    }

    /**
     * <p>
     * The limit on how many items of a field are showed in the chart. For example, the number of slices that are
     * displayed in a pie chart.
     * </p>
     * 
     * @return The limit on how many items of a field are showed in the chart. For example, the number of slices that
     *         are displayed in a pie chart.
     */
    public final Long itemsLimit() {
        return itemsLimit;
    }

    /**
     * <p>
     * The <code>Show other</code> of an axis in the chart. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INCLUDE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXCLUDE</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otherCategories}
     * will return {@link OtherCategories#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #otherCategoriesAsString}.
     * </p>
     * 
     * @return The <code>Show other</code> of an axis in the chart. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INCLUDE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXCLUDE</code>
     *         </p>
     *         </li>
     * @see OtherCategories
     */
    public final OtherCategories otherCategories() {
        return OtherCategories.fromValue(otherCategories);
    }

    /**
     * <p>
     * The <code>Show other</code> of an axis in the chart. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INCLUDE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXCLUDE</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otherCategories}
     * will return {@link OtherCategories#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #otherCategoriesAsString}.
     * </p>
     * 
     * @return The <code>Show other</code> of an axis in the chart. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INCLUDE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXCLUDE</code>
     *         </p>
     *         </li>
     * @see OtherCategories
     */
    public final String otherCategoriesAsString() {
        return otherCategories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(itemsLimit());
        hashCode = 31 * hashCode + Objects.hashCode(otherCategoriesAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemsLimitConfiguration)) {
            return false;
        }
        ItemsLimitConfiguration other = (ItemsLimitConfiguration) obj;
        return Objects.equals(itemsLimit(), other.itemsLimit())
                && Objects.equals(otherCategoriesAsString(), other.otherCategoriesAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ItemsLimitConfiguration").add("ItemsLimit", itemsLimit())
                .add("OtherCategories", otherCategoriesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ItemsLimit":
            return Optional.ofNullable(clazz.cast(itemsLimit()));
        case "OtherCategories":
            return Optional.ofNullable(clazz.cast(otherCategoriesAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ItemsLimit", ITEMS_LIMIT_FIELD);
        map.put("OtherCategories", OTHER_CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ItemsLimitConfiguration, T> g) {
        return obj -> g.apply((ItemsLimitConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ItemsLimitConfiguration> {
        /**
         * <p>
         * The limit on how many items of a field are showed in the chart. For example, the number of slices that are
         * displayed in a pie chart.
         * </p>
         * 
         * @param itemsLimit
         *        The limit on how many items of a field are showed in the chart. For example, the number of slices that
         *        are displayed in a pie chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemsLimit(Long itemsLimit);

        /**
         * <p>
         * The <code>Show other</code> of an axis in the chart. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INCLUDE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXCLUDE</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param otherCategories
         *        The <code>Show other</code> of an axis in the chart. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXCLUDE</code>
         *        </p>
         *        </li>
         * @see OtherCategories
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtherCategories
         */
        Builder otherCategories(String otherCategories);

        /**
         * <p>
         * The <code>Show other</code> of an axis in the chart. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INCLUDE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXCLUDE</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param otherCategories
         *        The <code>Show other</code> of an axis in the chart. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXCLUDE</code>
         *        </p>
         *        </li>
         * @see OtherCategories
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtherCategories
         */
        Builder otherCategories(OtherCategories otherCategories);
    }

    static final class BuilderImpl implements Builder {
        private Long itemsLimit;

        private String otherCategories;

        private BuilderImpl() {
        }

        private BuilderImpl(ItemsLimitConfiguration model) {
            itemsLimit(model.itemsLimit);
            otherCategories(model.otherCategories);
        }

        public final Long getItemsLimit() {
            return itemsLimit;
        }

        public final void setItemsLimit(Long itemsLimit) {
            this.itemsLimit = itemsLimit;
        }

        @Override
        public final Builder itemsLimit(Long itemsLimit) {
            this.itemsLimit = itemsLimit;
            return this;
        }

        public final String getOtherCategories() {
            return otherCategories;
        }

        public final void setOtherCategories(String otherCategories) {
            this.otherCategories = otherCategories;
        }

        @Override
        public final Builder otherCategories(String otherCategories) {
            this.otherCategories = otherCategories;
            return this;
        }

        @Override
        public final Builder otherCategories(OtherCategories otherCategories) {
            this.otherCategories(otherCategories == null ? null : otherCategories.toString());
            return this;
        }

        @Override
        public ItemsLimitConfiguration build() {
            return new ItemsLimitConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
