/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDashboardEmbedUrlRequest extends QuickSightRequest implements
        ToCopyableBuilder<GetDashboardEmbedUrlRequest.Builder, GetDashboardEmbedUrlRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(GetDashboardEmbedUrlRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(GetDashboardEmbedUrlRequest::dashboardId))
            .setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DashboardId").build()).build();

    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityType").getter(getter(GetDashboardEmbedUrlRequest::identityTypeAsString))
            .setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("creds-type").build()).build();

    private static final SdkField<Long> SESSION_LIFETIME_IN_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SessionLifetimeInMinutes").getter(getter(GetDashboardEmbedUrlRequest::sessionLifetimeInMinutes))
            .setter(setter(Builder::sessionLifetimeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("session-lifetime").build())
            .build();

    private static final SdkField<Boolean> UNDO_REDO_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UndoRedoDisabled").getter(getter(GetDashboardEmbedUrlRequest::undoRedoDisabled))
            .setter(setter(Builder::undoRedoDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("undo-redo-disabled").build())
            .build();

    private static final SdkField<Boolean> RESET_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ResetDisabled").getter(getter(GetDashboardEmbedUrlRequest::resetDisabled))
            .setter(setter(Builder::resetDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reset-disabled").build())
            .build();

    private static final SdkField<Boolean> STATE_PERSISTENCE_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StatePersistenceEnabled")
            .getter(getter(GetDashboardEmbedUrlRequest::statePersistenceEnabled))
            .setter(setter(Builder::statePersistenceEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state-persistence-enabled")
                    .build()).build();

    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserArn").getter(getter(GetDashboardEmbedUrlRequest::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("user-arn").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(GetDashboardEmbedUrlRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_DASHBOARD_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalDashboardIds")
            .getter(getter(GetDashboardEmbedUrlRequest::additionalDashboardIds))
            .setter(setter(Builder::additionalDashboardIds))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("additional-dashboard-ids")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DASHBOARD_ID_FIELD, IDENTITY_TYPE_FIELD, SESSION_LIFETIME_IN_MINUTES_FIELD, UNDO_REDO_DISABLED_FIELD,
            RESET_DISABLED_FIELD, STATE_PERSISTENCE_ENABLED_FIELD, USER_ARN_FIELD, NAMESPACE_FIELD,
            ADDITIONAL_DASHBOARD_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String dashboardId;

    private final String identityType;

    private final Long sessionLifetimeInMinutes;

    private final Boolean undoRedoDisabled;

    private final Boolean resetDisabled;

    private final Boolean statePersistenceEnabled;

    private final String userArn;

    private final String namespace;

    private final List<String> additionalDashboardIds;

    private GetDashboardEmbedUrlRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.identityType = builder.identityType;
        this.sessionLifetimeInMinutes = builder.sessionLifetimeInMinutes;
        this.undoRedoDisabled = builder.undoRedoDisabled;
        this.resetDisabled = builder.resetDisabled;
        this.statePersistenceEnabled = builder.statePersistenceEnabled;
        this.userArn = builder.userArn;
        this.namespace = builder.namespace;
        this.additionalDashboardIds = builder.additionalDashboardIds;
    }

    /**
     * <p>
     * The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
     * </p>
     * 
     * @return The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID for the dashboard, also added to the Identity and Access Management (IAM) policy.
     * </p>
     * 
     * @return The ID for the dashboard, also added to the Identity and Access Management (IAM) policy.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * The authentication method that the user uses to sign in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link EmbeddingIdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The authentication method that the user uses to sign in.
     * @see EmbeddingIdentityType
     */
    public final EmbeddingIdentityType identityType() {
        return EmbeddingIdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * The authentication method that the user uses to sign in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link EmbeddingIdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The authentication method that the user uses to sign in.
     * @see EmbeddingIdentityType
     */
    public final String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * How many minutes the session is valid. The session lifetime must be 15-600 minutes.
     * </p>
     * 
     * @return How many minutes the session is valid. The session lifetime must be 15-600 minutes.
     */
    public final Long sessionLifetimeInMinutes() {
        return sessionLifetimeInMinutes;
    }

    /**
     * <p>
     * Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo button.
     * </p>
     * 
     * @return Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo
     *         button.
     */
    public final Boolean undoRedoDisabled() {
        return undoRedoDisabled;
    }

    /**
     * <p>
     * Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.
     * </p>
     * 
     * @return Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.
     */
    public final Boolean resetDisabled() {
        return resetDisabled;
    }

    /**
     * <p>
     * Adds persistence of state for the user session in an embedded dashboard. Persistence applies to the sheet and the
     * parameter settings. These are control settings that the dashboard subscriber (QuickSight reader) chooses while
     * viewing the dashboard. If this is set to <code>TRUE</code>, the settings are the same when the subscriber reopens
     * the same dashboard URL. The state is stored in QuickSight, not in a browser cookie. If this is set to FALSE, the
     * state of the user session is not persisted. The default is <code>FALSE</code>.
     * </p>
     * 
     * @return Adds persistence of state for the user session in an embedded dashboard. Persistence applies to the sheet
     *         and the parameter settings. These are control settings that the dashboard subscriber (QuickSight reader)
     *         chooses while viewing the dashboard. If this is set to <code>TRUE</code>, the settings are the same when
     *         the subscriber reopens the same dashboard URL. The state is stored in QuickSight, not in a browser
     *         cookie. If this is set to FALSE, the state of the user session is not persisted. The default is
     *         <code>FALSE</code>.
     */
    public final Boolean statePersistenceEnabled() {
        return statePersistenceEnabled;
    }

    /**
     * <p>
     * The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You
     * can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated as one
     * of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Active Directory (AD) users or group members
     * </p>
     * </li>
     * <li>
     * <p>
     * Invited nonfederated users
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect,
     * or IAM federation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Omit this parameter for users in the third group – IAM users and IAM role-based sessions.
     * </p>
     * 
     * @return The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity
     *         type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins)
     *         authenticated as one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Active Directory (AD) users or group members
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Invited nonfederated users
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID
     *         Connect, or IAM federation.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Omit this parameter for users in the third group – IAM users and IAM role-based sessions.
     */
    public final String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The QuickSight namespace that contains the dashboard IDs in this request. If you're not using a custom namespace,
     * set <code>Namespace = default</code>.
     * </p>
     * 
     * @return The QuickSight namespace that contains the dashboard IDs in this request. If you're not using a custom
     *         namespace, set <code>Namespace = default</code>.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalDashboardIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalDashboardIds() {
        return additionalDashboardIds != null && !(additionalDashboardIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more dashboard IDs that you want anonymous users to have tempporary access to. Currently, the
     * <code>IdentityType</code> parameter must be set to <code>ANONYMOUS</code> because other identity types
     * authenticate as QuickSight or IAM users. For example, if you set "
     * <code>--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the session can
     * access all three dashboards.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalDashboardIds} method.
     * </p>
     * 
     * @return A list of one or more dashboard IDs that you want anonymous users to have tempporary access to.
     *         Currently, the <code>IdentityType</code> parameter must be set to <code>ANONYMOUS</code> because other
     *         identity types authenticate as QuickSight or IAM users. For example, if you set "
     *         <code>--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the
     *         session can access all three dashboards.
     */
    public final List<String> additionalDashboardIds() {
        return additionalDashboardIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sessionLifetimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(undoRedoDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(resetDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(statePersistenceEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalDashboardIds() ? additionalDashboardIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDashboardEmbedUrlRequest)) {
            return false;
        }
        GetDashboardEmbedUrlRequest other = (GetDashboardEmbedUrlRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dashboardId(), other.dashboardId())
                && Objects.equals(identityTypeAsString(), other.identityTypeAsString())
                && Objects.equals(sessionLifetimeInMinutes(), other.sessionLifetimeInMinutes())
                && Objects.equals(undoRedoDisabled(), other.undoRedoDisabled())
                && Objects.equals(resetDisabled(), other.resetDisabled())
                && Objects.equals(statePersistenceEnabled(), other.statePersistenceEnabled())
                && Objects.equals(userArn(), other.userArn()) && Objects.equals(namespace(), other.namespace())
                && hasAdditionalDashboardIds() == other.hasAdditionalDashboardIds()
                && Objects.equals(additionalDashboardIds(), other.additionalDashboardIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDashboardEmbedUrlRequest").add("AwsAccountId", awsAccountId())
                .add("DashboardId", dashboardId()).add("IdentityType", identityTypeAsString())
                .add("SessionLifetimeInMinutes", sessionLifetimeInMinutes()).add("UndoRedoDisabled", undoRedoDisabled())
                .add("ResetDisabled", resetDisabled()).add("StatePersistenceEnabled", statePersistenceEnabled())
                .add("UserArn", userArn()).add("Namespace", namespace())
                .add("AdditionalDashboardIds", hasAdditionalDashboardIds() ? additionalDashboardIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "IdentityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "SessionLifetimeInMinutes":
            return Optional.ofNullable(clazz.cast(sessionLifetimeInMinutes()));
        case "UndoRedoDisabled":
            return Optional.ofNullable(clazz.cast(undoRedoDisabled()));
        case "ResetDisabled":
            return Optional.ofNullable(clazz.cast(resetDisabled()));
        case "StatePersistenceEnabled":
            return Optional.ofNullable(clazz.cast(statePersistenceEnabled()));
        case "UserArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "AdditionalDashboardIds":
            return Optional.ofNullable(clazz.cast(additionalDashboardIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("DashboardId", DASHBOARD_ID_FIELD);
        map.put("creds-type", IDENTITY_TYPE_FIELD);
        map.put("session-lifetime", SESSION_LIFETIME_IN_MINUTES_FIELD);
        map.put("undo-redo-disabled", UNDO_REDO_DISABLED_FIELD);
        map.put("reset-disabled", RESET_DISABLED_FIELD);
        map.put("state-persistence-enabled", STATE_PERSISTENCE_ENABLED_FIELD);
        map.put("user-arn", USER_ARN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("additional-dashboard-ids", ADDITIONAL_DASHBOARD_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDashboardEmbedUrlRequest, T> g) {
        return obj -> g.apply((GetDashboardEmbedUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDashboardEmbedUrlRequest> {
        /**
         * <p>
         * The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID for the dashboard, also added to the Identity and Access Management (IAM) policy.
         * </p>
         * 
         * @param dashboardId
         *        The ID for the dashboard, also added to the Identity and Access Management (IAM) policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The authentication method that the user uses to sign in.
         * </p>
         * 
         * @param identityType
         *        The authentication method that the user uses to sign in.
         * @see EmbeddingIdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmbeddingIdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * The authentication method that the user uses to sign in.
         * </p>
         * 
         * @param identityType
         *        The authentication method that the user uses to sign in.
         * @see EmbeddingIdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmbeddingIdentityType
         */
        Builder identityType(EmbeddingIdentityType identityType);

        /**
         * <p>
         * How many minutes the session is valid. The session lifetime must be 15-600 minutes.
         * </p>
         * 
         * @param sessionLifetimeInMinutes
         *        How many minutes the session is valid. The session lifetime must be 15-600 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLifetimeInMinutes(Long sessionLifetimeInMinutes);

        /**
         * <p>
         * Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo
         * button.
         * </p>
         * 
         * @param undoRedoDisabled
         *        Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the
         *        undo/redo button.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder undoRedoDisabled(Boolean undoRedoDisabled);

        /**
         * <p>
         * Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.
         * </p>
         * 
         * @param resetDisabled
         *        Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset
         *        button.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resetDisabled(Boolean resetDisabled);

        /**
         * <p>
         * Adds persistence of state for the user session in an embedded dashboard. Persistence applies to the sheet and
         * the parameter settings. These are control settings that the dashboard subscriber (QuickSight reader) chooses
         * while viewing the dashboard. If this is set to <code>TRUE</code>, the settings are the same when the
         * subscriber reopens the same dashboard URL. The state is stored in QuickSight, not in a browser cookie. If
         * this is set to FALSE, the state of the user session is not persisted. The default is <code>FALSE</code>.
         * </p>
         * 
         * @param statePersistenceEnabled
         *        Adds persistence of state for the user session in an embedded dashboard. Persistence applies to the
         *        sheet and the parameter settings. These are control settings that the dashboard subscriber (QuickSight
         *        reader) chooses while viewing the dashboard. If this is set to <code>TRUE</code>, the settings are the
         *        same when the subscriber reopens the same dashboard URL. The state is stored in QuickSight, not in a
         *        browser cookie. If this is set to FALSE, the state of the user session is not persisted. The default
         *        is <code>FALSE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statePersistenceEnabled(Boolean statePersistenceEnabled);

        /**
         * <p>
         * The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type.
         * You can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated
         * as one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Active Directory (AD) users or group members
         * </p>
         * </li>
         * <li>
         * <p>
         * Invited nonfederated users
         * </p>
         * </li>
         * <li>
         * <p>
         * IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID
         * Connect, or IAM federation.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Omit this parameter for users in the third group – IAM users and IAM role-based sessions.
         * </p>
         * 
         * @param userArn
         *        The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity
         *        type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins)
         *        authenticated as one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Active Directory (AD) users or group members
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Invited nonfederated users
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML,
         *        OpenID Connect, or IAM federation.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Omit this parameter for users in the third group – IAM users and IAM role-based sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The QuickSight namespace that contains the dashboard IDs in this request. If you're not using a custom
         * namespace, set <code>Namespace = default</code>.
         * </p>
         * 
         * @param namespace
         *        The QuickSight namespace that contains the dashboard IDs in this request. If you're not using a custom
         *        namespace, set <code>Namespace = default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * A list of one or more dashboard IDs that you want anonymous users to have tempporary access to. Currently,
         * the <code>IdentityType</code> parameter must be set to <code>ANONYMOUS</code> because other identity types
         * authenticate as QuickSight or IAM users. For example, if you set "
         * <code>--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the session
         * can access all three dashboards.
         * </p>
         * 
         * @param additionalDashboardIds
         *        A list of one or more dashboard IDs that you want anonymous users to have tempporary access to.
         *        Currently, the <code>IdentityType</code> parameter must be set to <code>ANONYMOUS</code> because other
         *        identity types authenticate as QuickSight or IAM users. For example, if you set "
         *        <code>--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the
         *        session can access all three dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDashboardIds(Collection<String> additionalDashboardIds);

        /**
         * <p>
         * A list of one or more dashboard IDs that you want anonymous users to have tempporary access to. Currently,
         * the <code>IdentityType</code> parameter must be set to <code>ANONYMOUS</code> because other identity types
         * authenticate as QuickSight or IAM users. For example, if you set "
         * <code>--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the session
         * can access all three dashboards.
         * </p>
         * 
         * @param additionalDashboardIds
         *        A list of one or more dashboard IDs that you want anonymous users to have tempporary access to.
         *        Currently, the <code>IdentityType</code> parameter must be set to <code>ANONYMOUS</code> because other
         *        identity types authenticate as QuickSight or IAM users. For example, if you set "
         *        <code>--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the
         *        session can access all three dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDashboardIds(String... additionalDashboardIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dashboardId;

        private String identityType;

        private Long sessionLifetimeInMinutes;

        private Boolean undoRedoDisabled;

        private Boolean resetDisabled;

        private Boolean statePersistenceEnabled;

        private String userArn;

        private String namespace;

        private List<String> additionalDashboardIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDashboardEmbedUrlRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dashboardId(model.dashboardId);
            identityType(model.identityType);
            sessionLifetimeInMinutes(model.sessionLifetimeInMinutes);
            undoRedoDisabled(model.undoRedoDisabled);
            resetDisabled(model.resetDisabled);
            statePersistenceEnabled(model.statePersistenceEnabled);
            userArn(model.userArn);
            namespace(model.namespace);
            additionalDashboardIds(model.additionalDashboardIds);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getIdentityType() {
            return identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(EmbeddingIdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final Long getSessionLifetimeInMinutes() {
            return sessionLifetimeInMinutes;
        }

        public final void setSessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
        }

        @Override
        public final Builder sessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
            return this;
        }

        public final Boolean getUndoRedoDisabled() {
            return undoRedoDisabled;
        }

        public final void setUndoRedoDisabled(Boolean undoRedoDisabled) {
            this.undoRedoDisabled = undoRedoDisabled;
        }

        @Override
        public final Builder undoRedoDisabled(Boolean undoRedoDisabled) {
            this.undoRedoDisabled = undoRedoDisabled;
            return this;
        }

        public final Boolean getResetDisabled() {
            return resetDisabled;
        }

        public final void setResetDisabled(Boolean resetDisabled) {
            this.resetDisabled = resetDisabled;
        }

        @Override
        public final Builder resetDisabled(Boolean resetDisabled) {
            this.resetDisabled = resetDisabled;
            return this;
        }

        public final Boolean getStatePersistenceEnabled() {
            return statePersistenceEnabled;
        }

        public final void setStatePersistenceEnabled(Boolean statePersistenceEnabled) {
            this.statePersistenceEnabled = statePersistenceEnabled;
        }

        @Override
        public final Builder statePersistenceEnabled(Boolean statePersistenceEnabled) {
            this.statePersistenceEnabled = statePersistenceEnabled;
            return this;
        }

        public final String getUserArn() {
            return userArn;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final Collection<String> getAdditionalDashboardIds() {
            if (additionalDashboardIds instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalDashboardIds;
        }

        public final void setAdditionalDashboardIds(Collection<String> additionalDashboardIds) {
            this.additionalDashboardIds = AdditionalDashboardIdListCopier.copy(additionalDashboardIds);
        }

        @Override
        public final Builder additionalDashboardIds(Collection<String> additionalDashboardIds) {
            this.additionalDashboardIds = AdditionalDashboardIdListCopier.copy(additionalDashboardIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalDashboardIds(String... additionalDashboardIds) {
            additionalDashboardIds(Arrays.asList(additionalDashboardIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDashboardEmbedUrlRequest build() {
            return new GetDashboardEmbedUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
