/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The geospatial Line layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialLineLayer implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialLineLayer.Builder, GeospatialLineLayer> {
    private static final SdkField<GeospatialLineStyle> STYLE_FIELD = SdkField
            .<GeospatialLineStyle> builder(MarshallingType.SDK_POJO).memberName("Style")
            .getter(getter(GeospatialLineLayer::style)).setter(setter(Builder::style)).constructor(GeospatialLineStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Style").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STYLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeospatialLineStyle style;

    private GeospatialLineLayer(BuilderImpl builder) {
        this.style = builder.style;
    }

    /**
     * <p>
     * The visualization style for a line layer.
     * </p>
     * 
     * @return The visualization style for a line layer.
     */
    public final GeospatialLineStyle style() {
        return style;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(style());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialLineLayer)) {
            return false;
        }
        GeospatialLineLayer other = (GeospatialLineLayer) obj;
        return Objects.equals(style(), other.style());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialLineLayer").add("Style", style()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Style":
            return Optional.ofNullable(clazz.cast(style()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Style", STYLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialLineLayer, T> g) {
        return obj -> g.apply((GeospatialLineLayer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialLineLayer> {
        /**
         * <p>
         * The visualization style for a line layer.
         * </p>
         * 
         * @param style
         *        The visualization style for a line layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder style(GeospatialLineStyle style);

        /**
         * <p>
         * The visualization style for a line layer.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialLineStyle.Builder} avoiding the
         * need to create one manually via {@link GeospatialLineStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialLineStyle.Builder#build()} is called immediately and
         * its result is passed to {@link #style(GeospatialLineStyle)}.
         * 
         * @param style
         *        a consumer that will call methods on {@link GeospatialLineStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #style(GeospatialLineStyle)
         */
        default Builder style(Consumer<GeospatialLineStyle.Builder> style) {
            return style(GeospatialLineStyle.builder().applyMutation(style).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeospatialLineStyle style;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialLineLayer model) {
            style(model.style);
        }

        public final GeospatialLineStyle.Builder getStyle() {
            return style != null ? style.toBuilder() : null;
        }

        public final void setStyle(GeospatialLineStyle.BuilderImpl style) {
            this.style = style != null ? style.build() : null;
        }

        @Override
        public final Builder style(GeospatialLineStyle style) {
            this.style = style;
            return this;
        }

        @Override
        public GeospatialLineLayer build() {
            return new GeospatialLineLayer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
