/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for a gradient color.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialGradientColor implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialGradientColor.Builder, GeospatialGradientColor> {
    private static final SdkField<List<GeospatialGradientStepColor>> STEP_COLORS_FIELD = SdkField
            .<List<GeospatialGradientStepColor>> builder(MarshallingType.LIST)
            .memberName("StepColors")
            .getter(getter(GeospatialGradientColor::stepColors))
            .setter(setter(Builder::stepColors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepColors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GeospatialGradientStepColor> builder(MarshallingType.SDK_POJO)
                                            .constructor(GeospatialGradientStepColor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NULL_DATA_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NullDataVisibility").getter(getter(GeospatialGradientColor::nullDataVisibilityAsString))
            .setter(setter(Builder::nullDataVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullDataVisibility").build())
            .build();

    private static final SdkField<GeospatialNullDataSettings> NULL_DATA_SETTINGS_FIELD = SdkField
            .<GeospatialNullDataSettings> builder(MarshallingType.SDK_POJO).memberName("NullDataSettings")
            .getter(getter(GeospatialGradientColor::nullDataSettings)).setter(setter(Builder::nullDataSettings))
            .constructor(GeospatialNullDataSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullDataSettings").build()).build();

    private static final SdkField<Double> DEFAULT_OPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DefaultOpacity").getter(getter(GeospatialGradientColor::defaultOpacity))
            .setter(setter(Builder::defaultOpacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOpacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_COLORS_FIELD,
            NULL_DATA_VISIBILITY_FIELD, NULL_DATA_SETTINGS_FIELD, DEFAULT_OPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<GeospatialGradientStepColor> stepColors;

    private final String nullDataVisibility;

    private final GeospatialNullDataSettings nullDataSettings;

    private final Double defaultOpacity;

    private GeospatialGradientColor(BuilderImpl builder) {
        this.stepColors = builder.stepColors;
        this.nullDataVisibility = builder.nullDataVisibility;
        this.nullDataSettings = builder.nullDataSettings;
        this.defaultOpacity = builder.defaultOpacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the StepColors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStepColors() {
        return stepColors != null && !(stepColors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of gradient step colors for the gradient.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStepColors} method.
     * </p>
     * 
     * @return A list of gradient step colors for the gradient.
     */
    public final List<GeospatialGradientStepColor> stepColors() {
        return stepColors;
    }

    /**
     * <p>
     * The state of visibility for null data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nullDataVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #nullDataVisibilityAsString}.
     * </p>
     * 
     * @return The state of visibility for null data.
     * @see Visibility
     */
    public final Visibility nullDataVisibility() {
        return Visibility.fromValue(nullDataVisibility);
    }

    /**
     * <p>
     * The state of visibility for null data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nullDataVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #nullDataVisibilityAsString}.
     * </p>
     * 
     * @return The state of visibility for null data.
     * @see Visibility
     */
    public final String nullDataVisibilityAsString() {
        return nullDataVisibility;
    }

    /**
     * <p>
     * The null data visualization settings.
     * </p>
     * 
     * @return The null data visualization settings.
     */
    public final GeospatialNullDataSettings nullDataSettings() {
        return nullDataSettings;
    }

    /**
     * <p>
     * The default opacity for the gradient color.
     * </p>
     * 
     * @return The default opacity for the gradient color.
     */
    public final Double defaultOpacity() {
        return defaultOpacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStepColors() ? stepColors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nullDataVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nullDataSettings());
        hashCode = 31 * hashCode + Objects.hashCode(defaultOpacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialGradientColor)) {
            return false;
        }
        GeospatialGradientColor other = (GeospatialGradientColor) obj;
        return hasStepColors() == other.hasStepColors() && Objects.equals(stepColors(), other.stepColors())
                && Objects.equals(nullDataVisibilityAsString(), other.nullDataVisibilityAsString())
                && Objects.equals(nullDataSettings(), other.nullDataSettings())
                && Objects.equals(defaultOpacity(), other.defaultOpacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialGradientColor").add("StepColors", hasStepColors() ? stepColors() : null)
                .add("NullDataVisibility", nullDataVisibilityAsString()).add("NullDataSettings", nullDataSettings())
                .add("DefaultOpacity", defaultOpacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StepColors":
            return Optional.ofNullable(clazz.cast(stepColors()));
        case "NullDataVisibility":
            return Optional.ofNullable(clazz.cast(nullDataVisibilityAsString()));
        case "NullDataSettings":
            return Optional.ofNullable(clazz.cast(nullDataSettings()));
        case "DefaultOpacity":
            return Optional.ofNullable(clazz.cast(defaultOpacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StepColors", STEP_COLORS_FIELD);
        map.put("NullDataVisibility", NULL_DATA_VISIBILITY_FIELD);
        map.put("NullDataSettings", NULL_DATA_SETTINGS_FIELD);
        map.put("DefaultOpacity", DEFAULT_OPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialGradientColor, T> g) {
        return obj -> g.apply((GeospatialGradientColor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialGradientColor> {
        /**
         * <p>
         * A list of gradient step colors for the gradient.
         * </p>
         * 
         * @param stepColors
         *        A list of gradient step colors for the gradient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepColors(Collection<GeospatialGradientStepColor> stepColors);

        /**
         * <p>
         * A list of gradient step colors for the gradient.
         * </p>
         * 
         * @param stepColors
         *        A list of gradient step colors for the gradient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepColors(GeospatialGradientStepColor... stepColors);

        /**
         * <p>
         * A list of gradient step colors for the gradient.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.GeospatialGradientStepColor.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.GeospatialGradientStepColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.GeospatialGradientStepColor.Builder#build()} is
         * called immediately and its result is passed to {@link #stepColors(List<GeospatialGradientStepColor>)}.
         * 
         * @param stepColors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.GeospatialGradientStepColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepColors(java.util.Collection<GeospatialGradientStepColor>)
         */
        Builder stepColors(Consumer<GeospatialGradientStepColor.Builder>... stepColors);

        /**
         * <p>
         * The state of visibility for null data.
         * </p>
         * 
         * @param nullDataVisibility
         *        The state of visibility for null data.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder nullDataVisibility(String nullDataVisibility);

        /**
         * <p>
         * The state of visibility for null data.
         * </p>
         * 
         * @param nullDataVisibility
         *        The state of visibility for null data.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder nullDataVisibility(Visibility nullDataVisibility);

        /**
         * <p>
         * The null data visualization settings.
         * </p>
         * 
         * @param nullDataSettings
         *        The null data visualization settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nullDataSettings(GeospatialNullDataSettings nullDataSettings);

        /**
         * <p>
         * The null data visualization settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialNullDataSettings.Builder}
         * avoiding the need to create one manually via {@link GeospatialNullDataSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialNullDataSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #nullDataSettings(GeospatialNullDataSettings)}.
         * 
         * @param nullDataSettings
         *        a consumer that will call methods on {@link GeospatialNullDataSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nullDataSettings(GeospatialNullDataSettings)
         */
        default Builder nullDataSettings(Consumer<GeospatialNullDataSettings.Builder> nullDataSettings) {
            return nullDataSettings(GeospatialNullDataSettings.builder().applyMutation(nullDataSettings).build());
        }

        /**
         * <p>
         * The default opacity for the gradient color.
         * </p>
         * 
         * @param defaultOpacity
         *        The default opacity for the gradient color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOpacity(Double defaultOpacity);
    }

    static final class BuilderImpl implements Builder {
        private List<GeospatialGradientStepColor> stepColors = DefaultSdkAutoConstructList.getInstance();

        private String nullDataVisibility;

        private GeospatialNullDataSettings nullDataSettings;

        private Double defaultOpacity;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialGradientColor model) {
            stepColors(model.stepColors);
            nullDataVisibility(model.nullDataVisibility);
            nullDataSettings(model.nullDataSettings);
            defaultOpacity(model.defaultOpacity);
        }

        public final List<GeospatialGradientStepColor.Builder> getStepColors() {
            List<GeospatialGradientStepColor.Builder> result = GeospatialGradientStepColorListCopier
                    .copyToBuilder(this.stepColors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStepColors(Collection<GeospatialGradientStepColor.BuilderImpl> stepColors) {
            this.stepColors = GeospatialGradientStepColorListCopier.copyFromBuilder(stepColors);
        }

        @Override
        public final Builder stepColors(Collection<GeospatialGradientStepColor> stepColors) {
            this.stepColors = GeospatialGradientStepColorListCopier.copy(stepColors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepColors(GeospatialGradientStepColor... stepColors) {
            stepColors(Arrays.asList(stepColors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepColors(Consumer<GeospatialGradientStepColor.Builder>... stepColors) {
            stepColors(Stream.of(stepColors).map(c -> GeospatialGradientStepColor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNullDataVisibility() {
            return nullDataVisibility;
        }

        public final void setNullDataVisibility(String nullDataVisibility) {
            this.nullDataVisibility = nullDataVisibility;
        }

        @Override
        public final Builder nullDataVisibility(String nullDataVisibility) {
            this.nullDataVisibility = nullDataVisibility;
            return this;
        }

        @Override
        public final Builder nullDataVisibility(Visibility nullDataVisibility) {
            this.nullDataVisibility(nullDataVisibility == null ? null : nullDataVisibility.toString());
            return this;
        }

        public final GeospatialNullDataSettings.Builder getNullDataSettings() {
            return nullDataSettings != null ? nullDataSettings.toBuilder() : null;
        }

        public final void setNullDataSettings(GeospatialNullDataSettings.BuilderImpl nullDataSettings) {
            this.nullDataSettings = nullDataSettings != null ? nullDataSettings.build() : null;
        }

        @Override
        public final Builder nullDataSettings(GeospatialNullDataSettings nullDataSettings) {
            this.nullDataSettings = nullDataSettings;
            return this;
        }

        public final Double getDefaultOpacity() {
            return defaultOpacity;
        }

        public final void setDefaultOpacity(Double defaultOpacity) {
            this.defaultOpacity = defaultOpacity;
        }

        @Override
        public final Builder defaultOpacity(Double defaultOpacity) {
            this.defaultOpacity = defaultOpacity;
            return this;
        }

        @Override
        public GeospatialGradientColor build() {
            return new GeospatialGradientColor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
