/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The forecast configuration that is used in a line chart's display properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ForecastConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ForecastConfiguration.Builder, ForecastConfiguration> {
    private static final SdkField<TimeBasedForecastProperties> FORECAST_PROPERTIES_FIELD = SdkField
            .<TimeBasedForecastProperties> builder(MarshallingType.SDK_POJO).memberName("ForecastProperties")
            .getter(getter(ForecastConfiguration::forecastProperties)).setter(setter(Builder::forecastProperties))
            .constructor(TimeBasedForecastProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastProperties").build())
            .build();

    private static final SdkField<ForecastScenario> SCENARIO_FIELD = SdkField
            .<ForecastScenario> builder(MarshallingType.SDK_POJO).memberName("Scenario")
            .getter(getter(ForecastConfiguration::scenario)).setter(setter(Builder::scenario))
            .constructor(ForecastScenario::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scenario").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_PROPERTIES_FIELD,
            SCENARIO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TimeBasedForecastProperties forecastProperties;

    private final ForecastScenario scenario;

    private ForecastConfiguration(BuilderImpl builder) {
        this.forecastProperties = builder.forecastProperties;
        this.scenario = builder.scenario;
    }

    /**
     * <p>
     * The forecast properties setup of a forecast in the line chart.
     * </p>
     * 
     * @return The forecast properties setup of a forecast in the line chart.
     */
    public final TimeBasedForecastProperties forecastProperties() {
        return forecastProperties;
    }

    /**
     * <p>
     * The forecast scenario of a forecast in the line chart.
     * </p>
     * 
     * @return The forecast scenario of a forecast in the line chart.
     */
    public final ForecastScenario scenario() {
        return scenario;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forecastProperties());
        hashCode = 31 * hashCode + Objects.hashCode(scenario());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastConfiguration)) {
            return false;
        }
        ForecastConfiguration other = (ForecastConfiguration) obj;
        return Objects.equals(forecastProperties(), other.forecastProperties()) && Objects.equals(scenario(), other.scenario());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ForecastConfiguration").add("ForecastProperties", forecastProperties())
                .add("Scenario", scenario()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForecastProperties":
            return Optional.ofNullable(clazz.cast(forecastProperties()));
        case "Scenario":
            return Optional.ofNullable(clazz.cast(scenario()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ForecastProperties", FORECAST_PROPERTIES_FIELD);
        map.put("Scenario", SCENARIO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ForecastConfiguration, T> g) {
        return obj -> g.apply((ForecastConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ForecastConfiguration> {
        /**
         * <p>
         * The forecast properties setup of a forecast in the line chart.
         * </p>
         * 
         * @param forecastProperties
         *        The forecast properties setup of a forecast in the line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastProperties(TimeBasedForecastProperties forecastProperties);

        /**
         * <p>
         * The forecast properties setup of a forecast in the line chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeBasedForecastProperties.Builder}
         * avoiding the need to create one manually via {@link TimeBasedForecastProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeBasedForecastProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #forecastProperties(TimeBasedForecastProperties)}.
         * 
         * @param forecastProperties
         *        a consumer that will call methods on {@link TimeBasedForecastProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forecastProperties(TimeBasedForecastProperties)
         */
        default Builder forecastProperties(Consumer<TimeBasedForecastProperties.Builder> forecastProperties) {
            return forecastProperties(TimeBasedForecastProperties.builder().applyMutation(forecastProperties).build());
        }

        /**
         * <p>
         * The forecast scenario of a forecast in the line chart.
         * </p>
         * 
         * @param scenario
         *        The forecast scenario of a forecast in the line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scenario(ForecastScenario scenario);

        /**
         * <p>
         * The forecast scenario of a forecast in the line chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link ForecastScenario.Builder} avoiding the
         * need to create one manually via {@link ForecastScenario#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ForecastScenario.Builder#build()} is called immediately and its
         * result is passed to {@link #scenario(ForecastScenario)}.
         * 
         * @param scenario
         *        a consumer that will call methods on {@link ForecastScenario.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scenario(ForecastScenario)
         */
        default Builder scenario(Consumer<ForecastScenario.Builder> scenario) {
            return scenario(ForecastScenario.builder().applyMutation(scenario).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TimeBasedForecastProperties forecastProperties;

        private ForecastScenario scenario;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastConfiguration model) {
            forecastProperties(model.forecastProperties);
            scenario(model.scenario);
        }

        public final TimeBasedForecastProperties.Builder getForecastProperties() {
            return forecastProperties != null ? forecastProperties.toBuilder() : null;
        }

        public final void setForecastProperties(TimeBasedForecastProperties.BuilderImpl forecastProperties) {
            this.forecastProperties = forecastProperties != null ? forecastProperties.build() : null;
        }

        @Override
        public final Builder forecastProperties(TimeBasedForecastProperties forecastProperties) {
            this.forecastProperties = forecastProperties;
            return this;
        }

        public final ForecastScenario.Builder getScenario() {
            return scenario != null ? scenario.toBuilder() : null;
        }

        public final void setScenario(ForecastScenario.BuilderImpl scenario) {
            this.scenario = scenario != null ? scenario.build() : null;
        }

        @Override
        public final Builder scenario(ForecastScenario scenario) {
            this.scenario = scenario;
            return this;
        }

        @Override
        public ForecastConfiguration build() {
            return new ForecastConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
