/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A control from a date filter that is used to specify date and time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterDateTimePickerControl implements SdkPojo, Serializable,
        ToCopyableBuilder<FilterDateTimePickerControl.Builder, FilterDateTimePickerControl> {
    private static final SdkField<String> FILTER_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterControlId").getter(getter(FilterDateTimePickerControl::filterControlId))
            .setter(setter(Builder::filterControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterControlId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(FilterDateTimePickerControl::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> SOURCE_FILTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFilterId").getter(getter(FilterDateTimePickerControl::sourceFilterId))
            .setter(setter(Builder::sourceFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFilterId").build()).build();

    private static final SdkField<DateTimePickerControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField
            .<DateTimePickerControlDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayOptions")
            .getter(getter(FilterDateTimePickerControl::displayOptions)).setter(setter(Builder::displayOptions))
            .constructor(DateTimePickerControlDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(FilterDateTimePickerControl::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> COMMIT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommitMode").getter(getter(FilterDateTimePickerControl::commitModeAsString))
            .setter(setter(Builder::commitMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CONTROL_ID_FIELD,
            TITLE_FIELD, SOURCE_FILTER_ID_FIELD, DISPLAY_OPTIONS_FIELD, TYPE_FIELD, COMMIT_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterControlId;

    private final String title;

    private final String sourceFilterId;

    private final DateTimePickerControlDisplayOptions displayOptions;

    private final String type;

    private final String commitMode;

    private FilterDateTimePickerControl(BuilderImpl builder) {
        this.filterControlId = builder.filterControlId;
        this.title = builder.title;
        this.sourceFilterId = builder.sourceFilterId;
        this.displayOptions = builder.displayOptions;
        this.type = builder.type;
        this.commitMode = builder.commitMode;
    }

    /**
     * <p>
     * The ID of the <code>FilterDateTimePickerControl</code>.
     * </p>
     * 
     * @return The ID of the <code>FilterDateTimePickerControl</code>.
     */
    public final String filterControlId() {
        return filterControlId;
    }

    /**
     * <p>
     * The title of the <code>FilterDateTimePickerControl</code>.
     * </p>
     * 
     * @return The title of the <code>FilterDateTimePickerControl</code>.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The source filter ID of the <code>FilterDateTimePickerControl</code>.
     * </p>
     * 
     * @return The source filter ID of the <code>FilterDateTimePickerControl</code>.
     */
    public final String sourceFilterId() {
        return sourceFilterId;
    }

    /**
     * <p>
     * The display options of a control.
     * </p>
     * 
     * @return The display options of a control.
     */
    public final DateTimePickerControlDisplayOptions displayOptions() {
        return displayOptions;
    }

    /**
     * <p>
     * The type of the <code>FilterDropDownControl</code>. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SheetControlDateTimePickerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
     *         </p>
     *         </li>
     * @see SheetControlDateTimePickerType
     */
    public final SheetControlDateTimePickerType type() {
        return SheetControlDateTimePickerType.fromValue(type);
    }

    /**
     * <p>
     * The type of the <code>FilterDropDownControl</code>. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SheetControlDateTimePickerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
     *         </p>
     *         </li>
     * @see SheetControlDateTimePickerType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The visibility configurationof the Apply button on a <code>DateTimePickerControl</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #commitMode} will
     * return {@link CommitMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #commitModeAsString}.
     * </p>
     * 
     * @return The visibility configurationof the Apply button on a <code>DateTimePickerControl</code>.
     * @see CommitMode
     */
    public final CommitMode commitMode() {
        return CommitMode.fromValue(commitMode);
    }

    /**
     * <p>
     * The visibility configurationof the Apply button on a <code>DateTimePickerControl</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #commitMode} will
     * return {@link CommitMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #commitModeAsString}.
     * </p>
     * 
     * @return The visibility configurationof the Apply button on a <code>DateTimePickerControl</code>.
     * @see CommitMode
     */
    public final String commitModeAsString() {
        return commitMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterControlId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(displayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(commitModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterDateTimePickerControl)) {
            return false;
        }
        FilterDateTimePickerControl other = (FilterDateTimePickerControl) obj;
        return Objects.equals(filterControlId(), other.filterControlId()) && Objects.equals(title(), other.title())
                && Objects.equals(sourceFilterId(), other.sourceFilterId())
                && Objects.equals(displayOptions(), other.displayOptions())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(commitModeAsString(), other.commitModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterDateTimePickerControl").add("FilterControlId", filterControlId()).add("Title", title())
                .add("SourceFilterId", sourceFilterId()).add("DisplayOptions", displayOptions()).add("Type", typeAsString())
                .add("CommitMode", commitModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterControlId":
            return Optional.ofNullable(clazz.cast(filterControlId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "SourceFilterId":
            return Optional.ofNullable(clazz.cast(sourceFilterId()));
        case "DisplayOptions":
            return Optional.ofNullable(clazz.cast(displayOptions()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "CommitMode":
            return Optional.ofNullable(clazz.cast(commitModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilterControlId", FILTER_CONTROL_ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("SourceFilterId", SOURCE_FILTER_ID_FIELD);
        map.put("DisplayOptions", DISPLAY_OPTIONS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("CommitMode", COMMIT_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterDateTimePickerControl, T> g) {
        return obj -> g.apply((FilterDateTimePickerControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterDateTimePickerControl> {
        /**
         * <p>
         * The ID of the <code>FilterDateTimePickerControl</code>.
         * </p>
         * 
         * @param filterControlId
         *        The ID of the <code>FilterDateTimePickerControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterControlId(String filterControlId);

        /**
         * <p>
         * The title of the <code>FilterDateTimePickerControl</code>.
         * </p>
         * 
         * @param title
         *        The title of the <code>FilterDateTimePickerControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The source filter ID of the <code>FilterDateTimePickerControl</code>.
         * </p>
         * 
         * @param sourceFilterId
         *        The source filter ID of the <code>FilterDateTimePickerControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFilterId(String sourceFilterId);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * 
         * @param displayOptions
         *        The display options of a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOptions(DateTimePickerControlDisplayOptions displayOptions);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DateTimePickerControlDisplayOptions.Builder} avoiding the need to create one manually via
         * {@link DateTimePickerControlDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateTimePickerControlDisplayOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #displayOptions(DateTimePickerControlDisplayOptions)}.
         * 
         * @param displayOptions
         *        a consumer that will call methods on {@link DateTimePickerControlDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayOptions(DateTimePickerControlDisplayOptions)
         */
        default Builder displayOptions(Consumer<DateTimePickerControlDisplayOptions.Builder> displayOptions) {
            return displayOptions(DateTimePickerControlDisplayOptions.builder().applyMutation(displayOptions).build());
        }

        /**
         * <p>
         * The type of the <code>FilterDropDownControl</code>. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
         *        </p>
         *        </li>
         * @see SheetControlDateTimePickerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetControlDateTimePickerType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the <code>FilterDropDownControl</code>. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
         *        </p>
         *        </li>
         * @see SheetControlDateTimePickerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetControlDateTimePickerType
         */
        Builder type(SheetControlDateTimePickerType type);

        /**
         * <p>
         * The visibility configurationof the Apply button on a <code>DateTimePickerControl</code>.
         * </p>
         * 
         * @param commitMode
         *        The visibility configurationof the Apply button on a <code>DateTimePickerControl</code>.
         * @see CommitMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommitMode
         */
        Builder commitMode(String commitMode);

        /**
         * <p>
         * The visibility configurationof the Apply button on a <code>DateTimePickerControl</code>.
         * </p>
         * 
         * @param commitMode
         *        The visibility configurationof the Apply button on a <code>DateTimePickerControl</code>.
         * @see CommitMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommitMode
         */
        Builder commitMode(CommitMode commitMode);
    }

    static final class BuilderImpl implements Builder {
        private String filterControlId;

        private String title;

        private String sourceFilterId;

        private DateTimePickerControlDisplayOptions displayOptions;

        private String type;

        private String commitMode;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterDateTimePickerControl model) {
            filterControlId(model.filterControlId);
            title(model.title);
            sourceFilterId(model.sourceFilterId);
            displayOptions(model.displayOptions);
            type(model.type);
            commitMode(model.commitMode);
        }

        public final String getFilterControlId() {
            return filterControlId;
        }

        public final void setFilterControlId(String filterControlId) {
            this.filterControlId = filterControlId;
        }

        @Override
        public final Builder filterControlId(String filterControlId) {
            this.filterControlId = filterControlId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSourceFilterId() {
            return sourceFilterId;
        }

        public final void setSourceFilterId(String sourceFilterId) {
            this.sourceFilterId = sourceFilterId;
        }

        @Override
        public final Builder sourceFilterId(String sourceFilterId) {
            this.sourceFilterId = sourceFilterId;
            return this;
        }

        public final DateTimePickerControlDisplayOptions.Builder getDisplayOptions() {
            return displayOptions != null ? displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(DateTimePickerControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(DateTimePickerControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SheetControlDateTimePickerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getCommitMode() {
            return commitMode;
        }

        public final void setCommitMode(String commitMode) {
            this.commitMode = commitMode;
        }

        @Override
        public final Builder commitMode(String commitMode) {
            this.commitMode = commitMode;
            return this;
        }

        @Override
        public final Builder commitMode(CommitMode commitMode) {
            this.commitMode(commitMode == null ? null : commitMode.toString());
            return this;
        }

        @Override
        public FilterDateTimePickerControl build() {
            return new FilterDateTimePickerControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
