/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCustomPermissionsResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeCustomPermissionsResponse.Builder, DescribeCustomPermissionsResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeCustomPermissionsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<CustomPermissions> CUSTOM_PERMISSIONS_FIELD = SdkField
            .<CustomPermissions> builder(MarshallingType.SDK_POJO).memberName("CustomPermissions")
            .getter(getter(DescribeCustomPermissionsResponse::customPermissions)).setter(setter(Builder::customPermissions))
            .constructor(CustomPermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPermissions").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeCustomPermissionsResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            CUSTOM_PERMISSIONS_FIELD, REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer status;

    private final CustomPermissions customPermissions;

    private final String requestId;

    private DescribeCustomPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.customPermissions = builder.customPermissions;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The custom permissions profile.
     * </p>
     * 
     * @return The custom permissions profile.
     */
    public final CustomPermissions customPermissions() {
        return customPermissions;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(customPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomPermissionsResponse)) {
            return false;
        }
        DescribeCustomPermissionsResponse other = (DescribeCustomPermissionsResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(customPermissions(), other.customPermissions())
                && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCustomPermissionsResponse").add("Status", status())
                .add("CustomPermissions", customPermissions()).add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CustomPermissions":
            return Optional.ofNullable(clazz.cast(customPermissions()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("CustomPermissions", CUSTOM_PERMISSIONS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomPermissionsResponse, T> g) {
        return obj -> g.apply((DescribeCustomPermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCustomPermissionsResponse> {
        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The custom permissions profile.
         * </p>
         * 
         * @param customPermissions
         *        The custom permissions profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPermissions(CustomPermissions customPermissions);

        /**
         * <p>
         * The custom permissions profile.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomPermissions.Builder} avoiding the
         * need to create one manually via {@link CustomPermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomPermissions.Builder#build()} is called immediately and its
         * result is passed to {@link #customPermissions(CustomPermissions)}.
         * 
         * @param customPermissions
         *        a consumer that will call methods on {@link CustomPermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customPermissions(CustomPermissions)
         */
        default Builder customPermissions(Consumer<CustomPermissions.Builder> customPermissions) {
            return customPermissions(CustomPermissions.builder().applyMutation(customPermissions).build());
        }

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private Integer status;

        private CustomPermissions customPermissions;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomPermissionsResponse model) {
            super(model);
            status(model.status);
            customPermissions(model.customPermissions);
            requestId(model.requestId);
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final CustomPermissions.Builder getCustomPermissions() {
            return customPermissions != null ? customPermissions.toBuilder() : null;
        }

        public final void setCustomPermissions(CustomPermissions.BuilderImpl customPermissions) {
            this.customPermissions = customPermissions != null ? customPermissions.build() : null;
        }

        @Override
        public final Builder customPermissions(CustomPermissions customPermissions) {
            this.customPermissions = customPermissions;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DescribeCustomPermissionsResponse build() {
            return new DescribeCustomPermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
