/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A parameter declaration for the <code>Decimal</code> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecimalParameterDeclaration implements SdkPojo, Serializable,
        ToCopyableBuilder<DecimalParameterDeclaration.Builder, DecimalParameterDeclaration> {
    private static final SdkField<String> PARAMETER_VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterValueType").getter(getter(DecimalParameterDeclaration::parameterValueTypeAsString))
            .setter(setter(Builder::parameterValueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValueType").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DecimalParameterDeclaration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<DecimalDefaultValues> DEFAULT_VALUES_FIELD = SdkField
            .<DecimalDefaultValues> builder(MarshallingType.SDK_POJO).memberName("DefaultValues")
            .getter(getter(DecimalParameterDeclaration::defaultValues)).setter(setter(Builder::defaultValues))
            .constructor(DecimalDefaultValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValues").build()).build();

    private static final SdkField<DecimalValueWhenUnsetConfiguration> VALUE_WHEN_UNSET_FIELD = SdkField
            .<DecimalValueWhenUnsetConfiguration> builder(MarshallingType.SDK_POJO).memberName("ValueWhenUnset")
            .getter(getter(DecimalParameterDeclaration::valueWhenUnset)).setter(setter(Builder::valueWhenUnset))
            .constructor(DecimalValueWhenUnsetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueWhenUnset").build()).build();

    private static final SdkField<List<MappedDataSetParameter>> MAPPED_DATA_SET_PARAMETERS_FIELD = SdkField
            .<List<MappedDataSetParameter>> builder(MarshallingType.LIST)
            .memberName("MappedDataSetParameters")
            .getter(getter(DecimalParameterDeclaration::mappedDataSetParameters))
            .setter(setter(Builder::mappedDataSetParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MappedDataSetParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MappedDataSetParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MappedDataSetParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_VALUE_TYPE_FIELD,
            NAME_FIELD, DEFAULT_VALUES_FIELD, VALUE_WHEN_UNSET_FIELD, MAPPED_DATA_SET_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String parameterValueType;

    private final String name;

    private final DecimalDefaultValues defaultValues;

    private final DecimalValueWhenUnsetConfiguration valueWhenUnset;

    private final List<MappedDataSetParameter> mappedDataSetParameters;

    private DecimalParameterDeclaration(BuilderImpl builder) {
        this.parameterValueType = builder.parameterValueType;
        this.name = builder.name;
        this.defaultValues = builder.defaultValues;
        this.valueWhenUnset = builder.valueWhenUnset;
        this.mappedDataSetParameters = builder.mappedDataSetParameters;
    }

    /**
     * <p>
     * The value type determines whether the parameter is a single-value or multi-value parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #parameterValueType} will return {@link ParameterValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #parameterValueTypeAsString}.
     * </p>
     * 
     * @return The value type determines whether the parameter is a single-value or multi-value parameter.
     * @see ParameterValueType
     */
    public final ParameterValueType parameterValueType() {
        return ParameterValueType.fromValue(parameterValueType);
    }

    /**
     * <p>
     * The value type determines whether the parameter is a single-value or multi-value parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #parameterValueType} will return {@link ParameterValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #parameterValueTypeAsString}.
     * </p>
     * 
     * @return The value type determines whether the parameter is a single-value or multi-value parameter.
     * @see ParameterValueType
     */
    public final String parameterValueTypeAsString() {
        return parameterValueType;
    }

    /**
     * <p>
     * The name of the parameter that is being declared.
     * </p>
     * 
     * @return The name of the parameter that is being declared.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default value
     * can be provided.
     * </p>
     * 
     * @return The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default
     *         value can be provided.
     */
    public final DecimalDefaultValues defaultValues() {
        return defaultValues;
    }

    /**
     * <p>
     * The configuration that defines the default value of a <code>Decimal</code> parameter when a value has not been
     * set.
     * </p>
     * 
     * @return The configuration that defines the default value of a <code>Decimal</code> parameter when a value has not
     *         been set.
     */
    public final DecimalValueWhenUnsetConfiguration valueWhenUnset() {
        return valueWhenUnset;
    }

    /**
     * For responses, this returns true if the service returned a value for the MappedDataSetParameters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMappedDataSetParameters() {
        return mappedDataSetParameters != null && !(mappedDataSetParameters instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the MappedDataSetParameters property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMappedDataSetParameters} method.
     * </p>
     * 
     * @return The value of the MappedDataSetParameters property for this object.
     */
    public final List<MappedDataSetParameter> mappedDataSetParameters() {
        return mappedDataSetParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterValueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValues());
        hashCode = 31 * hashCode + Objects.hashCode(valueWhenUnset());
        hashCode = 31 * hashCode + Objects.hashCode(hasMappedDataSetParameters() ? mappedDataSetParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecimalParameterDeclaration)) {
            return false;
        }
        DecimalParameterDeclaration other = (DecimalParameterDeclaration) obj;
        return Objects.equals(parameterValueTypeAsString(), other.parameterValueTypeAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(defaultValues(), other.defaultValues())
                && Objects.equals(valueWhenUnset(), other.valueWhenUnset())
                && hasMappedDataSetParameters() == other.hasMappedDataSetParameters()
                && Objects.equals(mappedDataSetParameters(), other.mappedDataSetParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DecimalParameterDeclaration").add("ParameterValueType", parameterValueTypeAsString())
                .add("Name", name()).add("DefaultValues", defaultValues()).add("ValueWhenUnset", valueWhenUnset())
                .add("MappedDataSetParameters", hasMappedDataSetParameters() ? mappedDataSetParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterValueType":
            return Optional.ofNullable(clazz.cast(parameterValueTypeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DefaultValues":
            return Optional.ofNullable(clazz.cast(defaultValues()));
        case "ValueWhenUnset":
            return Optional.ofNullable(clazz.cast(valueWhenUnset()));
        case "MappedDataSetParameters":
            return Optional.ofNullable(clazz.cast(mappedDataSetParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParameterValueType", PARAMETER_VALUE_TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("DefaultValues", DEFAULT_VALUES_FIELD);
        map.put("ValueWhenUnset", VALUE_WHEN_UNSET_FIELD);
        map.put("MappedDataSetParameters", MAPPED_DATA_SET_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DecimalParameterDeclaration, T> g) {
        return obj -> g.apply((DecimalParameterDeclaration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DecimalParameterDeclaration> {
        /**
         * <p>
         * The value type determines whether the parameter is a single-value or multi-value parameter.
         * </p>
         * 
         * @param parameterValueType
         *        The value type determines whether the parameter is a single-value or multi-value parameter.
         * @see ParameterValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterValueType
         */
        Builder parameterValueType(String parameterValueType);

        /**
         * <p>
         * The value type determines whether the parameter is a single-value or multi-value parameter.
         * </p>
         * 
         * @param parameterValueType
         *        The value type determines whether the parameter is a single-value or multi-value parameter.
         * @see ParameterValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterValueType
         */
        Builder parameterValueType(ParameterValueType parameterValueType);

        /**
         * <p>
         * The name of the parameter that is being declared.
         * </p>
         * 
         * @param name
         *        The name of the parameter that is being declared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default
         * value can be provided.
         * </p>
         * 
         * @param defaultValues
         *        The default values of a parameter. If the parameter is a single-value parameter, a maximum of one
         *        default value can be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValues(DecimalDefaultValues defaultValues);

        /**
         * <p>
         * The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default
         * value can be provided.
         * </p>
         * This is a convenience method that creates an instance of the {@link DecimalDefaultValues.Builder} avoiding
         * the need to create one manually via {@link DecimalDefaultValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DecimalDefaultValues.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultValues(DecimalDefaultValues)}.
         * 
         * @param defaultValues
         *        a consumer that will call methods on {@link DecimalDefaultValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultValues(DecimalDefaultValues)
         */
        default Builder defaultValues(Consumer<DecimalDefaultValues.Builder> defaultValues) {
            return defaultValues(DecimalDefaultValues.builder().applyMutation(defaultValues).build());
        }

        /**
         * <p>
         * The configuration that defines the default value of a <code>Decimal</code> parameter when a value has not
         * been set.
         * </p>
         * 
         * @param valueWhenUnset
         *        The configuration that defines the default value of a <code>Decimal</code> parameter when a value has
         *        not been set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueWhenUnset(DecimalValueWhenUnsetConfiguration valueWhenUnset);

        /**
         * <p>
         * The configuration that defines the default value of a <code>Decimal</code> parameter when a value has not
         * been set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DecimalValueWhenUnsetConfiguration.Builder} avoiding the need to create one manually via
         * {@link DecimalValueWhenUnsetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DecimalValueWhenUnsetConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #valueWhenUnset(DecimalValueWhenUnsetConfiguration)}.
         * 
         * @param valueWhenUnset
         *        a consumer that will call methods on {@link DecimalValueWhenUnsetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueWhenUnset(DecimalValueWhenUnsetConfiguration)
         */
        default Builder valueWhenUnset(Consumer<DecimalValueWhenUnsetConfiguration.Builder> valueWhenUnset) {
            return valueWhenUnset(DecimalValueWhenUnsetConfiguration.builder().applyMutation(valueWhenUnset).build());
        }

        /**
         * Sets the value of the MappedDataSetParameters property for this object.
         *
         * @param mappedDataSetParameters
         *        The new value for the MappedDataSetParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappedDataSetParameters(Collection<MappedDataSetParameter> mappedDataSetParameters);

        /**
         * Sets the value of the MappedDataSetParameters property for this object.
         *
         * @param mappedDataSetParameters
         *        The new value for the MappedDataSetParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappedDataSetParameters(MappedDataSetParameter... mappedDataSetParameters);

        /**
         * Sets the value of the MappedDataSetParameters property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MappedDataSetParameter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.MappedDataSetParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MappedDataSetParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #mappedDataSetParameters(List<MappedDataSetParameter>)}.
         * 
         * @param mappedDataSetParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MappedDataSetParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mappedDataSetParameters(java.util.Collection<MappedDataSetParameter>)
         */
        Builder mappedDataSetParameters(Consumer<MappedDataSetParameter.Builder>... mappedDataSetParameters);
    }

    static final class BuilderImpl implements Builder {
        private String parameterValueType;

        private String name;

        private DecimalDefaultValues defaultValues;

        private DecimalValueWhenUnsetConfiguration valueWhenUnset;

        private List<MappedDataSetParameter> mappedDataSetParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DecimalParameterDeclaration model) {
            parameterValueType(model.parameterValueType);
            name(model.name);
            defaultValues(model.defaultValues);
            valueWhenUnset(model.valueWhenUnset);
            mappedDataSetParameters(model.mappedDataSetParameters);
        }

        public final String getParameterValueType() {
            return parameterValueType;
        }

        public final void setParameterValueType(String parameterValueType) {
            this.parameterValueType = parameterValueType;
        }

        @Override
        public final Builder parameterValueType(String parameterValueType) {
            this.parameterValueType = parameterValueType;
            return this;
        }

        @Override
        public final Builder parameterValueType(ParameterValueType parameterValueType) {
            this.parameterValueType(parameterValueType == null ? null : parameterValueType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DecimalDefaultValues.Builder getDefaultValues() {
            return defaultValues != null ? defaultValues.toBuilder() : null;
        }

        public final void setDefaultValues(DecimalDefaultValues.BuilderImpl defaultValues) {
            this.defaultValues = defaultValues != null ? defaultValues.build() : null;
        }

        @Override
        public final Builder defaultValues(DecimalDefaultValues defaultValues) {
            this.defaultValues = defaultValues;
            return this;
        }

        public final DecimalValueWhenUnsetConfiguration.Builder getValueWhenUnset() {
            return valueWhenUnset != null ? valueWhenUnset.toBuilder() : null;
        }

        public final void setValueWhenUnset(DecimalValueWhenUnsetConfiguration.BuilderImpl valueWhenUnset) {
            this.valueWhenUnset = valueWhenUnset != null ? valueWhenUnset.build() : null;
        }

        @Override
        public final Builder valueWhenUnset(DecimalValueWhenUnsetConfiguration valueWhenUnset) {
            this.valueWhenUnset = valueWhenUnset;
            return this;
        }

        public final List<MappedDataSetParameter.Builder> getMappedDataSetParameters() {
            List<MappedDataSetParameter.Builder> result = MappedDataSetParametersCopier
                    .copyToBuilder(this.mappedDataSetParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMappedDataSetParameters(Collection<MappedDataSetParameter.BuilderImpl> mappedDataSetParameters) {
            this.mappedDataSetParameters = MappedDataSetParametersCopier.copyFromBuilder(mappedDataSetParameters);
        }

        @Override
        public final Builder mappedDataSetParameters(Collection<MappedDataSetParameter> mappedDataSetParameters) {
            this.mappedDataSetParameters = MappedDataSetParametersCopier.copy(mappedDataSetParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedDataSetParameters(MappedDataSetParameter... mappedDataSetParameters) {
            mappedDataSetParameters(Arrays.asList(mappedDataSetParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedDataSetParameters(Consumer<MappedDataSetParameter.Builder>... mappedDataSetParameters) {
            mappedDataSetParameters(Stream.of(mappedDataSetParameters)
                    .map(c -> MappedDataSetParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DecimalParameterDeclaration build() {
            return new DecimalParameterDeclaration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
