/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFolderResponse extends QuickSightResponse implements
        ToCopyableBuilder<CreateFolderResponse.Builder, CreateFolderResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(CreateFolderResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateFolderResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FolderId").getter(getter(CreateFolderResponse::folderId)).setter(setter(Builder::folderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderId").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(CreateFolderResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ARN_FIELD,
            FOLDER_ID_FIELD, REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer status;

    private final String arn;

    private final String folderId;

    private final String requestId;

    private CreateFolderResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.arn = builder.arn;
        this.folderId = builder.folderId;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the newly created folder.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the newly created folder.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The folder ID for the newly created folder.
     * </p>
     * 
     * @return The folder ID for the newly created folder.
     */
    public final String folderId() {
        return folderId;
    }

    /**
     * <p>
     * The request ID for the newly created folder.
     * </p>
     * 
     * @return The request ID for the newly created folder.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(folderId());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFolderResponse)) {
            return false;
        }
        CreateFolderResponse other = (CreateFolderResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(arn(), other.arn())
                && Objects.equals(folderId(), other.folderId()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFolderResponse").add("Status", status()).add("Arn", arn()).add("FolderId", folderId())
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "FolderId":
            return Optional.ofNullable(clazz.cast(folderId()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("FolderId", FOLDER_ID_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFolderResponse, T> g) {
        return obj -> g.apply((CreateFolderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateFolderResponse> {
        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the newly created folder.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the newly created folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The folder ID for the newly created folder.
         * </p>
         * 
         * @param folderId
         *        The folder ID for the newly created folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderId(String folderId);

        /**
         * <p>
         * The request ID for the newly created folder.
         * </p>
         * 
         * @param requestId
         *        The request ID for the newly created folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private Integer status;

        private String arn;

        private String folderId;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFolderResponse model) {
            super(model);
            status(model.status);
            arn(model.arn);
            folderId(model.folderId);
            requestId(model.requestId);
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getFolderId() {
            return folderId;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public CreateFolderResponse build() {
            return new CreateFolderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
