/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the bin width of a histogram.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BinWidthOptions implements SdkPojo, Serializable, ToCopyableBuilder<BinWidthOptions.Builder, BinWidthOptions> {
    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Value")
            .getter(getter(BinWidthOptions::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Long> BIN_COUNT_LIMIT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BinCountLimit").getter(getter(BinWidthOptions::binCountLimit)).setter(setter(Builder::binCountLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinCountLimit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD,
            BIN_COUNT_LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double value;

    private final Long binCountLimit;

    private BinWidthOptions(BuilderImpl builder) {
        this.value = builder.value;
        this.binCountLimit = builder.binCountLimit;
    }

    /**
     * <p>
     * The options that determine the bin width value.
     * </p>
     * 
     * @return The options that determine the bin width value.
     */
    public final Double value() {
        return value;
    }

    /**
     * <p>
     * The options that determine the bin count limit.
     * </p>
     * 
     * @return The options that determine the bin count limit.
     */
    public final Long binCountLimit() {
        return binCountLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(binCountLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BinWidthOptions)) {
            return false;
        }
        BinWidthOptions other = (BinWidthOptions) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(binCountLimit(), other.binCountLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BinWidthOptions").add("Value", value()).add("BinCountLimit", binCountLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "BinCountLimit":
            return Optional.ofNullable(clazz.cast(binCountLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("BinCountLimit", BIN_COUNT_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BinWidthOptions, T> g) {
        return obj -> g.apply((BinWidthOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BinWidthOptions> {
        /**
         * <p>
         * The options that determine the bin width value.
         * </p>
         * 
         * @param value
         *        The options that determine the bin width value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);

        /**
         * <p>
         * The options that determine the bin count limit.
         * </p>
         * 
         * @param binCountLimit
         *        The options that determine the bin count limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binCountLimit(Long binCountLimit);
    }

    static final class BuilderImpl implements Builder {
        private Double value;

        private Long binCountLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(BinWidthOptions model) {
            value(model.value);
            binCountLimit(model.binCountLimit);
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final Long getBinCountLimit() {
            return binCountLimit;
        }

        public final void setBinCountLimit(Long binCountLimit) {
            this.binCountLimit = binCountLimit;
        }

        @Override
        public final Builder binCountLimit(Long binCountLimit) {
            this.binCountLimit = binCountLimit;
            return this;
        }

        @Override
        public BinWidthOptions build() {
            return new BinWidthOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
