/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The scale setup options for a numeric axis display.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AxisScale implements SdkPojo, Serializable, ToCopyableBuilder<AxisScale.Builder, AxisScale> {
    private static final SdkField<AxisLinearScale> LINEAR_FIELD = SdkField.<AxisLinearScale> builder(MarshallingType.SDK_POJO)
            .memberName("Linear").getter(getter(AxisScale::linear)).setter(setter(Builder::linear))
            .constructor(AxisLinearScale::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Linear").build()).build();

    private static final SdkField<AxisLogarithmicScale> LOGARITHMIC_FIELD = SdkField
            .<AxisLogarithmicScale> builder(MarshallingType.SDK_POJO).memberName("Logarithmic")
            .getter(getter(AxisScale::logarithmic)).setter(setter(Builder::logarithmic))
            .constructor(AxisLogarithmicScale::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logarithmic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINEAR_FIELD,
            LOGARITHMIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AxisLinearScale linear;

    private final AxisLogarithmicScale logarithmic;

    private AxisScale(BuilderImpl builder) {
        this.linear = builder.linear;
        this.logarithmic = builder.logarithmic;
    }

    /**
     * <p>
     * The linear axis scale setup.
     * </p>
     * 
     * @return The linear axis scale setup.
     */
    public final AxisLinearScale linear() {
        return linear;
    }

    /**
     * <p>
     * The logarithmic axis scale setup.
     * </p>
     * 
     * @return The logarithmic axis scale setup.
     */
    public final AxisLogarithmicScale logarithmic() {
        return logarithmic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(linear());
        hashCode = 31 * hashCode + Objects.hashCode(logarithmic());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AxisScale)) {
            return false;
        }
        AxisScale other = (AxisScale) obj;
        return Objects.equals(linear(), other.linear()) && Objects.equals(logarithmic(), other.logarithmic());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AxisScale").add("Linear", linear()).add("Logarithmic", logarithmic()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Linear":
            return Optional.ofNullable(clazz.cast(linear()));
        case "Logarithmic":
            return Optional.ofNullable(clazz.cast(logarithmic()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Linear", LINEAR_FIELD);
        map.put("Logarithmic", LOGARITHMIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AxisScale, T> g) {
        return obj -> g.apply((AxisScale) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AxisScale> {
        /**
         * <p>
         * The linear axis scale setup.
         * </p>
         * 
         * @param linear
         *        The linear axis scale setup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linear(AxisLinearScale linear);

        /**
         * <p>
         * The linear axis scale setup.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisLinearScale.Builder} avoiding the
         * need to create one manually via {@link AxisLinearScale#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisLinearScale.Builder#build()} is called immediately and its
         * result is passed to {@link #linear(AxisLinearScale)}.
         * 
         * @param linear
         *        a consumer that will call methods on {@link AxisLinearScale.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linear(AxisLinearScale)
         */
        default Builder linear(Consumer<AxisLinearScale.Builder> linear) {
            return linear(AxisLinearScale.builder().applyMutation(linear).build());
        }

        /**
         * <p>
         * The logarithmic axis scale setup.
         * </p>
         * 
         * @param logarithmic
         *        The logarithmic axis scale setup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logarithmic(AxisLogarithmicScale logarithmic);

        /**
         * <p>
         * The logarithmic axis scale setup.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisLogarithmicScale.Builder} avoiding
         * the need to create one manually via {@link AxisLogarithmicScale#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisLogarithmicScale.Builder#build()} is called immediately and
         * its result is passed to {@link #logarithmic(AxisLogarithmicScale)}.
         * 
         * @param logarithmic
         *        a consumer that will call methods on {@link AxisLogarithmicScale.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logarithmic(AxisLogarithmicScale)
         */
        default Builder logarithmic(Consumer<AxisLogarithmicScale.Builder> logarithmic) {
            return logarithmic(AxisLogarithmicScale.builder().applyMutation(logarithmic).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AxisLinearScale linear;

        private AxisLogarithmicScale logarithmic;

        private BuilderImpl() {
        }

        private BuilderImpl(AxisScale model) {
            linear(model.linear);
            logarithmic(model.logarithmic);
        }

        public final AxisLinearScale.Builder getLinear() {
            return linear != null ? linear.toBuilder() : null;
        }

        public final void setLinear(AxisLinearScale.BuilderImpl linear) {
            this.linear = linear != null ? linear.build() : null;
        }

        @Override
        public final Builder linear(AxisLinearScale linear) {
            this.linear = linear;
            return this;
        }

        public final AxisLogarithmicScale.Builder getLogarithmic() {
            return logarithmic != null ? logarithmic.toBuilder() : null;
        }

        public final void setLogarithmic(AxisLogarithmicScale.BuilderImpl logarithmic) {
            this.logarithmic = logarithmic != null ? logarithmic.build() : null;
        }

        @Override
        public final Builder logarithmic(AxisLogarithmicScale logarithmic) {
            this.logarithmic = logarithmic;
            return this;
        }

        @Override
        public AxisScale build() {
            return new AxisScale(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
