/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Controls how a specific <code>DataSource</code> resource is parameterized in the returned CloudFormation template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleExportJobDataSourceOverrideProperties
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AssetBundleExportJobDataSourceOverrideProperties.Builder, AssetBundleExportJobDataSourceOverrideProperties> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AssetBundleExportJobDataSourceOverrideProperties::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<List<String>> PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Properties")
            .getter(getter(AssetBundleExportJobDataSourceOverrideProperties::propertiesAsStrings))
            .setter(setter(Builder::propertiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<String> properties;

    private AssetBundleExportJobDataSourceOverrideProperties(BuilderImpl builder) {
        this.arn = builder.arn;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The ARN of the specific <code>DataSource</code> resource whose override properties are configured in this
     * structure.
     * </p>
     * 
     * @return The ARN of the specific <code>DataSource</code> resource whose override properties are configured in this
     *         structure.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A list of <code>DataSource</code> resource properties to generate variables for in the returned CloudFormation
     * template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return A list of <code>DataSource</code> resource properties to generate variables for in the returned
     *         CloudFormation template.
     */
    public final List<AssetBundleExportJobDataSourcePropertyToOverride> properties() {
        return AssetBundleExportJobDataSourcePropertyToOverrideListCopier.copyStringToEnum(properties);
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSource</code> resource properties to generate variables for in the returned CloudFormation
     * template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return A list of <code>DataSource</code> resource properties to generate variables for in the returned
     *         CloudFormation template.
     */
    public final List<String> propertiesAsStrings() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? propertiesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleExportJobDataSourceOverrideProperties)) {
            return false;
        }
        AssetBundleExportJobDataSourceOverrideProperties other = (AssetBundleExportJobDataSourceOverrideProperties) obj;
        return Objects.equals(arn(), other.arn()) && hasProperties() == other.hasProperties()
                && Objects.equals(propertiesAsStrings(), other.propertiesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleExportJobDataSourceOverrideProperties").add("Arn", arn())
                .add("Properties", hasProperties() ? propertiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(propertiesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleExportJobDataSourceOverrideProperties, T> g) {
        return obj -> g.apply((AssetBundleExportJobDataSourceOverrideProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleExportJobDataSourceOverrideProperties> {
        /**
         * <p>
         * The ARN of the specific <code>DataSource</code> resource whose override properties are configured in this
         * structure.
         * </p>
         * 
         * @param arn
         *        The ARN of the specific <code>DataSource</code> resource whose override properties are configured in
         *        this structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A list of <code>DataSource</code> resource properties to generate variables for in the returned
         * CloudFormation template.
         * </p>
         * 
         * @param properties
         *        A list of <code>DataSource</code> resource properties to generate variables for in the returned
         *        CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesWithStrings(Collection<String> properties);

        /**
         * <p>
         * A list of <code>DataSource</code> resource properties to generate variables for in the returned
         * CloudFormation template.
         * </p>
         * 
         * @param properties
         *        A list of <code>DataSource</code> resource properties to generate variables for in the returned
         *        CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesWithStrings(String... properties);

        /**
         * <p>
         * A list of <code>DataSource</code> resource properties to generate variables for in the returned
         * CloudFormation template.
         * </p>
         * 
         * @param properties
         *        A list of <code>DataSource</code> resource properties to generate variables for in the returned
         *        CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Collection<AssetBundleExportJobDataSourcePropertyToOverride> properties);

        /**
         * <p>
         * A list of <code>DataSource</code> resource properties to generate variables for in the returned
         * CloudFormation template.
         * </p>
         * 
         * @param properties
         *        A list of <code>DataSource</code> resource properties to generate variables for in the returned
         *        CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(AssetBundleExportJobDataSourcePropertyToOverride... properties);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<String> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleExportJobDataSourceOverrideProperties model) {
            arn(model.arn);
            propertiesWithStrings(model.properties);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getProperties() {
            if (properties instanceof SdkAutoConstructList) {
                return null;
            }
            return properties;
        }

        public final void setProperties(Collection<String> properties) {
            this.properties = AssetBundleExportJobDataSourcePropertyToOverrideListCopier.copy(properties);
        }

        @Override
        public final Builder propertiesWithStrings(Collection<String> properties) {
            this.properties = AssetBundleExportJobDataSourcePropertyToOverrideListCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertiesWithStrings(String... properties) {
            propertiesWithStrings(Arrays.asList(properties));
            return this;
        }

        @Override
        public final Builder properties(Collection<AssetBundleExportJobDataSourcePropertyToOverride> properties) {
            this.properties = AssetBundleExportJobDataSourcePropertyToOverrideListCopier.copyEnumToString(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(AssetBundleExportJobDataSourcePropertyToOverride... properties) {
            properties(Arrays.asList(properties));
            return this;
        }

        @Override
        public AssetBundleExportJobDataSourceOverrideProperties build() {
            return new AssetBundleExportJobDataSourceOverrideProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
