/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.NumericSeparatorSymbol;
import software.amazon.awssdk.services.quicksight.model.ThousandSeparatorOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NumericSeparatorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NumericSeparatorConfiguration> {
    private static final SdkField<String> DECIMAL_SEPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DecimalSeparator").getter(NumericSeparatorConfiguration.getter(NumericSeparatorConfiguration::decimalSeparatorAsString)).setter(NumericSeparatorConfiguration.setter(Builder::decimalSeparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalSeparator").build()}).build();
    private static final SdkField<ThousandSeparatorOptions> THOUSANDS_SEPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThousandsSeparator").getter(NumericSeparatorConfiguration.getter(NumericSeparatorConfiguration::thousandsSeparator)).setter(NumericSeparatorConfiguration.setter(Builder::thousandsSeparator)).constructor(ThousandSeparatorOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThousandsSeparator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECIMAL_SEPARATOR_FIELD, THOUSANDS_SEPARATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NumericSeparatorConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String decimalSeparator;
    private final ThousandSeparatorOptions thousandsSeparator;

    private NumericSeparatorConfiguration(BuilderImpl builder) {
        this.decimalSeparator = builder.decimalSeparator;
        this.thousandsSeparator = builder.thousandsSeparator;
    }

    public final NumericSeparatorSymbol decimalSeparator() {
        return NumericSeparatorSymbol.fromValue(this.decimalSeparator);
    }

    public final String decimalSeparatorAsString() {
        return this.decimalSeparator;
    }

    public final ThousandSeparatorOptions thousandsSeparator() {
        return this.thousandsSeparator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.decimalSeparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.thousandsSeparator());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericSeparatorConfiguration)) {
            return false;
        }
        NumericSeparatorConfiguration other = (NumericSeparatorConfiguration)obj;
        return Objects.equals(this.decimalSeparatorAsString(), other.decimalSeparatorAsString()) && Objects.equals(this.thousandsSeparator(), other.thousandsSeparator());
    }

    public final String toString() {
        return ToString.builder((String)"NumericSeparatorConfiguration").add("DecimalSeparator", (Object)this.decimalSeparatorAsString()).add("ThousandsSeparator", (Object)this.thousandsSeparator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DecimalSeparator": {
                return Optional.ofNullable(clazz.cast(this.decimalSeparatorAsString()));
            }
            case "ThousandsSeparator": {
                return Optional.ofNullable(clazz.cast(this.thousandsSeparator()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DecimalSeparator", DECIMAL_SEPARATOR_FIELD);
        map.put("ThousandsSeparator", THOUSANDS_SEPARATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NumericSeparatorConfiguration, T> g) {
        return obj -> g.apply((NumericSeparatorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String decimalSeparator;
        private ThousandSeparatorOptions thousandsSeparator;

        private BuilderImpl() {
        }

        private BuilderImpl(NumericSeparatorConfiguration model) {
            this.decimalSeparator(model.decimalSeparator);
            this.thousandsSeparator(model.thousandsSeparator);
        }

        public final String getDecimalSeparator() {
            return this.decimalSeparator;
        }

        public final void setDecimalSeparator(String decimalSeparator) {
            this.decimalSeparator = decimalSeparator;
        }

        @Override
        public final Builder decimalSeparator(String decimalSeparator) {
            this.decimalSeparator = decimalSeparator;
            return this;
        }

        @Override
        public final Builder decimalSeparator(NumericSeparatorSymbol decimalSeparator) {
            this.decimalSeparator(decimalSeparator == null ? null : decimalSeparator.toString());
            return this;
        }

        public final ThousandSeparatorOptions.Builder getThousandsSeparator() {
            return this.thousandsSeparator != null ? this.thousandsSeparator.toBuilder() : null;
        }

        public final void setThousandsSeparator(ThousandSeparatorOptions.BuilderImpl thousandsSeparator) {
            this.thousandsSeparator = thousandsSeparator != null ? thousandsSeparator.build() : null;
        }

        @Override
        public final Builder thousandsSeparator(ThousandSeparatorOptions thousandsSeparator) {
            this.thousandsSeparator = thousandsSeparator;
            return this;
        }

        public NumericSeparatorConfiguration build() {
            return new NumericSeparatorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NumericSeparatorConfiguration> {
        public Builder decimalSeparator(String var1);

        public Builder decimalSeparator(NumericSeparatorSymbol var1);

        public Builder thousandsSeparator(ThousandSeparatorOptions var1);

        default public Builder thousandsSeparator(Consumer<ThousandSeparatorOptions.Builder> thousandsSeparator) {
            return this.thousandsSeparator((ThousandSeparatorOptions)((ThousandSeparatorOptions.Builder)ThousandSeparatorOptions.builder().applyMutation(thousandsSeparator)).build());
        }
    }
}

