/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ForecastComputation;
import software.amazon.awssdk.services.quicksight.model.GrowthRateComputation;
import software.amazon.awssdk.services.quicksight.model.MaximumMinimumComputation;
import software.amazon.awssdk.services.quicksight.model.MetricComparisonComputation;
import software.amazon.awssdk.services.quicksight.model.PeriodOverPeriodComputation;
import software.amazon.awssdk.services.quicksight.model.PeriodToDateComputation;
import software.amazon.awssdk.services.quicksight.model.TopBottomMoversComputation;
import software.amazon.awssdk.services.quicksight.model.TopBottomRankedComputation;
import software.amazon.awssdk.services.quicksight.model.TotalAggregationComputation;
import software.amazon.awssdk.services.quicksight.model.UniqueValuesComputation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Computation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Computation> {
    private static final SdkField<TopBottomRankedComputation> TOP_BOTTOM_RANKED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TopBottomRanked").getter(Computation.getter(Computation::topBottomRanked)).setter(Computation.setter(Builder::topBottomRanked)).constructor(TopBottomRankedComputation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopBottomRanked").build()}).build();
    private static final SdkField<TopBottomMoversComputation> TOP_BOTTOM_MOVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TopBottomMovers").getter(Computation.getter(Computation::topBottomMovers)).setter(Computation.setter(Builder::topBottomMovers)).constructor(TopBottomMoversComputation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopBottomMovers").build()}).build();
    private static final SdkField<TotalAggregationComputation> TOTAL_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TotalAggregation").getter(Computation.getter(Computation::totalAggregation)).setter(Computation.setter(Builder::totalAggregation)).constructor(TotalAggregationComputation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAggregation").build()}).build();
    private static final SdkField<MaximumMinimumComputation> MAXIMUM_MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaximumMinimum").getter(Computation.getter(Computation::maximumMinimum)).setter(Computation.setter(Builder::maximumMinimum)).constructor(MaximumMinimumComputation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumMinimum").build()}).build();
    private static final SdkField<MetricComparisonComputation> METRIC_COMPARISON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricComparison").getter(Computation.getter(Computation::metricComparison)).setter(Computation.setter(Builder::metricComparison)).constructor(MetricComparisonComputation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricComparison").build()}).build();
    private static final SdkField<PeriodOverPeriodComputation> PERIOD_OVER_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PeriodOverPeriod").getter(Computation.getter(Computation::periodOverPeriod)).setter(Computation.setter(Builder::periodOverPeriod)).constructor(PeriodOverPeriodComputation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodOverPeriod").build()}).build();
    private static final SdkField<PeriodToDateComputation> PERIOD_TO_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PeriodToDate").getter(Computation.getter(Computation::periodToDate)).setter(Computation.setter(Builder::periodToDate)).constructor(PeriodToDateComputation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodToDate").build()}).build();
    private static final SdkField<GrowthRateComputation> GROWTH_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GrowthRate").getter(Computation.getter(Computation::growthRate)).setter(Computation.setter(Builder::growthRate)).constructor(GrowthRateComputation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthRate").build()}).build();
    private static final SdkField<UniqueValuesComputation> UNIQUE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UniqueValues").getter(Computation.getter(Computation::uniqueValues)).setter(Computation.setter(Builder::uniqueValues)).constructor(UniqueValuesComputation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueValues").build()}).build();
    private static final SdkField<ForecastComputation> FORECAST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Forecast").getter(Computation.getter(Computation::forecast)).setter(Computation.setter(Builder::forecast)).constructor(ForecastComputation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Forecast").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOP_BOTTOM_RANKED_FIELD, TOP_BOTTOM_MOVERS_FIELD, TOTAL_AGGREGATION_FIELD, MAXIMUM_MINIMUM_FIELD, METRIC_COMPARISON_FIELD, PERIOD_OVER_PERIOD_FIELD, PERIOD_TO_DATE_FIELD, GROWTH_RATE_FIELD, UNIQUE_VALUES_FIELD, FORECAST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Computation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TopBottomRankedComputation topBottomRanked;
    private final TopBottomMoversComputation topBottomMovers;
    private final TotalAggregationComputation totalAggregation;
    private final MaximumMinimumComputation maximumMinimum;
    private final MetricComparisonComputation metricComparison;
    private final PeriodOverPeriodComputation periodOverPeriod;
    private final PeriodToDateComputation periodToDate;
    private final GrowthRateComputation growthRate;
    private final UniqueValuesComputation uniqueValues;
    private final ForecastComputation forecast;

    private Computation(BuilderImpl builder) {
        this.topBottomRanked = builder.topBottomRanked;
        this.topBottomMovers = builder.topBottomMovers;
        this.totalAggregation = builder.totalAggregation;
        this.maximumMinimum = builder.maximumMinimum;
        this.metricComparison = builder.metricComparison;
        this.periodOverPeriod = builder.periodOverPeriod;
        this.periodToDate = builder.periodToDate;
        this.growthRate = builder.growthRate;
        this.uniqueValues = builder.uniqueValues;
        this.forecast = builder.forecast;
    }

    public final TopBottomRankedComputation topBottomRanked() {
        return this.topBottomRanked;
    }

    public final TopBottomMoversComputation topBottomMovers() {
        return this.topBottomMovers;
    }

    public final TotalAggregationComputation totalAggregation() {
        return this.totalAggregation;
    }

    public final MaximumMinimumComputation maximumMinimum() {
        return this.maximumMinimum;
    }

    public final MetricComparisonComputation metricComparison() {
        return this.metricComparison;
    }

    public final PeriodOverPeriodComputation periodOverPeriod() {
        return this.periodOverPeriod;
    }

    public final PeriodToDateComputation periodToDate() {
        return this.periodToDate;
    }

    public final GrowthRateComputation growthRate() {
        return this.growthRate;
    }

    public final UniqueValuesComputation uniqueValues() {
        return this.uniqueValues;
    }

    public final ForecastComputation forecast() {
        return this.forecast;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topBottomRanked());
        hashCode = 31 * hashCode + Objects.hashCode(this.topBottomMovers());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumMinimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricComparison());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodOverPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodToDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.growthRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecast());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Computation)) {
            return false;
        }
        Computation other = (Computation)obj;
        return Objects.equals(this.topBottomRanked(), other.topBottomRanked()) && Objects.equals(this.topBottomMovers(), other.topBottomMovers()) && Objects.equals(this.totalAggregation(), other.totalAggregation()) && Objects.equals(this.maximumMinimum(), other.maximumMinimum()) && Objects.equals(this.metricComparison(), other.metricComparison()) && Objects.equals(this.periodOverPeriod(), other.periodOverPeriod()) && Objects.equals(this.periodToDate(), other.periodToDate()) && Objects.equals(this.growthRate(), other.growthRate()) && Objects.equals(this.uniqueValues(), other.uniqueValues()) && Objects.equals(this.forecast(), other.forecast());
    }

    public final String toString() {
        return ToString.builder((String)"Computation").add("TopBottomRanked", (Object)this.topBottomRanked()).add("TopBottomMovers", (Object)this.topBottomMovers()).add("TotalAggregation", (Object)this.totalAggregation()).add("MaximumMinimum", (Object)this.maximumMinimum()).add("MetricComparison", (Object)this.metricComparison()).add("PeriodOverPeriod", (Object)this.periodOverPeriod()).add("PeriodToDate", (Object)this.periodToDate()).add("GrowthRate", (Object)this.growthRate()).add("UniqueValues", (Object)this.uniqueValues()).add("Forecast", (Object)this.forecast()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopBottomRanked": {
                return Optional.ofNullable(clazz.cast(this.topBottomRanked()));
            }
            case "TopBottomMovers": {
                return Optional.ofNullable(clazz.cast(this.topBottomMovers()));
            }
            case "TotalAggregation": {
                return Optional.ofNullable(clazz.cast(this.totalAggregation()));
            }
            case "MaximumMinimum": {
                return Optional.ofNullable(clazz.cast(this.maximumMinimum()));
            }
            case "MetricComparison": {
                return Optional.ofNullable(clazz.cast(this.metricComparison()));
            }
            case "PeriodOverPeriod": {
                return Optional.ofNullable(clazz.cast(this.periodOverPeriod()));
            }
            case "PeriodToDate": {
                return Optional.ofNullable(clazz.cast(this.periodToDate()));
            }
            case "GrowthRate": {
                return Optional.ofNullable(clazz.cast(this.growthRate()));
            }
            case "UniqueValues": {
                return Optional.ofNullable(clazz.cast(this.uniqueValues()));
            }
            case "Forecast": {
                return Optional.ofNullable(clazz.cast(this.forecast()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TopBottomRanked", TOP_BOTTOM_RANKED_FIELD);
        map.put("TopBottomMovers", TOP_BOTTOM_MOVERS_FIELD);
        map.put("TotalAggregation", TOTAL_AGGREGATION_FIELD);
        map.put("MaximumMinimum", MAXIMUM_MINIMUM_FIELD);
        map.put("MetricComparison", METRIC_COMPARISON_FIELD);
        map.put("PeriodOverPeriod", PERIOD_OVER_PERIOD_FIELD);
        map.put("PeriodToDate", PERIOD_TO_DATE_FIELD);
        map.put("GrowthRate", GROWTH_RATE_FIELD);
        map.put("UniqueValues", UNIQUE_VALUES_FIELD);
        map.put("Forecast", FORECAST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Computation, T> g) {
        return obj -> g.apply((Computation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TopBottomRankedComputation topBottomRanked;
        private TopBottomMoversComputation topBottomMovers;
        private TotalAggregationComputation totalAggregation;
        private MaximumMinimumComputation maximumMinimum;
        private MetricComparisonComputation metricComparison;
        private PeriodOverPeriodComputation periodOverPeriod;
        private PeriodToDateComputation periodToDate;
        private GrowthRateComputation growthRate;
        private UniqueValuesComputation uniqueValues;
        private ForecastComputation forecast;

        private BuilderImpl() {
        }

        private BuilderImpl(Computation model) {
            this.topBottomRanked(model.topBottomRanked);
            this.topBottomMovers(model.topBottomMovers);
            this.totalAggregation(model.totalAggregation);
            this.maximumMinimum(model.maximumMinimum);
            this.metricComparison(model.metricComparison);
            this.periodOverPeriod(model.periodOverPeriod);
            this.periodToDate(model.periodToDate);
            this.growthRate(model.growthRate);
            this.uniqueValues(model.uniqueValues);
            this.forecast(model.forecast);
        }

        public final TopBottomRankedComputation.Builder getTopBottomRanked() {
            return this.topBottomRanked != null ? this.topBottomRanked.toBuilder() : null;
        }

        public final void setTopBottomRanked(TopBottomRankedComputation.BuilderImpl topBottomRanked) {
            this.topBottomRanked = topBottomRanked != null ? topBottomRanked.build() : null;
        }

        @Override
        public final Builder topBottomRanked(TopBottomRankedComputation topBottomRanked) {
            this.topBottomRanked = topBottomRanked;
            return this;
        }

        public final TopBottomMoversComputation.Builder getTopBottomMovers() {
            return this.topBottomMovers != null ? this.topBottomMovers.toBuilder() : null;
        }

        public final void setTopBottomMovers(TopBottomMoversComputation.BuilderImpl topBottomMovers) {
            this.topBottomMovers = topBottomMovers != null ? topBottomMovers.build() : null;
        }

        @Override
        public final Builder topBottomMovers(TopBottomMoversComputation topBottomMovers) {
            this.topBottomMovers = topBottomMovers;
            return this;
        }

        public final TotalAggregationComputation.Builder getTotalAggregation() {
            return this.totalAggregation != null ? this.totalAggregation.toBuilder() : null;
        }

        public final void setTotalAggregation(TotalAggregationComputation.BuilderImpl totalAggregation) {
            this.totalAggregation = totalAggregation != null ? totalAggregation.build() : null;
        }

        @Override
        public final Builder totalAggregation(TotalAggregationComputation totalAggregation) {
            this.totalAggregation = totalAggregation;
            return this;
        }

        public final MaximumMinimumComputation.Builder getMaximumMinimum() {
            return this.maximumMinimum != null ? this.maximumMinimum.toBuilder() : null;
        }

        public final void setMaximumMinimum(MaximumMinimumComputation.BuilderImpl maximumMinimum) {
            this.maximumMinimum = maximumMinimum != null ? maximumMinimum.build() : null;
        }

        @Override
        public final Builder maximumMinimum(MaximumMinimumComputation maximumMinimum) {
            this.maximumMinimum = maximumMinimum;
            return this;
        }

        public final MetricComparisonComputation.Builder getMetricComparison() {
            return this.metricComparison != null ? this.metricComparison.toBuilder() : null;
        }

        public final void setMetricComparison(MetricComparisonComputation.BuilderImpl metricComparison) {
            this.metricComparison = metricComparison != null ? metricComparison.build() : null;
        }

        @Override
        public final Builder metricComparison(MetricComparisonComputation metricComparison) {
            this.metricComparison = metricComparison;
            return this;
        }

        public final PeriodOverPeriodComputation.Builder getPeriodOverPeriod() {
            return this.periodOverPeriod != null ? this.periodOverPeriod.toBuilder() : null;
        }

        public final void setPeriodOverPeriod(PeriodOverPeriodComputation.BuilderImpl periodOverPeriod) {
            this.periodOverPeriod = periodOverPeriod != null ? periodOverPeriod.build() : null;
        }

        @Override
        public final Builder periodOverPeriod(PeriodOverPeriodComputation periodOverPeriod) {
            this.periodOverPeriod = periodOverPeriod;
            return this;
        }

        public final PeriodToDateComputation.Builder getPeriodToDate() {
            return this.periodToDate != null ? this.periodToDate.toBuilder() : null;
        }

        public final void setPeriodToDate(PeriodToDateComputation.BuilderImpl periodToDate) {
            this.periodToDate = periodToDate != null ? periodToDate.build() : null;
        }

        @Override
        public final Builder periodToDate(PeriodToDateComputation periodToDate) {
            this.periodToDate = periodToDate;
            return this;
        }

        public final GrowthRateComputation.Builder getGrowthRate() {
            return this.growthRate != null ? this.growthRate.toBuilder() : null;
        }

        public final void setGrowthRate(GrowthRateComputation.BuilderImpl growthRate) {
            this.growthRate = growthRate != null ? growthRate.build() : null;
        }

        @Override
        public final Builder growthRate(GrowthRateComputation growthRate) {
            this.growthRate = growthRate;
            return this;
        }

        public final UniqueValuesComputation.Builder getUniqueValues() {
            return this.uniqueValues != null ? this.uniqueValues.toBuilder() : null;
        }

        public final void setUniqueValues(UniqueValuesComputation.BuilderImpl uniqueValues) {
            this.uniqueValues = uniqueValues != null ? uniqueValues.build() : null;
        }

        @Override
        public final Builder uniqueValues(UniqueValuesComputation uniqueValues) {
            this.uniqueValues = uniqueValues;
            return this;
        }

        public final ForecastComputation.Builder getForecast() {
            return this.forecast != null ? this.forecast.toBuilder() : null;
        }

        public final void setForecast(ForecastComputation.BuilderImpl forecast) {
            this.forecast = forecast != null ? forecast.build() : null;
        }

        @Override
        public final Builder forecast(ForecastComputation forecast) {
            this.forecast = forecast;
            return this;
        }

        public Computation build() {
            return new Computation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Computation> {
        public Builder topBottomRanked(TopBottomRankedComputation var1);

        default public Builder topBottomRanked(Consumer<TopBottomRankedComputation.Builder> topBottomRanked) {
            return this.topBottomRanked((TopBottomRankedComputation)((TopBottomRankedComputation.Builder)TopBottomRankedComputation.builder().applyMutation(topBottomRanked)).build());
        }

        public Builder topBottomMovers(TopBottomMoversComputation var1);

        default public Builder topBottomMovers(Consumer<TopBottomMoversComputation.Builder> topBottomMovers) {
            return this.topBottomMovers((TopBottomMoversComputation)((TopBottomMoversComputation.Builder)TopBottomMoversComputation.builder().applyMutation(topBottomMovers)).build());
        }

        public Builder totalAggregation(TotalAggregationComputation var1);

        default public Builder totalAggregation(Consumer<TotalAggregationComputation.Builder> totalAggregation) {
            return this.totalAggregation((TotalAggregationComputation)((TotalAggregationComputation.Builder)TotalAggregationComputation.builder().applyMutation(totalAggregation)).build());
        }

        public Builder maximumMinimum(MaximumMinimumComputation var1);

        default public Builder maximumMinimum(Consumer<MaximumMinimumComputation.Builder> maximumMinimum) {
            return this.maximumMinimum((MaximumMinimumComputation)((MaximumMinimumComputation.Builder)MaximumMinimumComputation.builder().applyMutation(maximumMinimum)).build());
        }

        public Builder metricComparison(MetricComparisonComputation var1);

        default public Builder metricComparison(Consumer<MetricComparisonComputation.Builder> metricComparison) {
            return this.metricComparison((MetricComparisonComputation)((MetricComparisonComputation.Builder)MetricComparisonComputation.builder().applyMutation(metricComparison)).build());
        }

        public Builder periodOverPeriod(PeriodOverPeriodComputation var1);

        default public Builder periodOverPeriod(Consumer<PeriodOverPeriodComputation.Builder> periodOverPeriod) {
            return this.periodOverPeriod((PeriodOverPeriodComputation)((PeriodOverPeriodComputation.Builder)PeriodOverPeriodComputation.builder().applyMutation(periodOverPeriod)).build());
        }

        public Builder periodToDate(PeriodToDateComputation var1);

        default public Builder periodToDate(Consumer<PeriodToDateComputation.Builder> periodToDate) {
            return this.periodToDate((PeriodToDateComputation)((PeriodToDateComputation.Builder)PeriodToDateComputation.builder().applyMutation(periodToDate)).build());
        }

        public Builder growthRate(GrowthRateComputation var1);

        default public Builder growthRate(Consumer<GrowthRateComputation.Builder> growthRate) {
            return this.growthRate((GrowthRateComputation)((GrowthRateComputation.Builder)GrowthRateComputation.builder().applyMutation(growthRate)).build());
        }

        public Builder uniqueValues(UniqueValuesComputation var1);

        default public Builder uniqueValues(Consumer<UniqueValuesComputation.Builder> uniqueValues) {
            return this.uniqueValues((UniqueValuesComputation)((UniqueValuesComputation.Builder)UniqueValuesComputation.builder().applyMutation(uniqueValues)).build());
        }

        public Builder forecast(ForecastComputation var1);

        default public Builder forecast(Consumer<ForecastComputation.Builder> forecast) {
            return this.forecast((ForecastComputation)((ForecastComputation.Builder)ForecastComputation.builder().applyMutation(forecast)).build());
        }
    }
}

