/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.NetworkInterface;
import software.amazon.awssdk.services.quicksight.model.NetworkInterfaceListCopier;
import software.amazon.awssdk.services.quicksight.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.quicksight.model.StringListCopier;
import software.amazon.awssdk.services.quicksight.model.VPCConnectionAvailabilityStatus;
import software.amazon.awssdk.services.quicksight.model.VPCConnectionResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VPCConnectionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VPCConnectionSummary> {
    private static final SdkField<String> VPC_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCConnectionId").getter(VPCConnectionSummary.getter(VPCConnectionSummary::vpcConnectionId)).setter(VPCConnectionSummary.setter(Builder::vpcConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCConnectionId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(VPCConnectionSummary.getter(VPCConnectionSummary::arn)).setter(VPCConnectionSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(VPCConnectionSummary.getter(VPCConnectionSummary::name)).setter(VPCConnectionSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCId").getter(VPCConnectionSummary.getter(VPCConnectionSummary::vpcId)).setter(VPCConnectionSummary.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCId").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(VPCConnectionSummary.getter(VPCConnectionSummary::securityGroupIds)).setter(VPCConnectionSummary.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DNS_RESOLVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsResolvers").getter(VPCConnectionSummary.getter(VPCConnectionSummary::dnsResolvers)).setter(VPCConnectionSummary.setter(Builder::dnsResolvers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsResolvers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(VPCConnectionSummary.getter(VPCConnectionSummary::statusAsString)).setter(VPCConnectionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> AVAILABILITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityStatus").getter(VPCConnectionSummary.getter(VPCConnectionSummary::availabilityStatusAsString)).setter(VPCConnectionSummary.setter(Builder::availabilityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityStatus").build()}).build();
    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaces").getter(VPCConnectionSummary.getter(VPCConnectionSummary::networkInterfaces)).setter(VPCConnectionSummary.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(VPCConnectionSummary.getter(VPCConnectionSummary::roleArn)).setter(VPCConnectionSummary.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(VPCConnectionSummary.getter(VPCConnectionSummary::createdTime)).setter(VPCConnectionSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(VPCConnectionSummary.getter(VPCConnectionSummary::lastUpdatedTime)).setter(VPCConnectionSummary.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTION_ID_FIELD, ARN_FIELD, NAME_FIELD, VPC_ID_FIELD, SECURITY_GROUP_IDS_FIELD, DNS_RESOLVERS_FIELD, STATUS_FIELD, AVAILABILITY_STATUS_FIELD, NETWORK_INTERFACES_FIELD, ROLE_ARN_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VPCConnectionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String vpcConnectionId;
    private final String arn;
    private final String name;
    private final String vpcId;
    private final List<String> securityGroupIds;
    private final List<String> dnsResolvers;
    private final String status;
    private final String availabilityStatus;
    private final List<NetworkInterface> networkInterfaces;
    private final String roleArn;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;

    private VPCConnectionSummary(BuilderImpl builder) {
        this.vpcConnectionId = builder.vpcConnectionId;
        this.arn = builder.arn;
        this.name = builder.name;
        this.vpcId = builder.vpcId;
        this.securityGroupIds = builder.securityGroupIds;
        this.dnsResolvers = builder.dnsResolvers;
        this.status = builder.status;
        this.availabilityStatus = builder.availabilityStatus;
        this.networkInterfaces = builder.networkInterfaces;
        this.roleArn = builder.roleArn;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final String vpcConnectionId() {
        return this.vpcConnectionId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasDnsResolvers() {
        return this.dnsResolvers != null && !(this.dnsResolvers instanceof SdkAutoConstructList);
    }

    public final List<String> dnsResolvers() {
        return this.dnsResolvers;
    }

    public final VPCConnectionResourceStatus status() {
        return VPCConnectionResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final VPCConnectionAvailabilityStatus availabilityStatus() {
        return VPCConnectionAvailabilityStatus.fromValue(this.availabilityStatus);
    }

    public final String availabilityStatusAsString() {
        return this.availabilityStatus;
    }

    public final boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<NetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsResolvers() ? this.dnsResolvers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaces() ? this.networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VPCConnectionSummary)) {
            return false;
        }
        VPCConnectionSummary other = (VPCConnectionSummary)obj;
        return Objects.equals(this.vpcConnectionId(), other.vpcConnectionId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasDnsResolvers() == other.hasDnsResolvers() && Objects.equals(this.dnsResolvers(), other.dnsResolvers()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.availabilityStatusAsString(), other.availabilityStatusAsString()) && this.hasNetworkInterfaces() == other.hasNetworkInterfaces() && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"VPCConnectionSummary").add("VPCConnectionId", (Object)this.vpcConnectionId()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("VPCId", (Object)this.vpcId()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("DnsResolvers", this.hasDnsResolvers() ? this.dnsResolvers() : null).add("Status", (Object)this.statusAsString()).add("AvailabilityStatus", (Object)this.availabilityStatusAsString()).add("NetworkInterfaces", this.hasNetworkInterfaces() ? this.networkInterfaces() : null).add("RoleArn", (Object)this.roleArn()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VPCConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "VPCId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "DnsResolvers": {
                return Optional.ofNullable(clazz.cast(this.dnsResolvers()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AvailabilityStatus": {
                return Optional.ofNullable(clazz.cast(this.availabilityStatusAsString()));
            }
            case "NetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VPCConnectionId", VPC_CONNECTION_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("VPCId", VPC_ID_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("DnsResolvers", DNS_RESOLVERS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AvailabilityStatus", AVAILABILITY_STATUS_FIELD);
        map.put("NetworkInterfaces", NETWORK_INTERFACES_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VPCConnectionSummary, T> g) {
        return obj -> g.apply((VPCConnectionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcConnectionId;
        private String arn;
        private String name;
        private String vpcId;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> dnsResolvers = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String availabilityStatus;
        private List<NetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private Instant createdTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VPCConnectionSummary model) {
            this.vpcConnectionId(model.vpcConnectionId);
            this.arn(model.arn);
            this.name(model.name);
            this.vpcId(model.vpcId);
            this.securityGroupIds(model.securityGroupIds);
            this.dnsResolvers(model.dnsResolvers);
            this.status(model.status);
            this.availabilityStatus(model.availabilityStatus);
            this.networkInterfaces(model.networkInterfaces);
            this.roleArn(model.roleArn);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getVpcConnectionId() {
            return this.vpcConnectionId;
        }

        public final void setVpcConnectionId(String vpcConnectionId) {
            this.vpcConnectionId = vpcConnectionId;
        }

        @Override
        public final Builder vpcConnectionId(String vpcConnectionId) {
            this.vpcConnectionId = vpcConnectionId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getDnsResolvers() {
            if (this.dnsResolvers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsResolvers;
        }

        public final void setDnsResolvers(Collection<String> dnsResolvers) {
            this.dnsResolvers = StringListCopier.copy(dnsResolvers);
        }

        @Override
        public final Builder dnsResolvers(Collection<String> dnsResolvers) {
            this.dnsResolvers = StringListCopier.copy(dnsResolvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsResolvers(String ... dnsResolvers) {
            this.dnsResolvers(Arrays.asList(dnsResolvers));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VPCConnectionResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAvailabilityStatus() {
            return this.availabilityStatus;
        }

        public final void setAvailabilityStatus(String availabilityStatus) {
            this.availabilityStatus = availabilityStatus;
        }

        @Override
        public final Builder availabilityStatus(String availabilityStatus) {
            this.availabilityStatus = availabilityStatus;
            return this;
        }

        @Override
        public final Builder availabilityStatus(VPCConnectionAvailabilityStatus availabilityStatus) {
            this.availabilityStatus(availabilityStatus == null ? null : availabilityStatus.toString());
            return this;
        }

        public final List<NetworkInterface.Builder> getNetworkInterfaces() {
            List<NetworkInterface.Builder> result = NetworkInterfaceListCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfaceListCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfaceListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(NetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public VPCConnectionSummary build() {
            return new VPCConnectionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VPCConnectionSummary> {
        public Builder vpcConnectionId(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder vpcId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder dnsResolvers(Collection<String> var1);

        public Builder dnsResolvers(String ... var1);

        public Builder status(String var1);

        public Builder status(VPCConnectionResourceStatus var1);

        public Builder availabilityStatus(String var1);

        public Builder availabilityStatus(VPCConnectionAvailabilityStatus var1);

        public Builder networkInterfaces(Collection<NetworkInterface> var1);

        public Builder networkInterfaces(NetworkInterface ... var1);

        public Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

