/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.IpRestrictionRuleMapCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.VpcEndpointIdRestrictionRuleMapCopier;
import software.amazon.awssdk.services.quicksight.model.VpcIdRestrictionRuleMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIpRestrictionResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeIpRestrictionResponse> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(DescribeIpRestrictionResponse.getter(DescribeIpRestrictionResponse::awsAccountId)).setter(DescribeIpRestrictionResponse.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()}).build();
    private static final SdkField<Map<String, String>> IP_RESTRICTION_RULE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("IpRestrictionRuleMap").getter(DescribeIpRestrictionResponse.getter(DescribeIpRestrictionResponse::ipRestrictionRuleMap)).setter(DescribeIpRestrictionResponse.setter(Builder::ipRestrictionRuleMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRestrictionRuleMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> VPC_ID_RESTRICTION_RULE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("VpcIdRestrictionRuleMap").getter(DescribeIpRestrictionResponse.getter(DescribeIpRestrictionResponse::vpcIdRestrictionRuleMap)).setter(DescribeIpRestrictionResponse.setter(Builder::vpcIdRestrictionRuleMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIdRestrictionRuleMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> VPC_ENDPOINT_ID_RESTRICTION_RULE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("VpcEndpointIdRestrictionRuleMap").getter(DescribeIpRestrictionResponse.getter(DescribeIpRestrictionResponse::vpcEndpointIdRestrictionRuleMap)).setter(DescribeIpRestrictionResponse.setter(Builder::vpcEndpointIdRestrictionRuleMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointIdRestrictionRuleMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(DescribeIpRestrictionResponse.getter(DescribeIpRestrictionResponse::enabled)).setter(DescribeIpRestrictionResponse.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeIpRestrictionResponse.getter(DescribeIpRestrictionResponse::requestId)).setter(DescribeIpRestrictionResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeIpRestrictionResponse.getter(DescribeIpRestrictionResponse::status)).setter(DescribeIpRestrictionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, IP_RESTRICTION_RULE_MAP_FIELD, VPC_ID_RESTRICTION_RULE_MAP_FIELD, VPC_ENDPOINT_ID_RESTRICTION_RULE_MAP_FIELD, ENABLED_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final String awsAccountId;
    private final Map<String, String> ipRestrictionRuleMap;
    private final Map<String, String> vpcIdRestrictionRuleMap;
    private final Map<String, String> vpcEndpointIdRestrictionRuleMap;
    private final Boolean enabled;
    private final String requestId;
    private final Integer status;

    private DescribeIpRestrictionResponse(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.ipRestrictionRuleMap = builder.ipRestrictionRuleMap;
        this.vpcIdRestrictionRuleMap = builder.vpcIdRestrictionRuleMap;
        this.vpcEndpointIdRestrictionRuleMap = builder.vpcEndpointIdRestrictionRuleMap;
        this.enabled = builder.enabled;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final boolean hasIpRestrictionRuleMap() {
        return this.ipRestrictionRuleMap != null && !(this.ipRestrictionRuleMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> ipRestrictionRuleMap() {
        return this.ipRestrictionRuleMap;
    }

    public final boolean hasVpcIdRestrictionRuleMap() {
        return this.vpcIdRestrictionRuleMap != null && !(this.vpcIdRestrictionRuleMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> vpcIdRestrictionRuleMap() {
        return this.vpcIdRestrictionRuleMap;
    }

    public final boolean hasVpcEndpointIdRestrictionRuleMap() {
        return this.vpcEndpointIdRestrictionRuleMap != null && !(this.vpcEndpointIdRestrictionRuleMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> vpcEndpointIdRestrictionRuleMap() {
        return this.vpcEndpointIdRestrictionRuleMap;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpRestrictionRuleMap() ? this.ipRestrictionRuleMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcIdRestrictionRuleMap() ? this.vpcIdRestrictionRuleMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcEndpointIdRestrictionRuleMap() ? this.vpcEndpointIdRestrictionRuleMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpRestrictionResponse)) {
            return false;
        }
        DescribeIpRestrictionResponse other = (DescribeIpRestrictionResponse)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && this.hasIpRestrictionRuleMap() == other.hasIpRestrictionRuleMap() && Objects.equals(this.ipRestrictionRuleMap(), other.ipRestrictionRuleMap()) && this.hasVpcIdRestrictionRuleMap() == other.hasVpcIdRestrictionRuleMap() && Objects.equals(this.vpcIdRestrictionRuleMap(), other.vpcIdRestrictionRuleMap()) && this.hasVpcEndpointIdRestrictionRuleMap() == other.hasVpcEndpointIdRestrictionRuleMap() && Objects.equals(this.vpcEndpointIdRestrictionRuleMap(), other.vpcEndpointIdRestrictionRuleMap()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIpRestrictionResponse").add("AwsAccountId", (Object)this.awsAccountId()).add("IpRestrictionRuleMap", this.hasIpRestrictionRuleMap() ? this.ipRestrictionRuleMap() : null).add("VpcIdRestrictionRuleMap", this.hasVpcIdRestrictionRuleMap() ? this.vpcIdRestrictionRuleMap() : null).add("VpcEndpointIdRestrictionRuleMap", this.hasVpcEndpointIdRestrictionRuleMap() ? this.vpcEndpointIdRestrictionRuleMap() : null).add("Enabled", (Object)this.enabled()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "IpRestrictionRuleMap": {
                return Optional.ofNullable(clazz.cast(this.ipRestrictionRuleMap()));
            }
            case "VpcIdRestrictionRuleMap": {
                return Optional.ofNullable(clazz.cast(this.vpcIdRestrictionRuleMap()));
            }
            case "VpcEndpointIdRestrictionRuleMap": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointIdRestrictionRuleMap()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpRestrictionResponse, T> g) {
        return obj -> g.apply((DescribeIpRestrictionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private Map<String, String> ipRestrictionRuleMap = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> vpcIdRestrictionRuleMap = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> vpcEndpointIdRestrictionRuleMap = DefaultSdkAutoConstructMap.getInstance();
        private Boolean enabled;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpRestrictionResponse model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.ipRestrictionRuleMap(model.ipRestrictionRuleMap);
            this.vpcIdRestrictionRuleMap(model.vpcIdRestrictionRuleMap);
            this.vpcEndpointIdRestrictionRuleMap(model.vpcEndpointIdRestrictionRuleMap);
            this.enabled(model.enabled);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Map<String, String> getIpRestrictionRuleMap() {
            if (this.ipRestrictionRuleMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.ipRestrictionRuleMap;
        }

        public final void setIpRestrictionRuleMap(Map<String, String> ipRestrictionRuleMap) {
            this.ipRestrictionRuleMap = IpRestrictionRuleMapCopier.copy(ipRestrictionRuleMap);
        }

        @Override
        public final Builder ipRestrictionRuleMap(Map<String, String> ipRestrictionRuleMap) {
            this.ipRestrictionRuleMap = IpRestrictionRuleMapCopier.copy(ipRestrictionRuleMap);
            return this;
        }

        public final Map<String, String> getVpcIdRestrictionRuleMap() {
            if (this.vpcIdRestrictionRuleMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.vpcIdRestrictionRuleMap;
        }

        public final void setVpcIdRestrictionRuleMap(Map<String, String> vpcIdRestrictionRuleMap) {
            this.vpcIdRestrictionRuleMap = VpcIdRestrictionRuleMapCopier.copy(vpcIdRestrictionRuleMap);
        }

        @Override
        public final Builder vpcIdRestrictionRuleMap(Map<String, String> vpcIdRestrictionRuleMap) {
            this.vpcIdRestrictionRuleMap = VpcIdRestrictionRuleMapCopier.copy(vpcIdRestrictionRuleMap);
            return this;
        }

        public final Map<String, String> getVpcEndpointIdRestrictionRuleMap() {
            if (this.vpcEndpointIdRestrictionRuleMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.vpcEndpointIdRestrictionRuleMap;
        }

        public final void setVpcEndpointIdRestrictionRuleMap(Map<String, String> vpcEndpointIdRestrictionRuleMap) {
            this.vpcEndpointIdRestrictionRuleMap = VpcEndpointIdRestrictionRuleMapCopier.copy(vpcEndpointIdRestrictionRuleMap);
        }

        @Override
        public final Builder vpcEndpointIdRestrictionRuleMap(Map<String, String> vpcEndpointIdRestrictionRuleMap) {
            this.vpcEndpointIdRestrictionRuleMap = VpcEndpointIdRestrictionRuleMapCopier.copy(vpcEndpointIdRestrictionRuleMap);
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeIpRestrictionResponse build() {
            return new DescribeIpRestrictionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIpRestrictionResponse> {
        public Builder awsAccountId(String var1);

        public Builder ipRestrictionRuleMap(Map<String, String> var1);

        public Builder vpcIdRestrictionRuleMap(Map<String, String> var1);

        public Builder vpcEndpointIdRestrictionRuleMap(Map<String, String> var1);

        public Builder enabled(Boolean var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

