/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a column in a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicColumn implements SdkPojo, Serializable, ToCopyableBuilder<TopicColumn.Builder, TopicColumn> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(TopicColumn::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<String> COLUMN_FRIENDLY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnFriendlyName").getter(getter(TopicColumn::columnFriendlyName))
            .setter(setter(Builder::columnFriendlyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnFriendlyName").build())
            .build();

    private static final SdkField<String> COLUMN_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnDescription").getter(getter(TopicColumn::columnDescription))
            .setter(setter(Builder::columnDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnDescription").build()).build();

    private static final SdkField<List<String>> COLUMN_SYNONYMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ColumnSynonyms")
            .getter(getter(TopicColumn::columnSynonyms))
            .setter(setter(Builder::columnSynonyms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnSynonyms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COLUMN_DATA_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnDataRole").getter(getter(TopicColumn::columnDataRoleAsString))
            .setter(setter(Builder::columnDataRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnDataRole").build()).build();

    private static final SdkField<String> AGGREGATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Aggregation").getter(getter(TopicColumn::aggregationAsString)).setter(setter(Builder::aggregation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()).build();

    private static final SdkField<Boolean> IS_INCLUDED_IN_TOPIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsIncludedInTopic").getter(getter(TopicColumn::isIncludedInTopic))
            .setter(setter(Builder::isIncludedInTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsIncludedInTopic").build()).build();

    private static final SdkField<Boolean> DISABLE_INDEXING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableIndexing").getter(getter(TopicColumn::disableIndexing)).setter(setter(Builder::disableIndexing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableIndexing").build()).build();

    private static final SdkField<ComparativeOrder> COMPARATIVE_ORDER_FIELD = SdkField
            .<ComparativeOrder> builder(MarshallingType.SDK_POJO).memberName("ComparativeOrder")
            .getter(getter(TopicColumn::comparativeOrder)).setter(setter(Builder::comparativeOrder))
            .constructor(ComparativeOrder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparativeOrder").build()).build();

    private static final SdkField<SemanticType> SEMANTIC_TYPE_FIELD = SdkField.<SemanticType> builder(MarshallingType.SDK_POJO)
            .memberName("SemanticType").getter(getter(TopicColumn::semanticType)).setter(setter(Builder::semanticType))
            .constructor(SemanticType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SemanticType").build()).build();

    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeGranularity").getter(getter(TopicColumn::timeGranularityAsString))
            .setter(setter(Builder::timeGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()).build();

    private static final SdkField<List<String>> ALLOWED_AGGREGATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedAggregations")
            .getter(getter(TopicColumn::allowedAggregationsAsStrings))
            .setter(setter(Builder::allowedAggregationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedAggregations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_ALLOWED_AGGREGATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotAllowedAggregations")
            .getter(getter(TopicColumn::notAllowedAggregationsAsStrings))
            .setter(setter(Builder::notAllowedAggregationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAllowedAggregations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DefaultFormatting> DEFAULT_FORMATTING_FIELD = SdkField
            .<DefaultFormatting> builder(MarshallingType.SDK_POJO).memberName("DefaultFormatting")
            .getter(getter(TopicColumn::defaultFormatting)).setter(setter(Builder::defaultFormatting))
            .constructor(DefaultFormatting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultFormatting").build()).build();

    private static final SdkField<Boolean> NEVER_AGGREGATE_IN_FILTER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NeverAggregateInFilter").getter(getter(TopicColumn::neverAggregateInFilter))
            .setter(setter(Builder::neverAggregateInFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NeverAggregateInFilter").build())
            .build();

    private static final SdkField<List<CellValueSynonym>> CELL_VALUE_SYNONYMS_FIELD = SdkField
            .<List<CellValueSynonym>> builder(MarshallingType.LIST)
            .memberName("CellValueSynonyms")
            .getter(getter(TopicColumn::cellValueSynonyms))
            .setter(setter(Builder::cellValueSynonyms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellValueSynonyms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CellValueSynonym> builder(MarshallingType.SDK_POJO)
                                            .constructor(CellValueSynonym::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> NON_ADDITIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NonAdditive").getter(getter(TopicColumn::nonAdditive)).setter(setter(Builder::nonAdditive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonAdditive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            COLUMN_FRIENDLY_NAME_FIELD, COLUMN_DESCRIPTION_FIELD, COLUMN_SYNONYMS_FIELD, COLUMN_DATA_ROLE_FIELD,
            AGGREGATION_FIELD, IS_INCLUDED_IN_TOPIC_FIELD, DISABLE_INDEXING_FIELD, COMPARATIVE_ORDER_FIELD, SEMANTIC_TYPE_FIELD,
            TIME_GRANULARITY_FIELD, ALLOWED_AGGREGATIONS_FIELD, NOT_ALLOWED_AGGREGATIONS_FIELD, DEFAULT_FORMATTING_FIELD,
            NEVER_AGGREGATE_IN_FILTER_FIELD, CELL_VALUE_SYNONYMS_FIELD, NON_ADDITIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final String columnFriendlyName;

    private final String columnDescription;

    private final List<String> columnSynonyms;

    private final String columnDataRole;

    private final String aggregation;

    private final Boolean isIncludedInTopic;

    private final Boolean disableIndexing;

    private final ComparativeOrder comparativeOrder;

    private final SemanticType semanticType;

    private final String timeGranularity;

    private final List<String> allowedAggregations;

    private final List<String> notAllowedAggregations;

    private final DefaultFormatting defaultFormatting;

    private final Boolean neverAggregateInFilter;

    private final List<CellValueSynonym> cellValueSynonyms;

    private final Boolean nonAdditive;

    private TopicColumn(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.columnFriendlyName = builder.columnFriendlyName;
        this.columnDescription = builder.columnDescription;
        this.columnSynonyms = builder.columnSynonyms;
        this.columnDataRole = builder.columnDataRole;
        this.aggregation = builder.aggregation;
        this.isIncludedInTopic = builder.isIncludedInTopic;
        this.disableIndexing = builder.disableIndexing;
        this.comparativeOrder = builder.comparativeOrder;
        this.semanticType = builder.semanticType;
        this.timeGranularity = builder.timeGranularity;
        this.allowedAggregations = builder.allowedAggregations;
        this.notAllowedAggregations = builder.notAllowedAggregations;
        this.defaultFormatting = builder.defaultFormatting;
        this.neverAggregateInFilter = builder.neverAggregateInFilter;
        this.cellValueSynonyms = builder.cellValueSynonyms;
        this.nonAdditive = builder.nonAdditive;
    }

    /**
     * <p>
     * The name of the column.
     * </p>
     * 
     * @return The name of the column.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * A user-friendly name for the column.
     * </p>
     * 
     * @return A user-friendly name for the column.
     */
    public final String columnFriendlyName() {
        return columnFriendlyName;
    }

    /**
     * <p>
     * A description of the column and its contents.
     * </p>
     * 
     * @return A description of the column and its contents.
     */
    public final String columnDescription() {
        return columnDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnSynonyms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnSynonyms() {
        return columnSynonyms != null && !(columnSynonyms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The other names or aliases for the column.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnSynonyms} method.
     * </p>
     * 
     * @return The other names or aliases for the column.
     */
    public final List<String> columnSynonyms() {
        return columnSynonyms;
    }

    /**
     * <p>
     * The role of the column in the data. Valid values are <code>DIMENSION</code> and <code>MEASURE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #columnDataRole}
     * will return {@link ColumnDataRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #columnDataRoleAsString}.
     * </p>
     * 
     * @return The role of the column in the data. Valid values are <code>DIMENSION</code> and <code>MEASURE</code>.
     * @see ColumnDataRole
     */
    public final ColumnDataRole columnDataRole() {
        return ColumnDataRole.fromValue(columnDataRole);
    }

    /**
     * <p>
     * The role of the column in the data. Valid values are <code>DIMENSION</code> and <code>MEASURE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #columnDataRole}
     * will return {@link ColumnDataRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #columnDataRoleAsString}.
     * </p>
     * 
     * @return The role of the column in the data. Valid values are <code>DIMENSION</code> and <code>MEASURE</code>.
     * @see ColumnDataRole
     */
    public final String columnDataRoleAsString() {
        return columnDataRole;
    }

    /**
     * <p>
     * The type of aggregation that is performed on the column data when it's queried.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link DefaultAggregation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggregationAsString}.
     * </p>
     * 
     * @return The type of aggregation that is performed on the column data when it's queried.
     * @see DefaultAggregation
     */
    public final DefaultAggregation aggregation() {
        return DefaultAggregation.fromValue(aggregation);
    }

    /**
     * <p>
     * The type of aggregation that is performed on the column data when it's queried.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link DefaultAggregation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggregationAsString}.
     * </p>
     * 
     * @return The type of aggregation that is performed on the column data when it's queried.
     * @see DefaultAggregation
     */
    public final String aggregationAsString() {
        return aggregation;
    }

    /**
     * <p>
     * A Boolean value that indicates whether the column is included in the query results.
     * </p>
     * 
     * @return A Boolean value that indicates whether the column is included in the query results.
     */
    public final Boolean isIncludedInTopic() {
        return isIncludedInTopic;
    }

    /**
     * <p>
     * A Boolean value that indicates whether the column shows in the autocomplete functionality.
     * </p>
     * 
     * @return A Boolean value that indicates whether the column shows in the autocomplete functionality.
     */
    public final Boolean disableIndexing() {
        return disableIndexing;
    }

    /**
     * <p>
     * The order in which data is displayed for the column when it's used in a comparative context.
     * </p>
     * 
     * @return The order in which data is displayed for the column when it's used in a comparative context.
     */
    public final ComparativeOrder comparativeOrder() {
        return comparativeOrder;
    }

    /**
     * <p>
     * The semantic type of data contained in the column.
     * </p>
     * 
     * @return The semantic type of data contained in the column.
     */
    public final SemanticType semanticType() {
        return semanticType;
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TopicTimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TopicTimeGranularity
     */
    public final TopicTimeGranularity timeGranularity() {
        return TopicTimeGranularity.fromValue(timeGranularity);
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TopicTimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TopicTimeGranularity
     */
    public final String timeGranularityAsString() {
        return timeGranularity;
    }

    /**
     * <p>
     * The list of aggregation types that are allowed for the column. Valid values for this structure are
     * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
     * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
     * <code>VARP</code>, and <code>PERCENTILE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAggregations} method.
     * </p>
     * 
     * @return The list of aggregation types that are allowed for the column. Valid values for this structure are
     *         <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
     *         <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
     *         <code>VARP</code>, and <code>PERCENTILE</code>.
     */
    public final List<AuthorSpecifiedAggregation> allowedAggregations() {
        return AuthorSpecifiedAggregationsCopier.copyStringToEnum(allowedAggregations);
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedAggregations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedAggregations() {
        return allowedAggregations != null && !(allowedAggregations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of aggregation types that are allowed for the column. Valid values for this structure are
     * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
     * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
     * <code>VARP</code>, and <code>PERCENTILE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAggregations} method.
     * </p>
     * 
     * @return The list of aggregation types that are allowed for the column. Valid values for this structure are
     *         <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
     *         <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
     *         <code>VARP</code>, and <code>PERCENTILE</code>.
     */
    public final List<String> allowedAggregationsAsStrings() {
        return allowedAggregations;
    }

    /**
     * <p>
     * The list of aggregation types that are not allowed for the column. Valid values for this structure are
     * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
     * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
     * <code>VARP</code>, and <code>PERCENTILE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotAllowedAggregations} method.
     * </p>
     * 
     * @return The list of aggregation types that are not allowed for the column. Valid values for this structure are
     *         <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
     *         <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
     *         <code>VARP</code>, and <code>PERCENTILE</code>.
     */
    public final List<AuthorSpecifiedAggregation> notAllowedAggregations() {
        return AuthorSpecifiedAggregationsCopier.copyStringToEnum(notAllowedAggregations);
    }

    /**
     * For responses, this returns true if the service returned a value for the NotAllowedAggregations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNotAllowedAggregations() {
        return notAllowedAggregations != null && !(notAllowedAggregations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of aggregation types that are not allowed for the column. Valid values for this structure are
     * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
     * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
     * <code>VARP</code>, and <code>PERCENTILE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotAllowedAggregations} method.
     * </p>
     * 
     * @return The list of aggregation types that are not allowed for the column. Valid values for this structure are
     *         <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
     *         <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
     *         <code>VARP</code>, and <code>PERCENTILE</code>.
     */
    public final List<String> notAllowedAggregationsAsStrings() {
        return notAllowedAggregations;
    }

    /**
     * <p>
     * The default formatting used for values in the column.
     * </p>
     * 
     * @return The default formatting used for values in the column.
     */
    public final DefaultFormatting defaultFormatting() {
        return defaultFormatting;
    }

    /**
     * <p>
     * A Boolean value that indicates whether to aggregate the column data when it's used in a filter context.
     * </p>
     * 
     * @return A Boolean value that indicates whether to aggregate the column data when it's used in a filter context.
     */
    public final Boolean neverAggregateInFilter() {
        return neverAggregateInFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the CellValueSynonyms property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCellValueSynonyms() {
        return cellValueSynonyms != null && !(cellValueSynonyms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The other names or aliases for the column cell value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCellValueSynonyms} method.
     * </p>
     * 
     * @return The other names or aliases for the column cell value.
     */
    public final List<CellValueSynonym> cellValueSynonyms() {
        return cellValueSynonyms;
    }

    /**
     * <p>
     * The non additive value for the column.
     * </p>
     * 
     * @return The non additive value for the column.
     */
    public final Boolean nonAdditive() {
        return nonAdditive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(columnFriendlyName());
        hashCode = 31 * hashCode + Objects.hashCode(columnDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnSynonyms() ? columnSynonyms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(columnDataRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isIncludedInTopic());
        hashCode = 31 * hashCode + Objects.hashCode(disableIndexing());
        hashCode = 31 * hashCode + Objects.hashCode(comparativeOrder());
        hashCode = 31 * hashCode + Objects.hashCode(semanticType());
        hashCode = 31 * hashCode + Objects.hashCode(timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedAggregations() ? allowedAggregationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotAllowedAggregations() ? notAllowedAggregationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultFormatting());
        hashCode = 31 * hashCode + Objects.hashCode(neverAggregateInFilter());
        hashCode = 31 * hashCode + Objects.hashCode(hasCellValueSynonyms() ? cellValueSynonyms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nonAdditive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicColumn)) {
            return false;
        }
        TopicColumn other = (TopicColumn) obj;
        return Objects.equals(columnName(), other.columnName())
                && Objects.equals(columnFriendlyName(), other.columnFriendlyName())
                && Objects.equals(columnDescription(), other.columnDescription())
                && hasColumnSynonyms() == other.hasColumnSynonyms() && Objects.equals(columnSynonyms(), other.columnSynonyms())
                && Objects.equals(columnDataRoleAsString(), other.columnDataRoleAsString())
                && Objects.equals(aggregationAsString(), other.aggregationAsString())
                && Objects.equals(isIncludedInTopic(), other.isIncludedInTopic())
                && Objects.equals(disableIndexing(), other.disableIndexing())
                && Objects.equals(comparativeOrder(), other.comparativeOrder())
                && Objects.equals(semanticType(), other.semanticType())
                && Objects.equals(timeGranularityAsString(), other.timeGranularityAsString())
                && hasAllowedAggregations() == other.hasAllowedAggregations()
                && Objects.equals(allowedAggregationsAsStrings(), other.allowedAggregationsAsStrings())
                && hasNotAllowedAggregations() == other.hasNotAllowedAggregations()
                && Objects.equals(notAllowedAggregationsAsStrings(), other.notAllowedAggregationsAsStrings())
                && Objects.equals(defaultFormatting(), other.defaultFormatting())
                && Objects.equals(neverAggregateInFilter(), other.neverAggregateInFilter())
                && hasCellValueSynonyms() == other.hasCellValueSynonyms()
                && Objects.equals(cellValueSynonyms(), other.cellValueSynonyms())
                && Objects.equals(nonAdditive(), other.nonAdditive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicColumn").add("ColumnName", columnName()).add("ColumnFriendlyName", columnFriendlyName())
                .add("ColumnDescription", columnDescription())
                .add("ColumnSynonyms", hasColumnSynonyms() ? columnSynonyms() : null)
                .add("ColumnDataRole", columnDataRoleAsString()).add("Aggregation", aggregationAsString())
                .add("IsIncludedInTopic", isIncludedInTopic()).add("DisableIndexing", disableIndexing())
                .add("ComparativeOrder", comparativeOrder()).add("SemanticType", semanticType())
                .add("TimeGranularity", timeGranularityAsString())
                .add("AllowedAggregations", hasAllowedAggregations() ? allowedAggregationsAsStrings() : null)
                .add("NotAllowedAggregations", hasNotAllowedAggregations() ? notAllowedAggregationsAsStrings() : null)
                .add("DefaultFormatting", defaultFormatting()).add("NeverAggregateInFilter", neverAggregateInFilter())
                .add("CellValueSynonyms", hasCellValueSynonyms() ? cellValueSynonyms() : null).add("NonAdditive", nonAdditive())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "ColumnFriendlyName":
            return Optional.ofNullable(clazz.cast(columnFriendlyName()));
        case "ColumnDescription":
            return Optional.ofNullable(clazz.cast(columnDescription()));
        case "ColumnSynonyms":
            return Optional.ofNullable(clazz.cast(columnSynonyms()));
        case "ColumnDataRole":
            return Optional.ofNullable(clazz.cast(columnDataRoleAsString()));
        case "Aggregation":
            return Optional.ofNullable(clazz.cast(aggregationAsString()));
        case "IsIncludedInTopic":
            return Optional.ofNullable(clazz.cast(isIncludedInTopic()));
        case "DisableIndexing":
            return Optional.ofNullable(clazz.cast(disableIndexing()));
        case "ComparativeOrder":
            return Optional.ofNullable(clazz.cast(comparativeOrder()));
        case "SemanticType":
            return Optional.ofNullable(clazz.cast(semanticType()));
        case "TimeGranularity":
            return Optional.ofNullable(clazz.cast(timeGranularityAsString()));
        case "AllowedAggregations":
            return Optional.ofNullable(clazz.cast(allowedAggregationsAsStrings()));
        case "NotAllowedAggregations":
            return Optional.ofNullable(clazz.cast(notAllowedAggregationsAsStrings()));
        case "DefaultFormatting":
            return Optional.ofNullable(clazz.cast(defaultFormatting()));
        case "NeverAggregateInFilter":
            return Optional.ofNullable(clazz.cast(neverAggregateInFilter()));
        case "CellValueSynonyms":
            return Optional.ofNullable(clazz.cast(cellValueSynonyms()));
        case "NonAdditive":
            return Optional.ofNullable(clazz.cast(nonAdditive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicColumn, T> g) {
        return obj -> g.apply((TopicColumn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicColumn> {
        /**
         * <p>
         * The name of the column.
         * </p>
         * 
         * @param columnName
         *        The name of the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * A user-friendly name for the column.
         * </p>
         * 
         * @param columnFriendlyName
         *        A user-friendly name for the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnFriendlyName(String columnFriendlyName);

        /**
         * <p>
         * A description of the column and its contents.
         * </p>
         * 
         * @param columnDescription
         *        A description of the column and its contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnDescription(String columnDescription);

        /**
         * <p>
         * The other names or aliases for the column.
         * </p>
         * 
         * @param columnSynonyms
         *        The other names or aliases for the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnSynonyms(Collection<String> columnSynonyms);

        /**
         * <p>
         * The other names or aliases for the column.
         * </p>
         * 
         * @param columnSynonyms
         *        The other names or aliases for the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnSynonyms(String... columnSynonyms);

        /**
         * <p>
         * The role of the column in the data. Valid values are <code>DIMENSION</code> and <code>MEASURE</code>.
         * </p>
         * 
         * @param columnDataRole
         *        The role of the column in the data. Valid values are <code>DIMENSION</code> and <code>MEASURE</code>.
         * @see ColumnDataRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnDataRole
         */
        Builder columnDataRole(String columnDataRole);

        /**
         * <p>
         * The role of the column in the data. Valid values are <code>DIMENSION</code> and <code>MEASURE</code>.
         * </p>
         * 
         * @param columnDataRole
         *        The role of the column in the data. Valid values are <code>DIMENSION</code> and <code>MEASURE</code>.
         * @see ColumnDataRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnDataRole
         */
        Builder columnDataRole(ColumnDataRole columnDataRole);

        /**
         * <p>
         * The type of aggregation that is performed on the column data when it's queried.
         * </p>
         * 
         * @param aggregation
         *        The type of aggregation that is performed on the column data when it's queried.
         * @see DefaultAggregation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultAggregation
         */
        Builder aggregation(String aggregation);

        /**
         * <p>
         * The type of aggregation that is performed on the column data when it's queried.
         * </p>
         * 
         * @param aggregation
         *        The type of aggregation that is performed on the column data when it's queried.
         * @see DefaultAggregation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultAggregation
         */
        Builder aggregation(DefaultAggregation aggregation);

        /**
         * <p>
         * A Boolean value that indicates whether the column is included in the query results.
         * </p>
         * 
         * @param isIncludedInTopic
         *        A Boolean value that indicates whether the column is included in the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isIncludedInTopic(Boolean isIncludedInTopic);

        /**
         * <p>
         * A Boolean value that indicates whether the column shows in the autocomplete functionality.
         * </p>
         * 
         * @param disableIndexing
         *        A Boolean value that indicates whether the column shows in the autocomplete functionality.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableIndexing(Boolean disableIndexing);

        /**
         * <p>
         * The order in which data is displayed for the column when it's used in a comparative context.
         * </p>
         * 
         * @param comparativeOrder
         *        The order in which data is displayed for the column when it's used in a comparative context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparativeOrder(ComparativeOrder comparativeOrder);

        /**
         * <p>
         * The order in which data is displayed for the column when it's used in a comparative context.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComparativeOrder.Builder} avoiding the
         * need to create one manually via {@link ComparativeOrder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComparativeOrder.Builder#build()} is called immediately and its
         * result is passed to {@link #comparativeOrder(ComparativeOrder)}.
         * 
         * @param comparativeOrder
         *        a consumer that will call methods on {@link ComparativeOrder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comparativeOrder(ComparativeOrder)
         */
        default Builder comparativeOrder(Consumer<ComparativeOrder.Builder> comparativeOrder) {
            return comparativeOrder(ComparativeOrder.builder().applyMutation(comparativeOrder).build());
        }

        /**
         * <p>
         * The semantic type of data contained in the column.
         * </p>
         * 
         * @param semanticType
         *        The semantic type of data contained in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticType(SemanticType semanticType);

        /**
         * <p>
         * The semantic type of data contained in the column.
         * </p>
         * This is a convenience method that creates an instance of the {@link SemanticType.Builder} avoiding the need
         * to create one manually via {@link SemanticType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SemanticType.Builder#build()} is called immediately and its
         * result is passed to {@link #semanticType(SemanticType)}.
         * 
         * @param semanticType
         *        a consumer that will call methods on {@link SemanticType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #semanticType(SemanticType)
         */
        default Builder semanticType(Consumer<SemanticType.Builder> semanticType) {
            return semanticType(SemanticType.builder().applyMutation(semanticType).build());
        }

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TopicTimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicTimeGranularity
         */
        Builder timeGranularity(String timeGranularity);

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TopicTimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicTimeGranularity
         */
        Builder timeGranularity(TopicTimeGranularity timeGranularity);

        /**
         * <p>
         * The list of aggregation types that are allowed for the column. Valid values for this structure are
         * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param allowedAggregations
         *        The list of aggregation types that are allowed for the column. Valid values for this structure are
         *        <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAggregationsWithStrings(Collection<String> allowedAggregations);

        /**
         * <p>
         * The list of aggregation types that are allowed for the column. Valid values for this structure are
         * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param allowedAggregations
         *        The list of aggregation types that are allowed for the column. Valid values for this structure are
         *        <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAggregationsWithStrings(String... allowedAggregations);

        /**
         * <p>
         * The list of aggregation types that are allowed for the column. Valid values for this structure are
         * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param allowedAggregations
         *        The list of aggregation types that are allowed for the column. Valid values for this structure are
         *        <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAggregations(Collection<AuthorSpecifiedAggregation> allowedAggregations);

        /**
         * <p>
         * The list of aggregation types that are allowed for the column. Valid values for this structure are
         * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param allowedAggregations
         *        The list of aggregation types that are allowed for the column. Valid values for this structure are
         *        <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAggregations(AuthorSpecifiedAggregation... allowedAggregations);

        /**
         * <p>
         * The list of aggregation types that are not allowed for the column. Valid values for this structure are
         * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param notAllowedAggregations
         *        The list of aggregation types that are not allowed for the column. Valid values for this structure are
         *        <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAllowedAggregationsWithStrings(Collection<String> notAllowedAggregations);

        /**
         * <p>
         * The list of aggregation types that are not allowed for the column. Valid values for this structure are
         * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param notAllowedAggregations
         *        The list of aggregation types that are not allowed for the column. Valid values for this structure are
         *        <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAllowedAggregationsWithStrings(String... notAllowedAggregations);

        /**
         * <p>
         * The list of aggregation types that are not allowed for the column. Valid values for this structure are
         * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param notAllowedAggregations
         *        The list of aggregation types that are not allowed for the column. Valid values for this structure are
         *        <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAllowedAggregations(Collection<AuthorSpecifiedAggregation> notAllowedAggregations);

        /**
         * <p>
         * The list of aggregation types that are not allowed for the column. Valid values for this structure are
         * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param notAllowedAggregations
         *        The list of aggregation types that are not allowed for the column. Valid values for this structure are
         *        <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAllowedAggregations(AuthorSpecifiedAggregation... notAllowedAggregations);

        /**
         * <p>
         * The default formatting used for values in the column.
         * </p>
         * 
         * @param defaultFormatting
         *        The default formatting used for values in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultFormatting(DefaultFormatting defaultFormatting);

        /**
         * <p>
         * The default formatting used for values in the column.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultFormatting.Builder} avoiding the
         * need to create one manually via {@link DefaultFormatting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultFormatting.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultFormatting(DefaultFormatting)}.
         * 
         * @param defaultFormatting
         *        a consumer that will call methods on {@link DefaultFormatting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultFormatting(DefaultFormatting)
         */
        default Builder defaultFormatting(Consumer<DefaultFormatting.Builder> defaultFormatting) {
            return defaultFormatting(DefaultFormatting.builder().applyMutation(defaultFormatting).build());
        }

        /**
         * <p>
         * A Boolean value that indicates whether to aggregate the column data when it's used in a filter context.
         * </p>
         * 
         * @param neverAggregateInFilter
         *        A Boolean value that indicates whether to aggregate the column data when it's used in a filter
         *        context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neverAggregateInFilter(Boolean neverAggregateInFilter);

        /**
         * <p>
         * The other names or aliases for the column cell value.
         * </p>
         * 
         * @param cellValueSynonyms
         *        The other names or aliases for the column cell value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellValueSynonyms(Collection<CellValueSynonym> cellValueSynonyms);

        /**
         * <p>
         * The other names or aliases for the column cell value.
         * </p>
         * 
         * @param cellValueSynonyms
         *        The other names or aliases for the column cell value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellValueSynonyms(CellValueSynonym... cellValueSynonyms);

        /**
         * <p>
         * The other names or aliases for the column cell value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.CellValueSynonym.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.CellValueSynonym#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.CellValueSynonym.Builder#build()} is called
         * immediately and its result is passed to {@link #cellValueSynonyms(List<CellValueSynonym>)}.
         * 
         * @param cellValueSynonyms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.CellValueSynonym.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cellValueSynonyms(java.util.Collection<CellValueSynonym>)
         */
        Builder cellValueSynonyms(Consumer<CellValueSynonym.Builder>... cellValueSynonyms);

        /**
         * <p>
         * The non additive value for the column.
         * </p>
         * 
         * @param nonAdditive
         *        The non additive value for the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonAdditive(Boolean nonAdditive);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private String columnFriendlyName;

        private String columnDescription;

        private List<String> columnSynonyms = DefaultSdkAutoConstructList.getInstance();

        private String columnDataRole;

        private String aggregation;

        private Boolean isIncludedInTopic;

        private Boolean disableIndexing;

        private ComparativeOrder comparativeOrder;

        private SemanticType semanticType;

        private String timeGranularity;

        private List<String> allowedAggregations = DefaultSdkAutoConstructList.getInstance();

        private List<String> notAllowedAggregations = DefaultSdkAutoConstructList.getInstance();

        private DefaultFormatting defaultFormatting;

        private Boolean neverAggregateInFilter;

        private List<CellValueSynonym> cellValueSynonyms = DefaultSdkAutoConstructList.getInstance();

        private Boolean nonAdditive;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicColumn model) {
            columnName(model.columnName);
            columnFriendlyName(model.columnFriendlyName);
            columnDescription(model.columnDescription);
            columnSynonyms(model.columnSynonyms);
            columnDataRole(model.columnDataRole);
            aggregation(model.aggregation);
            isIncludedInTopic(model.isIncludedInTopic);
            disableIndexing(model.disableIndexing);
            comparativeOrder(model.comparativeOrder);
            semanticType(model.semanticType);
            timeGranularity(model.timeGranularity);
            allowedAggregationsWithStrings(model.allowedAggregations);
            notAllowedAggregationsWithStrings(model.notAllowedAggregations);
            defaultFormatting(model.defaultFormatting);
            neverAggregateInFilter(model.neverAggregateInFilter);
            cellValueSynonyms(model.cellValueSynonyms);
            nonAdditive(model.nonAdditive);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getColumnFriendlyName() {
            return columnFriendlyName;
        }

        public final void setColumnFriendlyName(String columnFriendlyName) {
            this.columnFriendlyName = columnFriendlyName;
        }

        @Override
        public final Builder columnFriendlyName(String columnFriendlyName) {
            this.columnFriendlyName = columnFriendlyName;
            return this;
        }

        public final String getColumnDescription() {
            return columnDescription;
        }

        public final void setColumnDescription(String columnDescription) {
            this.columnDescription = columnDescription;
        }

        @Override
        public final Builder columnDescription(String columnDescription) {
            this.columnDescription = columnDescription;
            return this;
        }

        public final Collection<String> getColumnSynonyms() {
            if (columnSynonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return columnSynonyms;
        }

        public final void setColumnSynonyms(Collection<String> columnSynonyms) {
            this.columnSynonyms = SynonymsCopier.copy(columnSynonyms);
        }

        @Override
        public final Builder columnSynonyms(Collection<String> columnSynonyms) {
            this.columnSynonyms = SynonymsCopier.copy(columnSynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnSynonyms(String... columnSynonyms) {
            columnSynonyms(Arrays.asList(columnSynonyms));
            return this;
        }

        public final String getColumnDataRole() {
            return columnDataRole;
        }

        public final void setColumnDataRole(String columnDataRole) {
            this.columnDataRole = columnDataRole;
        }

        @Override
        public final Builder columnDataRole(String columnDataRole) {
            this.columnDataRole = columnDataRole;
            return this;
        }

        @Override
        public final Builder columnDataRole(ColumnDataRole columnDataRole) {
            this.columnDataRole(columnDataRole == null ? null : columnDataRole.toString());
            return this;
        }

        public final String getAggregation() {
            return aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(DefaultAggregation aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public final Boolean getIsIncludedInTopic() {
            return isIncludedInTopic;
        }

        public final void setIsIncludedInTopic(Boolean isIncludedInTopic) {
            this.isIncludedInTopic = isIncludedInTopic;
        }

        @Override
        public final Builder isIncludedInTopic(Boolean isIncludedInTopic) {
            this.isIncludedInTopic = isIncludedInTopic;
            return this;
        }

        public final Boolean getDisableIndexing() {
            return disableIndexing;
        }

        public final void setDisableIndexing(Boolean disableIndexing) {
            this.disableIndexing = disableIndexing;
        }

        @Override
        public final Builder disableIndexing(Boolean disableIndexing) {
            this.disableIndexing = disableIndexing;
            return this;
        }

        public final ComparativeOrder.Builder getComparativeOrder() {
            return comparativeOrder != null ? comparativeOrder.toBuilder() : null;
        }

        public final void setComparativeOrder(ComparativeOrder.BuilderImpl comparativeOrder) {
            this.comparativeOrder = comparativeOrder != null ? comparativeOrder.build() : null;
        }

        @Override
        public final Builder comparativeOrder(ComparativeOrder comparativeOrder) {
            this.comparativeOrder = comparativeOrder;
            return this;
        }

        public final SemanticType.Builder getSemanticType() {
            return semanticType != null ? semanticType.toBuilder() : null;
        }

        public final void setSemanticType(SemanticType.BuilderImpl semanticType) {
            this.semanticType = semanticType != null ? semanticType.build() : null;
        }

        @Override
        public final Builder semanticType(SemanticType semanticType) {
            this.semanticType = semanticType;
            return this;
        }

        public final String getTimeGranularity() {
            return timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TopicTimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final Collection<String> getAllowedAggregations() {
            if (allowedAggregations instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedAggregations;
        }

        public final void setAllowedAggregations(Collection<String> allowedAggregations) {
            this.allowedAggregations = AuthorSpecifiedAggregationsCopier.copy(allowedAggregations);
        }

        @Override
        public final Builder allowedAggregationsWithStrings(Collection<String> allowedAggregations) {
            this.allowedAggregations = AuthorSpecifiedAggregationsCopier.copy(allowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAggregationsWithStrings(String... allowedAggregations) {
            allowedAggregationsWithStrings(Arrays.asList(allowedAggregations));
            return this;
        }

        @Override
        public final Builder allowedAggregations(Collection<AuthorSpecifiedAggregation> allowedAggregations) {
            this.allowedAggregations = AuthorSpecifiedAggregationsCopier.copyEnumToString(allowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAggregations(AuthorSpecifiedAggregation... allowedAggregations) {
            allowedAggregations(Arrays.asList(allowedAggregations));
            return this;
        }

        public final Collection<String> getNotAllowedAggregations() {
            if (notAllowedAggregations instanceof SdkAutoConstructList) {
                return null;
            }
            return notAllowedAggregations;
        }

        public final void setNotAllowedAggregations(Collection<String> notAllowedAggregations) {
            this.notAllowedAggregations = AuthorSpecifiedAggregationsCopier.copy(notAllowedAggregations);
        }

        @Override
        public final Builder notAllowedAggregationsWithStrings(Collection<String> notAllowedAggregations) {
            this.notAllowedAggregations = AuthorSpecifiedAggregationsCopier.copy(notAllowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notAllowedAggregationsWithStrings(String... notAllowedAggregations) {
            notAllowedAggregationsWithStrings(Arrays.asList(notAllowedAggregations));
            return this;
        }

        @Override
        public final Builder notAllowedAggregations(Collection<AuthorSpecifiedAggregation> notAllowedAggregations) {
            this.notAllowedAggregations = AuthorSpecifiedAggregationsCopier.copyEnumToString(notAllowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notAllowedAggregations(AuthorSpecifiedAggregation... notAllowedAggregations) {
            notAllowedAggregations(Arrays.asList(notAllowedAggregations));
            return this;
        }

        public final DefaultFormatting.Builder getDefaultFormatting() {
            return defaultFormatting != null ? defaultFormatting.toBuilder() : null;
        }

        public final void setDefaultFormatting(DefaultFormatting.BuilderImpl defaultFormatting) {
            this.defaultFormatting = defaultFormatting != null ? defaultFormatting.build() : null;
        }

        @Override
        public final Builder defaultFormatting(DefaultFormatting defaultFormatting) {
            this.defaultFormatting = defaultFormatting;
            return this;
        }

        public final Boolean getNeverAggregateInFilter() {
            return neverAggregateInFilter;
        }

        public final void setNeverAggregateInFilter(Boolean neverAggregateInFilter) {
            this.neverAggregateInFilter = neverAggregateInFilter;
        }

        @Override
        public final Builder neverAggregateInFilter(Boolean neverAggregateInFilter) {
            this.neverAggregateInFilter = neverAggregateInFilter;
            return this;
        }

        public final List<CellValueSynonym.Builder> getCellValueSynonyms() {
            List<CellValueSynonym.Builder> result = CellValueSynonymsCopier.copyToBuilder(this.cellValueSynonyms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCellValueSynonyms(Collection<CellValueSynonym.BuilderImpl> cellValueSynonyms) {
            this.cellValueSynonyms = CellValueSynonymsCopier.copyFromBuilder(cellValueSynonyms);
        }

        @Override
        public final Builder cellValueSynonyms(Collection<CellValueSynonym> cellValueSynonyms) {
            this.cellValueSynonyms = CellValueSynonymsCopier.copy(cellValueSynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cellValueSynonyms(CellValueSynonym... cellValueSynonyms) {
            cellValueSynonyms(Arrays.asList(cellValueSynonyms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cellValueSynonyms(Consumer<CellValueSynonym.Builder>... cellValueSynonyms) {
            cellValueSynonyms(Stream.of(cellValueSynonyms).map(c -> CellValueSynonym.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getNonAdditive() {
            return nonAdditive;
        }

        public final void setNonAdditive(Boolean nonAdditive) {
            this.nonAdditive = nonAdditive;
        }

        @Override
        public final Builder nonAdditive(Boolean nonAdditive) {
            this.nonAdditive = nonAdditive;
            return this;
        }

        @Override
        public TopicColumn build() {
            return new TopicColumn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
