/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that tags a column with additional information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagColumnOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<TagColumnOperation.Builder, TagColumnOperation> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(TagColumnOperation::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<List<ColumnTag>> TAGS_FIELD = SdkField
            .<List<ColumnTag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(TagColumnOperation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final List<ColumnTag> tags;

    private TagColumnOperation(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The column that this operation acts on.
     * </p>
     * 
     * @return The column that this operation acts on.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dataset column tag, currently only used for geospatial type tagging.
     * </p>
     * <note>
     * <p>
     * This is not tags for the Amazon Web Services tagging feature.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The dataset column tag, currently only used for geospatial type tagging.</p> <note>
     *         <p>
     *         This is not tags for the Amazon Web Services tagging feature.
     *         </p>
     */
    public final List<ColumnTag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagColumnOperation)) {
            return false;
        }
        TagColumnOperation other = (TagColumnOperation) obj;
        return Objects.equals(columnName(), other.columnName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TagColumnOperation").add("ColumnName", columnName()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TagColumnOperation, T> g) {
        return obj -> g.apply((TagColumnOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagColumnOperation> {
        /**
         * <p>
         * The column that this operation acts on.
         * </p>
         * 
         * @param columnName
         *        The column that this operation acts on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * The dataset column tag, currently only used for geospatial type tagging.
         * </p>
         * <note>
         * <p>
         * This is not tags for the Amazon Web Services tagging feature.
         * </p>
         * </note>
         * 
         * @param tags
         *        The dataset column tag, currently only used for geospatial type tagging.</p> <note>
         *        <p>
         *        This is not tags for the Amazon Web Services tagging feature.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<ColumnTag> tags);

        /**
         * <p>
         * The dataset column tag, currently only used for geospatial type tagging.
         * </p>
         * <note>
         * <p>
         * This is not tags for the Amazon Web Services tagging feature.
         * </p>
         * </note>
         * 
         * @param tags
         *        The dataset column tag, currently only used for geospatial type tagging.</p> <note>
         *        <p>
         *        This is not tags for the Amazon Web Services tagging feature.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(ColumnTag... tags);

        /**
         * <p>
         * The dataset column tag, currently only used for geospatial type tagging.
         * </p>
         * <note>
         * <p>
         * This is not tags for the Amazon Web Services tagging feature.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.ColumnTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnTag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<ColumnTag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ColumnTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<ColumnTag>)
         */
        Builder tags(Consumer<ColumnTag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private List<ColumnTag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TagColumnOperation model) {
            columnName(model.columnName);
            tags(model.tags);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final List<ColumnTag.Builder> getTags() {
            List<ColumnTag.Builder> result = ColumnTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<ColumnTag.BuilderImpl> tags) {
            this.tags = ColumnTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<ColumnTag> tags) {
            this.tags = ColumnTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(ColumnTag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<ColumnTag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> ColumnTag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TagColumnOperation build() {
            return new TagColumnOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
