/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SslProperties implements SdkPojo, Serializable, ToCopyableBuilder<SslProperties.Builder, SslProperties> {
    private static final SdkField<Boolean> DISABLE_SSL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableSsl").getter(getter(SslProperties::disableSsl)).setter(setter(Builder::disableSsl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableSsl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISABLE_SSL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean disableSsl;

    private SslProperties(BuilderImpl builder) {
        this.disableSsl = builder.disableSsl;
    }

    /**
     * <p>
     * A Boolean option to control whether SSL should be disabled.
     * </p>
     * 
     * @return A Boolean option to control whether SSL should be disabled.
     */
    public final Boolean disableSsl() {
        return disableSsl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(disableSsl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SslProperties)) {
            return false;
        }
        SslProperties other = (SslProperties) obj;
        return Objects.equals(disableSsl(), other.disableSsl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SslProperties").add("DisableSsl", disableSsl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisableSsl":
            return Optional.ofNullable(clazz.cast(disableSsl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SslProperties, T> g) {
        return obj -> g.apply((SslProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SslProperties> {
        /**
         * <p>
         * A Boolean option to control whether SSL should be disabled.
         * </p>
         * 
         * @param disableSsl
         *        A Boolean option to control whether SSL should be disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableSsl(Boolean disableSsl);
    }

    static final class BuilderImpl implements Builder {
        private Boolean disableSsl;

        private BuilderImpl() {
        }

        private BuilderImpl(SslProperties model) {
            disableSsl(model.disableSsl);
        }

        public final Boolean getDisableSsl() {
            return disableSsl;
        }

        public final void setDisableSsl(Boolean disableSsl) {
            this.disableSsl = disableSsl;
        }

        @Override
        public final Builder disableSsl(Boolean disableSsl) {
            this.disableSsl = disableSsl;
            return this;
        }

        @Override
        public SslProperties build() {
            return new SslProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
