/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The unaggregated field wells of a scatter plot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScatterPlotUnaggregatedFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<ScatterPlotUnaggregatedFieldWells.Builder, ScatterPlotUnaggregatedFieldWells> {
    private static final SdkField<List<DimensionField>> X_AXIS_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("XAxis")
            .getter(getter(ScatterPlotUnaggregatedFieldWells::xAxis))
            .setter(setter(Builder::xAxis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxis").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionField>> Y_AXIS_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("YAxis")
            .getter(getter(ScatterPlotUnaggregatedFieldWells::yAxis))
            .setter(setter(Builder::yAxis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YAxis").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> SIZE_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("Size")
            .getter(getter(ScatterPlotUnaggregatedFieldWells::size))
            .setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionField>> CATEGORY_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Category")
            .getter(getter(ScatterPlotUnaggregatedFieldWells::category))
            .setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionField>> LABEL_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Label")
            .getter(getter(ScatterPlotUnaggregatedFieldWells::label))
            .setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(X_AXIS_FIELD, Y_AXIS_FIELD,
            SIZE_FIELD, CATEGORY_FIELD, LABEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DimensionField> xAxis;

    private final List<DimensionField> yAxis;

    private final List<MeasureField> size;

    private final List<DimensionField> category;

    private final List<DimensionField> label;

    private ScatterPlotUnaggregatedFieldWells(BuilderImpl builder) {
        this.xAxis = builder.xAxis;
        this.yAxis = builder.yAxis;
        this.size = builder.size;
        this.category = builder.category;
        this.label = builder.label;
    }

    /**
     * For responses, this returns true if the service returned a value for the XAxis property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasXAxis() {
        return xAxis != null && !(xAxis instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The x-axis field well of a scatter plot.
     * </p>
     * <p>
     * The x-axis is a dimension field and cannot be aggregated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasXAxis} method.
     * </p>
     * 
     * @return The x-axis field well of a scatter plot.</p>
     *         <p>
     *         The x-axis is a dimension field and cannot be aggregated.
     */
    public final List<DimensionField> xAxis() {
        return xAxis;
    }

    /**
     * For responses, this returns true if the service returned a value for the YAxis property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasYAxis() {
        return yAxis != null && !(yAxis instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The y-axis field well of a scatter plot.
     * </p>
     * <p>
     * The y-axis is a dimension field and cannot be aggregated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasYAxis} method.
     * </p>
     * 
     * @return The y-axis field well of a scatter plot.</p>
     *         <p>
     *         The y-axis is a dimension field and cannot be aggregated.
     */
    public final List<DimensionField> yAxis() {
        return yAxis;
    }

    /**
     * For responses, this returns true if the service returned a value for the Size property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSize() {
        return size != null && !(size instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The size field well of a scatter plot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSize} method.
     * </p>
     * 
     * @return The size field well of a scatter plot.
     */
    public final List<MeasureField> size() {
        return size;
    }

    /**
     * For responses, this returns true if the service returned a value for the Category property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategory() {
        return category != null && !(category instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The category field well of a scatter plot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategory} method.
     * </p>
     * 
     * @return The category field well of a scatter plot.
     */
    public final List<DimensionField> category() {
        return category;
    }

    /**
     * For responses, this returns true if the service returned a value for the Label property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLabel() {
        return label != null && !(label instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The label field well of a scatter plot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabel} method.
     * </p>
     * 
     * @return The label field well of a scatter plot.
     */
    public final List<DimensionField> label() {
        return label;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasXAxis() ? xAxis() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasYAxis() ? yAxis() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSize() ? size() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCategory() ? category() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLabel() ? label() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScatterPlotUnaggregatedFieldWells)) {
            return false;
        }
        ScatterPlotUnaggregatedFieldWells other = (ScatterPlotUnaggregatedFieldWells) obj;
        return hasXAxis() == other.hasXAxis() && Objects.equals(xAxis(), other.xAxis()) && hasYAxis() == other.hasYAxis()
                && Objects.equals(yAxis(), other.yAxis()) && hasSize() == other.hasSize() && Objects.equals(size(), other.size())
                && hasCategory() == other.hasCategory() && Objects.equals(category(), other.category())
                && hasLabel() == other.hasLabel() && Objects.equals(label(), other.label());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScatterPlotUnaggregatedFieldWells").add("XAxis", hasXAxis() ? xAxis() : null)
                .add("YAxis", hasYAxis() ? yAxis() : null).add("Size", hasSize() ? size() : null)
                .add("Category", hasCategory() ? category() : null).add("Label", hasLabel() ? label() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "XAxis":
            return Optional.ofNullable(clazz.cast(xAxis()));
        case "YAxis":
            return Optional.ofNullable(clazz.cast(yAxis()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScatterPlotUnaggregatedFieldWells, T> g) {
        return obj -> g.apply((ScatterPlotUnaggregatedFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScatterPlotUnaggregatedFieldWells> {
        /**
         * <p>
         * The x-axis field well of a scatter plot.
         * </p>
         * <p>
         * The x-axis is a dimension field and cannot be aggregated.
         * </p>
         * 
         * @param xAxis
         *        The x-axis field well of a scatter plot.</p>
         *        <p>
         *        The x-axis is a dimension field and cannot be aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAxis(Collection<DimensionField> xAxis);

        /**
         * <p>
         * The x-axis field well of a scatter plot.
         * </p>
         * <p>
         * The x-axis is a dimension field and cannot be aggregated.
         * </p>
         * 
         * @param xAxis
         *        The x-axis field well of a scatter plot.</p>
         *        <p>
         *        The x-axis is a dimension field and cannot be aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAxis(DimensionField... xAxis);

        /**
         * <p>
         * The x-axis field well of a scatter plot.
         * </p>
         * <p>
         * The x-axis is a dimension field and cannot be aggregated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #xAxis(List<DimensionField>)}.
         * 
         * @param xAxis
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xAxis(java.util.Collection<DimensionField>)
         */
        Builder xAxis(Consumer<DimensionField.Builder>... xAxis);

        /**
         * <p>
         * The y-axis field well of a scatter plot.
         * </p>
         * <p>
         * The y-axis is a dimension field and cannot be aggregated.
         * </p>
         * 
         * @param yAxis
         *        The y-axis field well of a scatter plot.</p>
         *        <p>
         *        The y-axis is a dimension field and cannot be aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yAxis(Collection<DimensionField> yAxis);

        /**
         * <p>
         * The y-axis field well of a scatter plot.
         * </p>
         * <p>
         * The y-axis is a dimension field and cannot be aggregated.
         * </p>
         * 
         * @param yAxis
         *        The y-axis field well of a scatter plot.</p>
         *        <p>
         *        The y-axis is a dimension field and cannot be aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yAxis(DimensionField... yAxis);

        /**
         * <p>
         * The y-axis field well of a scatter plot.
         * </p>
         * <p>
         * The y-axis is a dimension field and cannot be aggregated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #yAxis(List<DimensionField>)}.
         * 
         * @param yAxis
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #yAxis(java.util.Collection<DimensionField>)
         */
        Builder yAxis(Consumer<DimensionField.Builder>... yAxis);

        /**
         * <p>
         * The size field well of a scatter plot.
         * </p>
         * 
         * @param size
         *        The size field well of a scatter plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Collection<MeasureField> size);

        /**
         * <p>
         * The size field well of a scatter plot.
         * </p>
         * 
         * @param size
         *        The size field well of a scatter plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(MeasureField... size);

        /**
         * <p>
         * The size field well of a scatter plot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #size(List<MeasureField>)}.
         * 
         * @param size
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #size(java.util.Collection<MeasureField>)
         */
        Builder size(Consumer<MeasureField.Builder>... size);

        /**
         * <p>
         * The category field well of a scatter plot.
         * </p>
         * 
         * @param category
         *        The category field well of a scatter plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(Collection<DimensionField> category);

        /**
         * <p>
         * The category field well of a scatter plot.
         * </p>
         * 
         * @param category
         *        The category field well of a scatter plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(DimensionField... category);

        /**
         * <p>
         * The category field well of a scatter plot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #category(List<DimensionField>)}.
         * 
         * @param category
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #category(java.util.Collection<DimensionField>)
         */
        Builder category(Consumer<DimensionField.Builder>... category);

        /**
         * <p>
         * The label field well of a scatter plot.
         * </p>
         * 
         * @param label
         *        The label field well of a scatter plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(Collection<DimensionField> label);

        /**
         * <p>
         * The label field well of a scatter plot.
         * </p>
         * 
         * @param label
         *        The label field well of a scatter plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(DimensionField... label);

        /**
         * <p>
         * The label field well of a scatter plot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #label(List<DimensionField>)}.
         * 
         * @param label
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #label(java.util.Collection<DimensionField>)
         */
        Builder label(Consumer<DimensionField.Builder>... label);
    }

    static final class BuilderImpl implements Builder {
        private List<DimensionField> xAxis = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionField> yAxis = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> size = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionField> category = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionField> label = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScatterPlotUnaggregatedFieldWells model) {
            xAxis(model.xAxis);
            yAxis(model.yAxis);
            size(model.size);
            category(model.category);
            label(model.label);
        }

        public final List<DimensionField.Builder> getXAxis() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.xAxis);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setXAxis(Collection<DimensionField.BuilderImpl> xAxis) {
            this.xAxis = DimensionFieldListCopier.copyFromBuilder(xAxis);
        }

        @Override
        public final Builder xAxis(Collection<DimensionField> xAxis) {
            this.xAxis = DimensionFieldListCopier.copy(xAxis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xAxis(DimensionField... xAxis) {
            xAxis(Arrays.asList(xAxis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xAxis(Consumer<DimensionField.Builder>... xAxis) {
            xAxis(Stream.of(xAxis).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionField.Builder> getYAxis() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.yAxis);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setYAxis(Collection<DimensionField.BuilderImpl> yAxis) {
            this.yAxis = DimensionFieldListCopier.copyFromBuilder(yAxis);
        }

        @Override
        public final Builder yAxis(Collection<DimensionField> yAxis) {
            this.yAxis = DimensionFieldListCopier.copy(yAxis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder yAxis(DimensionField... yAxis) {
            yAxis(Arrays.asList(yAxis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder yAxis(Consumer<DimensionField.Builder>... yAxis) {
            yAxis(Stream.of(yAxis).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getSize() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.size);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSize(Collection<MeasureField.BuilderImpl> size) {
            this.size = MeasureFieldListCopier.copyFromBuilder(size);
        }

        @Override
        public final Builder size(Collection<MeasureField> size) {
            this.size = MeasureFieldListCopier.copy(size);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder size(MeasureField... size) {
            size(Arrays.asList(size));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder size(Consumer<MeasureField.Builder>... size) {
            size(Stream.of(size).map(c -> MeasureField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionField.Builder> getCategory() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.category);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategory(Collection<DimensionField.BuilderImpl> category) {
            this.category = DimensionFieldListCopier.copyFromBuilder(category);
        }

        @Override
        public final Builder category(Collection<DimensionField> category) {
            this.category = DimensionFieldListCopier.copy(category);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder category(DimensionField... category) {
            category(Arrays.asList(category));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder category(Consumer<DimensionField.Builder>... category) {
            category(Stream.of(category).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionField.Builder> getLabel() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.label);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabel(Collection<DimensionField.BuilderImpl> label) {
            this.label = DimensionFieldListCopier.copyFromBuilder(label);
        }

        @Override
        public final Builder label(Collection<DimensionField> label) {
            this.label = DimensionFieldListCopier.copy(label);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder label(DimensionField... label) {
            label(Arrays.asList(label));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder label(Consumer<DimensionField.Builder>... label) {
            label(Stream.of(label).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ScatterPlotUnaggregatedFieldWells build() {
            return new ScatterPlotUnaggregatedFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
